/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.menuhilfe;

import com.google.common.io.Files;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class HilfeDialog
extends Basisdialog {
    private JScrollPane jScrollPane2;
    private JList<String> themen;
    private String[] alle;
    private String[] suche;
    private JLabel beschreibung;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextField suchbegriff;
    private JComboBox themenwahl;

    public HilfeDialog(String string) {
        super(BasisdialogId.DATENBANK_HILFE);
        this.initComponents();
        try {
            this.setTitle(this.i18n.getString("db_fenster12"));
            this.jLabel1.setText(this.i18n.getString("db_gui91"));
            this.suchbegriff.setText(this.i18n.getString("db_gui92"));
            this.jButton1.setText(this.i18n.getString("db_gui4"));
            this.jLabel2.setText(this.i18n.getString("db_gui93"));
            this.beschreibung.setText(this.i18n.getString("db_gui94"));
            for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
                this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
            }
            this.getGuiDesigner().addComponent(this.beschreibung, false);
            if (string.isEmpty()) {
                File file = new File("hilfe" + File.separator + "datenbank");
                this.alle = new String[file.listFiles().length];
                for (int i = 0; i < file.listFiles().length; ++i) {
                    String string2 = file.listFiles()[i].getName();
                    this.alle[i] = string2.substring(0, string2.length() - 5);
                }
                this.themen = new JList<String>(this.alle);
                this.jScrollPane2 = new JScrollPane();
                this.jScrollPane2.setViewportView(this.themen);
                this.getContentPane().add(this.jScrollPane2);
                this.jScrollPane2.setBounds(10, 130, 250, 250);
                MouseAdapter mouseAdapter = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        HilfeDialog.this.getBeschreibung("", HilfeDialog.this.beschreibung);
                    }
                };
                this.themen.addMouseListener(mouseAdapter);
            } else {
                this.setVisible(false);
                KurzTippsDialog kurzTippsDialog = new KurzTippsDialog();
                kurzTippsDialog.setBounds(100, 100, 400, 300);
                kurzTippsDialog.setResizable(false);
                kurzTippsDialog.setAlwaysOnTop(true);
                JLabel jLabel = new JLabel();
                this.getBeschreibung(string, jLabel);
                jLabel.setBounds(kurzTippsDialog.getBounds());
                kurzTippsDialog.add(jLabel);
                kurzTippsDialog.setVisible(true);
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(null, this.i18n.getString("db_f16") + "\n" + exception.toString(), this.i18n.getString("db_f109"), 0);
        }
    }

    private void getBeschreibung(String string, JLabel jLabel) {
        try {
            String string2 = string;
            if (string2.isEmpty()) {
                string2 = this.themen.getSelectedValue();
            }
            List<String> list = Files.readLines(new File("hilfe" + File.separator + "datenbank" + File.separator + string2 + ".html"), Charset.forName("UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : list) {
                stringBuilder.append(string3);
            }
            jLabel.setText(stringBuilder.toString());
        }
        catch (IOException iOException) {
            this.getLogger().error(iOException);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f110") + "\n" + iOException.toString(), this.i18n.getString("db_f110_titel"), 0);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.suchbegriff = new JTextField();
        this.jButton1 = new JButton();
        this.themenwahl = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.beschreibung = new JLabel();
        this.setTitle("Datenbank - Hilfe");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.jLabel1.setText("Geben Sie einen Suchbegriff ein oder waehlen Sie ein Thema aus der Liste aus.");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(10, 10, 460, 24);
        this.suchbegriff.setText("Suchbegriff");
        this.suchbegriff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HilfeDialog.this.suchbegriffActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.suchbegriff);
        this.suchbegriff.setBounds(10, 40, 180, 24);
        this.jButton1.setText("suchen");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HilfeDialog.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.jButton1);
        this.jButton1.setBounds(200, 40, 90, 24);
        this.themenwahl.setModel(new DefaultComboBoxModel<String>(new String[]{"Alle", "Suchergebnisse"}));
        this.themenwahl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HilfeDialog.this.themenwahlActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.themenwahl);
        this.themenwahl.setBounds(10, 100, 180, 24);
        this.jLabel2.setText("Themen:");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(10, 80, 120, 24);
        this.beschreibung.setText("Bitte waehlen Sie einen Begriff aus");
        this.beschreibung.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jScrollPane1.setViewportView(this.beschreibung);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(280, 130, 370, 250);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 673) / 2, (dimension.height - 422) / 2, 673, 422);
    }

    private void suchbegriffActionPerformed(ActionEvent actionEvent) {
        this.starteSuche();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.starteSuche();
    }

    private void starteSuche() {
        this.jButton1.setEnabled(false);
        this.suche = new String[100];
        int n = 0;
        block2: for (int i = 0; i < this.alle.length; ++i) {
            try {
                List<String> list = Files.readLines(new File("hilfe" + File.separator + "datenbank" + File.separator + this.alle[i] + ".html"), Charset.forName("UTF-8"));
                for (String string : list) {
                    String string2 = string.toLowerCase();
                    int n2 = string2.indexOf(this.suchbegriff.getText().toLowerCase());
                    if (n2 == -1) continue;
                    this.suche[n] = this.alle[i];
                    ++n;
                    continue block2;
                }
                continue;
            }
            catch (Exception exception) {
                this.getLogger().error(exception);
            }
        }
        this.themenwahl.setSelectedItem(this.i18n.getString("db_m278"));
        this.jButton1.setEnabled(true);
    }

    private void themenwahlActionPerformed(ActionEvent actionEvent) {
        this.themen = "Alle".equals(this.themenwahl.getSelectedItem().toString()) ? new JList<String>(this.alle) : new JList<String>(this.suche);
        this.jScrollPane2.setViewportView(this.themen);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                HilfeDialog.this.getBeschreibung("", HilfeDialog.this.beschreibung);
            }
        };
        this.themen.addMouseListener(mouseAdapter);
    }

    private class KurzTippsDialog
    extends Basisdialog {
        public KurzTippsDialog() {
            super(BasisdialogId.DATENBANK_KURZTIPPS);
        }
    }
}

