/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.menuhilfe;

import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class InfoDialog
extends Basisdialog {
    public InfoDialog(IDAOhighService iDAOhighService, IObjektnamenRepository iObjektnamenRepository, IKategorienRepository iKategorienRepository, INotizenService iNotizenService) {
        super(BasisdialogId.DATENBANK_INFO);
        this.initComponents();
        this.setTitle(this.i18n.getString("db_fenster13"));
        try {
            JLabel jLabel = new JLabel("<html><table><tr><td>" + this.i18n.getString("db_m70") + "</td><td>" + this.i18n.getString("db_m279_2") + "</td></tr><tr></tr>");
            jLabel.setVisible(true);
            this.add(jLabel);
            this.getGuiDesigner().addComponent(jLabel, false);
            this.setCursor(new Cursor(3));
            long l = 0L;
            List<String> list = iKategorienRepository.getKategorien();
            for (String string : list) {
                long l2 = iDAOhighService.countKategorie(string);
                l += l2;
                String string2 = this.i18n.getUebersetzungFuerAktuelleSprache(string);
                jLabel.setText(jLabel.getText() + "<tr><td>" + string2 + ":</td><td>" + this.i18n.toLocalisedNumber(l2) + "</td></tr>");
                if (!string.equals(ObjektKategorie.PLANETEN.getKategorienName())) continue;
                long l3 = iDAOhighService.countUnserSonnensystem();
                jLabel.setText(jLabel.getText() + "<tr><td>" + this.i18n.getString("db_m466") + ":</td><td>" + this.i18n.toLocalisedNumber(l3) + "</td></tr>");
                long l4 = iDAOhighService.countBestaetigteExoplaneten();
                jLabel.setText(jLabel.getText() + "<tr><td>" + this.i18n.getString("db_m467") + ":</td><td>" + this.i18n.toLocalisedNumber(l4) + "</td></tr>");
                long l5 = iDAOhighService.countNichtBestaetigteExoplaneten();
                jLabel.setText(jLabel.getText() + "<tr><td>" + this.i18n.getString("db_m452") + ":</td><td>" + this.i18n.toLocalisedNumber(l5) + "</td></tr>");
            }
            jLabel.setText(jLabel.getText() + "<tr><td>" + this.i18n.getString("db_m280") + "</td><td>" + this.i18n.toLocalisedNumber(l) + "</td></tr>");
            int n = iObjektnamenRepository.countNames();
            jLabel.setText(jLabel.getText() + "<tr><td>" + this.i18n.getString("db_m281") + "</td><td>" + this.i18n.toLocalisedNumber(n) + "</td></tr>");
            jLabel.setText(jLabel.getText() + "<tr><td>" + this.i18n.getString("db_m282") + "</td><td>" + this.i18n.toLocalisedNumber(Math.round((double)n * 1.0 / ((double)l * 1.0))) + "</td></tr>");
            int n2 = this.getAnzahlBilder();
            int n3 = this.getAnzahlLexikonEintraege();
            long l6 = iNotizenService.countNotizen();
            jLabel.setText(jLabel.getText() + "<tr></tr><tr><td>" + this.i18n.getString("db_m283") + "</td><td>" + this.i18n.toLocalisedNumber(n2) + "</td></tr><tr><td>" + this.i18n.getString("db_m284") + "</td><td>" + this.i18n.toLocalisedNumber(l6) + "</td></tr><tr><td>" + this.i18n.getString("db_m285") + "</td><td>" + this.i18n.toLocalisedNumber(n3) + "</td></tr></table><br></html>");
            this.setCursor(new Cursor(0));
        }
        catch (Exception exception) {
            this.setCursor(new Cursor(0));
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(null, this.i18n.getString("db_f16") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private int getAnzahlLexikonEintraege() {
        File file = new File("lexikon" + File.separator);
        File[] fileArray = file.listFiles(new FileFilter(this){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(".dat");
            }
        });
        if (fileArray != null) {
            return fileArray.length;
        }
        return 0;
    }

    private int getAnzahlBilder() {
        File file = new File("pics" + File.separator);
        File[] fileArray = file.listFiles(new FileFilter(this){

            @Override
            public boolean accept(File file) {
                return file.isFile() && (file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".gif") || file.getName().toLowerCase().endsWith(".bmp"));
            }
        });
        if (fileArray != null) {
            return fileArray.length;
        }
        return 0;
    }

    private void initComponents() {
        this.setTitle("Datenbank Information");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.setSize(new Dimension(400, 644));
        this.setLocationRelativeTo(null);
    }
}

