/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.objektbearbeiten.controler;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.guis.objektbearbeiten.controler.ControlPanelControler;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.ControlPanel;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.MainEditDialog;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.api.ObjectEditTopics;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.eventbus.EventBus;
import de.planetensuche.guidesigner.eventbus.Subscriber;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public final class MainEditControler
implements Subscriber<ObjectEditTopics> {
    private final ILogging logger;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final IDatenbankService datenbankService;
    private final IObjektnamenRepository objektnamenRepository;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private EventBus<ObjectEditTopics> eventBus;
    private MainEditDialog dialog;
    private final long id;
    private boolean objectComboBoxLooked;
    private final PlanetensucheObjektPrueferDAO daoHigh;

    public MainEditControler(IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository, IDatenbankService iDatenbankService, IObjektnamenRepository iObjektnamenRepository, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, PlanetensucheObjektPrueferDAO planetensucheObjektPrueferDAO) {
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.datenbankService = iDatenbankService;
        this.objektnamenRepository = iObjektnamenRepository;
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.daoHigh = planetensucheObjektPrueferDAO;
        this.id = System.currentTimeMillis();
        this.logger = LoggingFactory.getLoggerForClass(MainEditControler.class);
    }

    public void showDialog() {
        try {
            this.eventBus = new EventBus();
            List<String> list = this.entdeckungsmethodenRepository.getEntdeckungsmethoden();
            List<String> list2 = this.datenbankService.getSternbilderNamen(null);
            ActionListener actionListener = this.createActionListenerForSaveButton();
            ControlPanelControler controlPanelControler = new ControlPanelControler(this.eventBus, actionListener);
            ControlPanel controlPanel = controlPanelControler.getControlPanel();
            this.dialog = new MainEditDialog(list, list2, this.eventBus, controlPanel);
            this.setActionListener();
            this.dialog.setVisible(true);
        }
        catch (SQLException sQLException) {
            ISprachcontainer iSprachcontainer = SprachcontainerFabrik.getSprachcontainer();
            this.dialog.showMessageOnMessageBar(iSprachcontainer.getString("db_f16") + " " + sQLException.getLocalizedMessage(), IconPoolDefault.STOP);
        }
    }

    private ActionListener createActionListenerForSaveButton() {
        final ISprachcontainer iSprachcontainer = SprachcontainerFabrik.getSprachcontainer();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    IPlanetensucheObjekt iPlanetensucheObjekt = MainEditControler.this.dialog.getPlanetensucheObject();
                    PlanetensucheObjektPruefer planetensucheObjektPruefer = new PlanetensucheObjektPruefer(MainEditControler.this.daoHigh, iPlanetensucheObjekt);
                    if (iPlanetensucheObjekt.getDatenid() == null) {
                        MainEditControler.this.planetensucheObjektRepository.create(planetensucheObjektPruefer, true, null);
                    } else {
                        MainEditControler.this.planetensucheObjektRepository.update(planetensucheObjektPruefer, true, null);
                    }
                }
                catch (IOException | SQLException exception) {
                    MainEditControler.this.logger.error(exception);
                    JOptionPane.showMessageDialog(MainEditControler.this.dialog, iSprachcontainer.getString("db_f93") + "\n" + exception.toString(), iSprachcontainer.getString("db_f4_titel"), 0);
                }
            }
        };
        return actionListener;
    }

    private void setActionListener() {
        final ISprachcontainer iSprachcontainer = SprachcontainerFabrik.getSprachcontainer();
        this.dialog.setActionCategoryComboBox(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    String string = (String)jComboBox.getSelectedItem();
                    MainEditControler.this.objectComboBoxLooked = true;
                    MainEditControler.this.dialog.fillTabs(string);
                    List<String> list = MainEditControler.this.objektnamenRepository.findAllForCategory(string);
                    MainEditControler.this.dialog.fillListWithObjectnames(list);
                }
                catch (SQLException sQLException) {
                    MainEditControler.this.logger.error(sQLException);
                    JOptionPane.showMessageDialog(MainEditControler.this.dialog, iSprachcontainer.getString("db_f16") + " " + sQLException.toString(), iSprachcontainer.getString("db_f4_titel"), 0);
                }
                MainEditControler.this.objectComboBoxLooked = false;
            }
        });
        this.dialog.setActionObjectComboBox(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (MainEditControler.this.objectComboBoxLooked) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    if (jComboBox.getSelectedIndex() > -1) {
                        String string = (String)jComboBox.getSelectedItem();
                        IPlanetensucheObjekt iPlanetensucheObjekt = MainEditControler.this.planetensucheObjektRepository.read(string);
                        MainEditControler.this.eventBus.publish(ObjectEditTopics.OBJECT_CHANGED, iPlanetensucheObjekt);
                    }
                }
                catch (Exception exception) {
                    MainEditControler.this.logger.error(exception);
                    JOptionPane.showMessageDialog(MainEditControler.this.dialog, iSprachcontainer.getString("db_f16") + " " + exception.toString(), iSprachcontainer.getString("db_f4_titel"), 0);
                }
            }
        });
        this.dialog.setActionNewObjectButton(new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
    }

    @Override
    public void onEvent(ObjectEditTopics objectEditTopics, Object object) {
    }

    @Override
    public long getSubscriberId() {
        return this.id;
    }

    void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }
}

