/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.objektbearbeiten.view;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.ControlPanel;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.CoordinatesPanel;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.DiscoveryPanel;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.MainPropertyPanel;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.PicturesAndNotesPanel;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.api.ObjectEditTopics;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.category.CategoryPanel;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.category.CategoryPanelFactory;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.eventbus.EventBus;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class MainEditDialog
extends Basisdialog
implements ActionListener {
    private final List<String> discoveryMethods;
    private final List<String> constellationNames;
    private final EventBus<ObjectEditTopics> eventBus;
    private final CategoryPanelFactory categoryPanelFactory;
    private MainPropertyPanel mainPropertyPanel;
    private CategoryPanel categoryPanel;
    private CoordinatesPanel coordinatesPanel;
    private DiscoveryPanel discoveryPanel;
    private PicturesAndNotesPanel picturesAndNotesPanel;
    private JPanel categoryTab;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JButton jumpToButton;
    private JPanel mainPropertyTab;
    private JButton newButton;
    private JComboBox objectCategoryComboBox;
    private JComboBox objectComboBox;
    private JTabbedPane tabpane;

    public MainEditDialog(List<String> list, List<String> list2, EventBus<ObjectEditTopics> eventBus, ControlPanel controlPanel) {
        super(BasisdialogId.DATENBANK_MAIN_EDIT_DIALOG);
        this.discoveryMethods = list;
        this.constellationNames = list2;
        this.eventBus = eventBus;
        this.categoryPanelFactory = new CategoryPanelFactory(eventBus);
        this.initComponents();
        this.setTitle(this.i18n.getString("db_fenster4"));
        this.jMenu1.setText(this.i18n.getString("db_menu_29"));
        this.jMenuItem1.setText(this.i18n.getString("db_menu_30"));
        this.jLabel1.setText(this.i18n.getString("db_gui17"));
        this.jLabel2.setText(this.i18n.getString("db_gui18"));
        this.newButton.setText(null);
        this.newButton.setToolTipText(this.i18n.getString("db_gui19"));
        this.newButton.setIcon(IconPoolDefault.EDIT.getImageIcon());
        this.newButton.setSize(24, 24);
        this.jumpToButton.setText(null);
        this.jumpToButton.setToolTipText(this.i18n.getString("db_gui20"));
        this.jumpToButton.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.jumpToButton.setSize(24, 24);
        for (String string : this.i18n.getPlanetensucheObjektKategorien()) {
            this.objectCategoryComboBox.addItem(string);
        }
        this.objectCategoryComboBox.removeItem(this.i18n.getString("ps_sternbilder"));
        this.add(controlPanel);
        controlPanel.setBounds(this.tabpane.getX(), this.tabpane.getY() + this.tabpane.getHeight() + 10, this.tabpane.getWidth(), 140);
        this.mainPropertyPanel = new MainPropertyPanel(eventBus);
        this.picturesAndNotesPanel = new PicturesAndNotesPanel(eventBus);
    }

    public void setActionCategoryComboBox(ActionListener actionListener) {
        this.objectCategoryComboBox.addActionListener(actionListener);
    }

    public void setActionObjectComboBox(ActionListener actionListener) {
        this.objectComboBox.addActionListener(actionListener);
    }

    public void setActionNewObjectButton(ActionListener actionListener) {
        this.newButton.addActionListener(actionListener);
    }

    public void fillListWithObjectnames(List<String> list) {
        try {
            this.objectComboBox.removeAllItems();
            for (String string : list) {
                this.objectComboBox.addItem(string);
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f94") + ":\n" + exception.toString(), this.i18n.getString("db_f9_titel"), 0);
        }
    }

    public IPlanetensucheObjekt getPlanetensucheObject() throws SQLException {
        PlanetensucheObjekt planetensucheObjekt = new PlanetensucheObjekt();
        this.mainPropertyPanel.fillObject(planetensucheObjekt);
        this.categoryPanel.fillObject(planetensucheObjekt);
        this.picturesAndNotesPanel.fillObject(planetensucheObjekt);
        if (this.coordinatesPanel != null) {
            this.coordinatesPanel.fillObject(planetensucheObjekt);
        }
        if (this.discoveryPanel != null) {
            this.discoveryPanel.fillObject(planetensucheObjekt);
        }
        return planetensucheObjekt;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.objectCategoryComboBox = new JComboBox();
        this.objectComboBox = new JComboBox();
        this.newButton = new JButton();
        this.jumpToButton = new JButton();
        this.tabpane = new JTabbedPane();
        this.mainPropertyTab = new JPanel();
        this.categoryTab = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Objektkategorie:");
        this.jLabel2.setText("Objekt bearbeiten:");
        this.newButton.setText("neu");
        this.jumpToButton.setText("springe zu");
        this.mainPropertyTab.setLayout(new GridBagLayout());
        this.tabpane.addTab("tab1", this.mainPropertyTab);
        this.categoryTab.setLayout(new GridBagLayout());
        this.tabpane.addTab("tab2", this.categoryTab);
        this.jMenu1.setText("Loeschen");
        this.jMenuItem1.setText("nach Datum");
        this.jMenuItem1.addActionListener(this);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 170, -2).addGap(10, 10, 10).addComponent(this.objectCategoryComboBox, -2, 210, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel2, -2, 180, -2).addGap(0, 0, 0).addComponent(this.objectComboBox, -2, 210, -2).addGap(10, 10, 10).addComponent(this.newButton, -2, 100, -2).addGap(10, 10, 10).addComponent(this.jumpToButton, -2, 100, -2)).addComponent(this.tabpane)).addContainerGap(25, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 24, -2).addComponent(this.objectCategoryComboBox, -2, 24, -2)).addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 24, -2).addComponent(this.objectComboBox, -2, 24, -2).addComponent(this.newButton, -2, 24, -2).addComponent(this.jumpToButton, -2, 24, -2)).addGap(18, 18, 18).addComponent(this.tabpane, -2, 531, -2).addContainerGap(139, Short.MAX_VALUE)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.jMenuItem1) {
            this.jMenuItem1ActionPerformed(actionEvent);
        }
    }

    public void fillTabs(String string) {
        this.tabpane.removeAll();
        this.tabpane.addTab(this.i18n.getString("db_gui104"), this.mainPropertyPanel);
        this.categoryPanel = this.categoryPanelFactory.createCategoryPanel(string);
        this.tabpane.addTab("Kategorie-TODO", (JPanel)((Object)this.categoryPanel));
        if (string.equals(this.i18n.getString("ps_sterne")) || string.equals(this.i18n.getString("ps_sternhaufen")) || string.equals(this.i18n.getString("ps_br_zwerge")) || string.equals(this.i18n.getString("ps_glx_neb")) || string.equals(this.i18n.getString("ps_glxhaufen")) || string.equals(this.i18n.getString("ps_sonstiges"))) {
            this.coordinatesPanel = new CoordinatesPanel(this.constellationNames, this.eventBus);
            this.tabpane.addTab("Koords-TODO", this.coordinatesPanel);
        } else {
            this.coordinatesPanel = null;
        }
        if (!string.equals(this.i18n.getString("ps_sterne"))) {
            this.discoveryPanel = new DiscoveryPanel(string, this.discoveryMethods, this.eventBus);
            this.tabpane.addTab("Entdecker-TODO", this.discoveryPanel);
        } else {
            this.discoveryPanel = null;
        }
        String string2 = this.i18n.getString("db_gui105");
        this.tabpane.addTab(string2, this.picturesAndNotesPanel);
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
    }
}

