/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.objektbearbeiten.view.category;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.api.ObjectEditTopics;
import de.planetensuche.datenbank.guis.objektbearbeiten.view.category.CategoryPanel;
import de.planetensuche.guidesigner.eventbus.EventBus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;

public final class AsteroidsPanel
extends JPanel
implements CategoryPanel {
    private final EventBus<ObjectEditTopics> eventBus;
    private JTextField albedoTextField;
    private JTextField diameterTextField;
    private JTextField distanceTextField;
    private JTextField eccentricityTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JTextField massTextField;
    private JTextField periodTextField;
    private JComboBox spTypeComboBox;

    public AsteroidsPanel(EventBus<ObjectEditTopics> eventBus) {
        this.eventBus = eventBus;
        this.initComponents();
        this.addAncestorListener(this);
    }

    @Override
    public void onEvent(ObjectEditTopics objectEditTopics, Object object) {
        if (ObjectEditTopics.OBJECT_CHANGED.equals((Object)objectEditTopics)) {
            IPlanetensucheObjekt iPlanetensucheObjekt = (IPlanetensucheObjekt)object;
            this.handleObjectChange(iPlanetensucheObjekt);
        } else if (ObjectEditTopics.CLEAR_INPUT_FIELDS.equals((Object)objectEditTopics)) {
            this.handleClearInputFields();
        }
    }

    @Override
    public void fillObject(IPlanetensucheObjekt iPlanetensucheObjekt) {
    }

    private void handleClearInputFields() {
        this.spTypeComboBox.setSelectedIndex(-1);
        this.distanceTextField.setText("");
        this.massTextField.setText("");
        this.diameterTextField.setText("");
        this.periodTextField.setText("");
        this.eccentricityTextField.setText("");
        this.albedoTextField.setText("");
    }

    private void handleObjectChange(IPlanetensucheObjekt iPlanetensucheObjekt) {
        this.handleClearInputFields();
        if (!iPlanetensucheObjekt.isSpektralklasseUnbekannt()) {
            this.spTypeComboBox.setSelectedItem(iPlanetensucheObjekt.getSpektralklasse());
        }
        if (!iPlanetensucheObjekt.isEntfernungUnbekannt()) {
            this.distanceTextField.setText("" + iPlanetensucheObjekt.getEntfernung());
        }
        if (!iPlanetensucheObjekt.isMasseUnbekannt()) {
            this.massTextField.setText("" + iPlanetensucheObjekt.getMasse());
        }
        if (!iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
            this.diameterTextField.setText("" + iPlanetensucheObjekt.getDurchmesser());
        }
        if (!iPlanetensucheObjekt.isUmlaufszeitUnbekannt()) {
            this.periodTextField.setText("" + iPlanetensucheObjekt.getUmlaufszeit());
        }
        if (!iPlanetensucheObjekt.isExzentritaetUnbekannt()) {
            this.eccentricityTextField.setText("" + iPlanetensucheObjekt.getExzentritaet());
        }
        if (!iPlanetensucheObjekt.isAlbedoUnbekannt()) {
            this.albedoTextField.setText("" + iPlanetensucheObjekt.getAlbedo());
        }
    }

    @Override
    public long getSubscriberId() {
        return this.hashCode();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.eventBus.subscribe(ObjectEditTopics.OBJECT_CHANGED, this);
        this.eventBus.subscribe(ObjectEditTopics.CLEAR_INPUT_FIELDS, this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.eventBus.unsubscribe(ObjectEditTopics.OBJECT_CHANGED, this);
        this.eventBus.unsubscribe(ObjectEditTopics.CLEAR_INPUT_FIELDS, this);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.spTypeComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.distanceTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.massTextField = new JTextField();
        this.diameterTextField = new JTextField();
        this.periodTextField = new JTextField();
        this.eccentricityTextField = new JTextField();
        this.albedoTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("sptyp:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.spTypeComboBox.setMinimumSize(new Dimension(120, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.spTypeComboBox, gridBagConstraints);
        this.jLabel2.setText("halbachse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.distanceTextField.setMinimumSize(new Dimension(120, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.distanceTextField, gridBagConstraints);
        this.jLabel3.setText("masse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("durchmesser:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("umlaufszeit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("exzent:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("albedo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.massTextField.setMinimumSize(new Dimension(120, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.massTextField, gridBagConstraints);
        this.diameterTextField.setMinimumSize(new Dimension(120, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.diameterTextField, gridBagConstraints);
        this.periodTextField.setMinimumSize(new Dimension(120, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.periodTextField, gridBagConstraints);
        this.eccentricityTextField.setMinimumSize(new Dimension(120, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.add((Component)this.eccentricityTextField, gridBagConstraints);
        this.albedoTextField.setMinimumSize(new Dimension(120, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.add((Component)this.albedoTextField, gridBagConstraints);
    }
}

