/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer;

import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.importierer.ImportDialog;
import de.planetensuche.datenbank.importierer.api.FileImporter;
import de.planetensuche.datenbank.importierer.api.ImportController;
import de.planetensuche.datenbank.importierer.csv.AllNasaExoplanetImporter;
import de.planetensuche.datenbank.importierer.csv.CtoiToiCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.NasaExoplanetCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.NasaK2NamesCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.NasaKeplerNamesCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.ParisExoplanetCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.nasa.CsvFileNames;
import de.planetensuche.datenbank.importierer.tsvimport.ImportthreadTSV;
import de.planetensuche.datenbank.importierer.xml.ImportthreadXML;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IGaiaStarsRepository;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class FileImporterFactory {
    private final ISprachcontainer i18n = SprachcontainerFabrik.getSprachcontainer();
    private final ImportDialog dialog;
    private final ParameterDto parameter;
    private final IStart startDatenbank;
    private final InjectionDto injectionDto;
    private final ImportController controller;
    private final Katalogerkenner katalogerkennerService;
    private final KonfigurationDTO globaleKonfig;
    private final IDatenbankverbinder datenbankverbinder;
    private final IGaiaStarsRepository gaiaStarsRepo;

    public FileImporterFactory(ImportDialog importDialog, ParameterDto parameterDto, IStart iStart, InjectionDto injectionDto, ImportController importController, Katalogerkenner katalogerkenner, KonfigurationDTO konfigurationDTO, IDatenbankverbinder iDatenbankverbinder, IGaiaStarsRepository iGaiaStarsRepository) {
        this.dialog = importDialog;
        this.parameter = parameterDto;
        this.startDatenbank = iStart;
        this.injectionDto = injectionDto;
        this.controller = importController;
        this.katalogerkennerService = katalogerkenner;
        this.globaleKonfig = konfigurationDTO;
        this.datenbankverbinder = iDatenbankverbinder;
        this.gaiaStarsRepo = iGaiaStarsRepository;
    }

    public FileImporter get(String string, File file, File file2) throws IOException {
        FileImporter fileImporter = null;
        this.parameter.setQuiet(false);
        if (string.equals(this.i18n.getString("db_m167"))) {
            fileImporter = new ImportthreadXML(file, this.dialog, this.parameter, this.startDatenbank, this.injectionDto, this.datenbankverbinder);
        } else if (string.equals(this.i18n.getString("db_m168"))) {
            fileImporter = new ParisExoplanetCsvImportierer(file, this.controller, this.parameter, this.injectionDto, this.katalogerkennerService, this.globaleKonfig);
        } else if (string.equals(this.i18n.getString("db_m449"))) {
            fileImporter = this.createNasaExoplanetImporter(file);
        } else if (string.equals(this.i18n.getString("db_m453"))) {
            fileImporter = this.createKeplerNamesImporter(file);
        } else if (string.equals(this.i18n.getString("db_m454"))) {
            fileImporter = this.createK2NamesImporter(file);
        } else if (string.equals(this.i18n.getString("db_m169"))) {
            fileImporter = new ImportthreadTSV(file, file2, this.dialog, this.parameter, this.injectionDto, this.katalogerkennerService, this.globaleKonfig);
        } else if (string.equals(this.i18n.getString("db_m461"))) {
            fileImporter = this.createAllNasaFilesImporter(file);
        } else if (string.equals(this.i18n.getString("db_gui135"))) {
            fileImporter = new CtoiToiCsvImportierer(this.parameter, this.injectionDto, this.katalogerkennerService, this.dialog, "temp", this.globaleKonfig, true);
        }
        return fileImporter;
    }

    private FileImporter createAllNasaFilesImporter(File file) throws IOException, IllegalArgumentException {
        File file2 = new File(file.getAbsolutePath() + "/" + CsvFileNames.NASA_EXOPLANETS.getFilename());
        File file3 = new File(file.getAbsolutePath() + "/" + CsvFileNames.NASA_K2_NAMES.getFilename());
        File file4 = new File(file.getAbsolutePath() + "/" + CsvFileNames.NASA_KEPLER_NAMES.getFilename());
        if (!file2.exists()) {
            throw new FileNotFoundException(this.i18n.getString("db_f117") + " " + file2.getAbsolutePath());
        }
        if (!file3.exists()) {
            throw new FileNotFoundException(this.i18n.getString("db_f117") + " " + file3.getAbsolutePath());
        }
        if (!file4.exists()) {
            throw new FileNotFoundException(this.i18n.getString("db_f117") + " " + file4.getAbsolutePath());
        }
        this.parameter.setQuiet(true);
        NasaExoplanetCsvImportierer nasaExoplanetCsvImportierer = this.createNasaExoplanetImporter(file2);
        NasaK2NamesCsvImportierer nasaK2NamesCsvImportierer = this.createK2NamesImporter(file3);
        NasaK2NamesCsvImportierer nasaK2NamesCsvImportierer2 = this.createK2NamesImporter(file3);
        NasaKeplerNamesCsvImportierer nasaKeplerNamesCsvImportierer = this.createKeplerNamesImporter(file4);
        NasaKeplerNamesCsvImportierer nasaKeplerNamesCsvImportierer2 = this.createKeplerNamesImporter(file4);
        AllNasaExoplanetImporter allNasaExoplanetImporter = new AllNasaExoplanetImporter(nasaK2NamesCsvImportierer, nasaK2NamesCsvImportierer2, nasaKeplerNamesCsvImportierer, nasaKeplerNamesCsvImportierer2, nasaExoplanetCsvImportierer, this.injectionDto.getDaoHighService());
        return allNasaExoplanetImporter;
    }

    private NasaKeplerNamesCsvImportierer createKeplerNamesImporter(File file) throws IOException {
        return new NasaKeplerNamesCsvImportierer(file, this.controller, this.parameter, this.injectionDto, this.katalogerkennerService, this.globaleKonfig);
    }

    private NasaK2NamesCsvImportierer createK2NamesImporter(File file) throws IOException {
        return new NasaK2NamesCsvImportierer(file, this.controller, this.parameter, this.injectionDto, this.katalogerkennerService, this.globaleKonfig);
    }

    private NasaExoplanetCsvImportierer createNasaExoplanetImporter(File file) throws IOException {
        return new NasaExoplanetCsvImportierer(file, this.controller, this.parameter, this.injectionDto, this.katalogerkennerService, this.globaleKonfig);
    }
}

