/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer;

import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.importierer.FileImporterFactory;
import de.planetensuche.datenbank.importierer.ImportDialog;
import de.planetensuche.datenbank.importierer.TSVSchemaDialog;
import de.planetensuche.datenbank.importierer.api.FileImporter;
import de.planetensuche.datenbank.importierer.api.ImportController;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IGaiaStarsRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public final class ImportDialogController
implements ImportController {
    private final ILogging logger = LoggingFactory.getLoggerForClass(ImportDialogController.class);
    private ImportDialog dialog;
    private final ParameterDto parameter;
    private final ISprachcontainer i18n;
    private final IDAOhighService daoHighService;
    private final InjectionDto injectionDto;
    private final IStart startDatenbank;
    private File vorherAusgewaehlteDatei;
    private FileImporter importer;
    private File xmldatei;
    private final Katalogerkenner katalogerkennerService;
    private final KonfigurationDTO globaleKonfig;
    private final IDatenbankverbinder datenbankverbinder;
    private final IGaiaStarsRepository gaiaStarsRepo;

    public ImportDialogController(ParameterDto parameterDto, IStart iStart, InjectionDto injectionDto, Katalogerkenner katalogerkenner, KonfigurationDTO konfigurationDTO, IDatenbankverbinder iDatenbankverbinder, IGaiaStarsRepository iGaiaStarsRepository) {
        this.parameter = parameterDto;
        this.i18n = parameterDto.getSprache();
        this.daoHighService = injectionDto.getDaoHighService();
        this.injectionDto = injectionDto;
        this.startDatenbank = iStart;
        this.createDialog();
        this.katalogerkennerService = katalogerkenner;
        this.globaleKonfig = konfigurationDTO;
        this.datenbankverbinder = iDatenbankverbinder;
        this.gaiaStarsRepo = iGaiaStarsRepository;
    }

    @Override
    public void showDialog() {
        this.dialog.setVisible(true);
    }

    private void createDialog() {
        this.dialog = new ImportDialog();
        this.dialog.getjMenuItem1().addActionListener(actionEvent -> this.openTsvSchemaDialog());
        this.dialog.getImportStartenButton().addActionListener(actionEvent -> this.runImport());
        this.dialog.getAbbrechenButton().addActionListener(actionEvent -> this.cancelImport());
        this.dialog.getjMenuExoplanetEU().addActionListener(actionEvent -> this.openUrlInBrowser("http://exoplanet.eu"));
        this.dialog.getjMenuExoplanetenNasa().addActionListener(actionEvent -> this.openUrlInBrowser("https://exoplanetarchive.ipac.caltech.edu/"));
        this.dialog.getjMenuVizier().addActionListener(actionEvent -> this.openUrlInBrowser("https://vizier.u-strasbg.fr/viz-bin/VizieR"));
    }

    private void openTsvSchemaDialog() {
        TSVSchemaDialog tSVSchemaDialog = new TSVSchemaDialog(this.parameter);
        tSVSchemaDialog.setVisible(true);
    }

    @Override
    public void setImportType(String string) {
        this.dialog.setSelectedImportType(string);
    }

    @Override
    public void setObjekteErsetzen(boolean bl) {
        this.dialog.setObjekteErsetzen(bl);
    }

    @Override
    public void setObjekteErgaenzen(boolean bl) {
        this.dialog.setObjekteErgaenzen(bl);
    }

    @Override
    public void setObjekteHinzufuegen(boolean bl) {
        this.dialog.setObjekteHinzufuegen(bl);
    }

    @Override
    public File getXMLDatei() {
        return this.xmldatei;
    }

    @Override
    public ImportDialog getDialog() {
        return this.dialog;
    }

    private void runImport() {
        try {
            if (this.dialog.umleitungInXML() && this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m167"))) {
                JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_m193"), this.i18n.getString("db_m172"), 2);
            } else {
                JFileChooser jFileChooser = this.createFileChooserForFiles();
                this.setFileFilterForFileChooser(jFileChooser);
                int n = jFileChooser.showOpenDialog(this.dialog);
                if (n == 0) {
                    Serializable serializable;
                    int n2;
                    if (this.dialog.umleitungInXML() && (n2 = ((JFileChooser)(serializable = this.createFileChooserForFileAndDir())).showSaveDialog(this.dialog)) == 0) {
                        this.xmldatei = ((JFileChooser)serializable).getSelectedFile();
                        if (!this.xmldatei.getName().endsWith(".xml")) {
                            this.xmldatei = new File(this.xmldatei.getAbsolutePath() + ".xml");
                        }
                    }
                    serializable = jFileChooser.getSelectedFile();
                    this.vorherAusgewaehlteDatei = serializable;
                    this.createAndRunImportThread((File)serializable, this.dialog.getSelectedImportType());
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.dialog.appendOutput(fileNotFoundException.toString());
        }
        catch (Exception exception) {
            this.dialog.appendOutput(this.i18n.getString("db_f16") + ": " + String.valueOf(exception));
            this.logger.error(exception);
        }
    }

    private void setFileFilterForFileChooser(JFileChooser jFileChooser) {
        if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m166"))) {
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setFileFilter(this.createFileFilterForDirectory());
        } else if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m167"))) {
            jFileChooser.setFileFilter(this.createFileFilterForXml());
        } else if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m168"))) {
            jFileChooser.setFileFilter(this.createFileFilterForCsv(this.i18n.getString("db_m168")));
        } else if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m449"))) {
            jFileChooser.setFileFilter(this.createFileFilterForCsv(this.i18n.getString("db_m449")));
        } else if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m453"))) {
            jFileChooser.setFileFilter(this.createFileFilterForCsv(this.i18n.getString("db_m453")));
        } else if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m454"))) {
            jFileChooser.setFileFilter(this.createFileFilterForCsv(this.i18n.getString("db_m454")));
        } else if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_gui135"))) {
            jFileChooser.setFileFilter(this.createFileFilterForCsv(this.i18n.getString("db_gui135")));
        } else if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m169"))) {
            jFileChooser.setFileFilter(this.createFileFilterForCsvTsv());
        } else if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m461"))) {
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setFileFilter(this.createFileFilterForDirectory());
        } else {
            throw new UnsupportedOperationException("import typ '" + this.dialog.getSelectedImportType() + "' nicht unterst\u00fctzt");
        }
    }

    @Override
    public void createAndRunImportThread(File file, String string) throws SQLException, IOException {
        this.dialog.clearOutput();
        this.logger.info("importthread gestartet...");
        FileImporterFactory fileImporterFactory = new FileImporterFactory(this.dialog, this.parameter, this.startDatenbank, this.injectionDto, this, this.katalogerkennerService, this.globaleKonfig, this.datenbankverbinder, this.gaiaStarsRepo);
        this.importer = fileImporterFactory.get(string, file, this.xmldatei);
        if (this.importer != null) {
            this.daoHighService.updateObjektnamenCache();
            this.logger.debug("import starting...");
            this.dialog.setStartButtonEnabled(false);
            this.importer.start();
        } else {
            this.logger.error(new UnsupportedOperationException("no importer available for import type " + string));
        }
    }

    private JFileChooser createFileChooserForFileAndDir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.i18n.getString("db_m195"));
        File file = new File("");
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(this.createFileFilterForXml());
        jFileChooser.setSize(250, 250);
        return jFileChooser;
    }

    private JFileChooser createFileChooserForFiles() {
        JFileChooser jFileChooser = new JFileChooser();
        File file = this.vorherAusgewaehlteDatei == null ? new File("database") : this.vorherAusgewaehlteDatei.getParentFile();
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setSize(250, 250);
        jFileChooser.setVisible(true);
        jFileChooser.setDialogTitle(this.i18n.getString("db_m194"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setSelectedFile(null);
        return jFileChooser;
    }

    private FileFilter createFileFilterForDirectory() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }

            @Override
            public String getDescription() {
                return ImportDialogController.this.i18n.getString("db_m166");
            }
        };
    }

    private FileFilter createFileFilterForXml() {
        return this.createFileFilterForType(this.i18n.getString("db_m167"), ".xml", null);
    }

    private FileFilter createFileFilterForCsvTsv() {
        return this.createFileFilterForType(this.i18n.getString("db_m169"), ".csv", ".tsv");
    }

    private FileFilter createFileFilterForCsv(String string) {
        return this.createFileFilterForType(string, ".csv", null);
    }

    private FileFilter createFileFilterForType(final String string, final String string2, final String ... stringArray) {
        return new FileFilter(this){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (stringArray != null) {
                    boolean bl = file.getName().toLowerCase().endsWith(string2.toLowerCase());
                    if (stringArray.length >= 1) {
                        boolean bl2 = bl = bl || file.getName().toLowerCase().endsWith(stringArray[0].toLowerCase());
                    }
                    if (stringArray.length >= 2) {
                        bl = bl || file.getName().toLowerCase().endsWith(stringArray[1].toLowerCase());
                    }
                    return bl;
                }
                return file.getName().toLowerCase().endsWith(string2.toLowerCase());
            }

            @Override
            public String getDescription() {
                return string;
            }
        };
    }

    private void cancelImport() {
        if (this.importer != null) {
            int n;
            if (this.dialog.getSelectedImportType().equals(this.i18n.getString("db_m169")) && (n = JOptionPane.showConfirmDialog(this.dialog, this.i18n.getString("db_m426"), this.i18n.getString("db_m426_titel"), 1)) == 0) {
                if (this.importer.speichereZwischenstand()) {
                    JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_m427"), this.i18n.getString("db_m214_titel"), 1);
                } else {
                    JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f92"), this.i18n.getString("db_f92_titel"), 0);
                }
            }
            this.importer.interrupt();
            this.dialog.setStartButtonEnabled(true);
        }
    }

    private void openUrlInBrowser(String string) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(string));
            }
        }
        catch (IOException | URISyntaxException exception) {
            this.logger.error(exception);
        }
    }
}

