/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer;

import com.google.common.io.Files;
import de.planetensuche.datenbank.KatalogService;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.importierer.api.TSVSpaltenTyp;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.commons.io.FileUtils;

public final class TSVSchemaDialog
extends Basisdialog {
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private String[] arr;
    private int spaltenNr = -1;
    private String spaltenWert = "";
    private String[] kataloge;
    private JTextField autor;
    private JTextField ignorierenzeichen;
    private JComboBox information;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JComboBox kategorie;
    private JButton loeschenButton;
    private JComboBox schemen;
    private JComboBox spalte;
    private JButton speichernButton;
    private JTextField trennzeichen;

    public TSVSchemaDialog(ParameterDto parameterDto) {
        super(BasisdialogId.DATENBANK_TSV_SCHEMA);
        this.initComponents();
        this.sprache = parameterDto.getSprache();
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.setTitle(this.sprache.getString("db_fenster7"));
        this.jLabel6.setText(this.sprache.getString("db_gui47"));
        this.jLabel9.setText(this.sprache.getString("db_gui110"));
        this.loeschenButton.setText(null);
        this.loeschenButton.setIcon(IconPoolDefault.DELETE.getImageIcon());
        this.loeschenButton.setSize(24, 24);
        this.loeschenButton.setToolTipText(this.sprache.getString("db_gui111"));
        this.speichernButton.setText(null);
        this.speichernButton.setIcon(IconPoolDefault.SAVE.getImageIcon());
        this.speichernButton.setSize(24, 24);
        this.speichernButton.setToolTipText(this.sprache.getString("db_gui115"));
        this.jButton2.setText(this.sprache.getString("db_gui48"));
        this.jLabel1.setText(this.sprache.getString("db_gui49"));
        this.jLabel2.setText(this.sprache.getString("db_gui50"));
        this.jLabel7.setText(this.sprache.getString("db_gui51"));
        this.jLabel8.setText(this.sprache.getString("db_gui52"));
        this.jLabel3.setText(this.sprache.getString("db_gui53"));
        this.jLabel4.setText(this.sprache.getString("db_gui54"));
        this.jLabel5.setText(this.sprache.getString("db_gui55"));
        this.autor.setText(this.sprache.getString("db_gui56"));
        try {
            this.aktualisiereSchemaNamen();
            this.information.setToolTipText(this.sprache.getString("db_m266"));
            List<String> list = this.getKatalognamen();
            this.kataloge = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.kataloge[i] = list.get(i);
            }
            this.kategorie.removeAllItems();
            this.kategorie.addItem(this.sprache.getString("db_gui56"));
            for (String string : this.sprache.getPlanetensucheObjektKategorien()) {
                this.kategorie.addItem(string);
            }
            this.information.removeAllItems();
            this.information.addItem(this.sprache.getString("db_m267"));
            for (TSVSpaltenTyp tSVSpaltenTyp : TSVSpaltenTyp.values()) {
                this.information.addItem(tSVSpaltenTyp.toString());
            }
            this.information.setSelectedIndex(0);
            for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
                this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
            }
            this.ladeSchema();
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(null, this.sprache.getString("db_f100") + "\n" + exception.toString(), this.sprache.getString("db_f4_titel"), 0);
        }
    }

    private List<String> getKatalognamen() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = new KatalogService().ladeKatalogDatei();
        for (String string : list) {
            String[] stringArray = string.split(",");
            arrayList.add(stringArray[0]);
        }
        return arrayList;
    }

    private void ladeSchema() {
        try {
            File file = new File(new File("").getAbsolutePath() + "/temp" + File.separator + "csv_schema.txt");
            if (file.exists()) {
                List<String> list = Files.readLines(file, Charset.forName("UTF-8"));
                for (String string : list) {
                    if (string.startsWith("anzahl=:=")) {
                        this.arr = new String[Integer.parseInt(string.substring(9, string.length()))];
                        continue;
                    }
                    if (string.startsWith("trenner=:=")) {
                        this.trennzeichen.setText(string.substring(10, string.length()));
                        continue;
                    }
                    if (string.startsWith("ignorieren=:=")) {
                        this.ignorierenzeichen.setText(string.substring(13, string.length()));
                        continue;
                    }
                    if (string.startsWith("kategorie=:=")) {
                        this.kategorie.setSelectedItem(string.substring(12, string.length()));
                        continue;
                    }
                    if (string.startsWith("autor=:=")) {
                        this.autor.setText(string.substring(8, string.length()));
                        continue;
                    }
                    if (string.startsWith("version=:=")) continue;
                    String[] stringArray = string.split("=:=");
                    this.arr[Integer.parseInt((String)stringArray[0]) - 1] = stringArray[1];
                }
                this.spalte.removeAllItems();
                this.spalte.addItem(this.sprache.getString("db_m267"));
                for (int i = 1; i <= this.arr.length; ++i) {
                    this.spalte.addItem(Integer.toString(i));
                }
                this.spalte.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(this, this.sprache.getString("db_f100") + "\n" + exception.toString(), this.sprache.getString("db_f4_titel"), 0);
        }
    }

    private boolean aktualisiereSchemaNamen() {
        try {
            this.schemen.removeAllItems();
            this.schemen.addItem(this.sprache.getString("db_m267"));
            File[] fileArray = new File("temp").listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().endsWith(".csvc")) continue;
                this.schemen.addItem(fileArray[i].getName());
            }
            return true;
        }
        catch (Exception exception) {
            this.logging.error(exception);
            return false;
        }
    }

    private void initComponents() {
        this.spalte = new JComboBox();
        this.information = new JComboBox();
        this.speichernButton = new JButton();
        this.jLabel1 = new JLabel();
        this.trennzeichen = new JTextField();
        this.jLabel2 = new JLabel();
        this.ignorierenzeichen = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.kategorie = new JComboBox();
        this.jLabel8 = new JLabel();
        this.autor = new JTextField();
        this.jLabel9 = new JLabel();
        this.schemen = new JComboBox();
        this.loeschenButton = new JButton();
        this.setTitle("beliebige CSV-Datei importieren");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.spalte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TSVSchemaDialog.this.spalteActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.spalte);
        this.spalte.setBounds(10, 390, 200, 24);
        this.information.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TSVSchemaDialog.this.informationActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.information);
        this.information.setBounds(250, 390, 220, 24);
        this.speichernButton.setText("Schema speichern");
        this.speichernButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TSVSchemaDialog.this.speichernButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.speichernButton);
        this.speichernButton.setBounds(250, 430, 160, 24);
        this.jLabel1.setText("Trennzeichen(-kette) fuer Spalten:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(10, 110, 230, 24);
        this.trennzeichen.setText(";");
        this.getContentPane().add(this.trennzeichen);
        this.trennzeichen.setBounds(250, 110, 50, 24);
        this.jLabel2.setText("Zeilen die mit diesem Zeichen/Zeichenkette beginnen ignorieren:");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(10, 140, 400, 24);
        this.ignorierenzeichen.setText("//");
        this.getContentPane().add(this.ignorierenzeichen);
        this.ignorierenzeichen.setBounds(250, 170, 50, 24);
        this.jLabel3.setText("Legen Sie jetzt fest, in welcher Spalte welche Information gespeichert ist:");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(10, 340, 450, 24);
        this.jLabel4.setText("Spalte");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(10, 360, 100, 24);
        this.jLabel5.setText("Information");
        this.getContentPane().add(this.jLabel5);
        this.jLabel5.setBounds(250, 360, 190, 24);
        this.jButton2.setText("neues Schema");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TSVSchemaDialog.this.jButton2ActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.jButton2);
        this.jButton2.setBounds(10, 30, 140, 24);
        this.jLabel6.setText("Pro Zeile darf nur ein Objekt stehen!");
        this.getContentPane().add(this.jLabel6);
        this.jLabel6.setBounds(10, 10, 230, 24);
        this.jLabel7.setText("Soll fuer alle Objekte die selbe Kategorie gelten?");
        this.getContentPane().add(this.jLabel7);
        this.jLabel7.setBounds(10, 210, 460, 24);
        this.getContentPane().add(this.kategorie);
        this.kategorie.setBounds(250, 240, 220, 24);
        this.jLabel8.setText("Soll fuer alle Objekte der selbe Autor gelten?");
        this.getContentPane().add(this.jLabel8);
        this.jLabel8.setBounds(10, 270, 460, 24);
        this.autor.setText("nein");
        this.getContentPane().add(this.autor);
        this.autor.setBounds(250, 300, 220, 24);
        this.jLabel9.setText("aktuell gewaehltes CSV-Schema:");
        this.getContentPane().add(this.jLabel9);
        this.jLabel9.setBounds(250, 10, 200, 24);
        this.schemen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TSVSchemaDialog.this.schemenActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.schemen);
        this.schemen.setBounds(250, 30, 220, 24);
        this.loeschenButton.setText("Schema loeschen");
        this.loeschenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TSVSchemaDialog.this.loeschenButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.loeschenButton);
        this.loeschenButton.setBounds(250, 60, 160, 24);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 493) / 2, (dimension.height - 491) / 2, 493, 491);
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        try {
            String string = JOptionPane.showInputDialog(this, this.sprache.getString("db_m268"), this.sprache.getString("db_m268_titel"), 3);
            if (string != null) {
                int n;
                int n2 = Integer.parseInt(string);
                this.spalte.removeAllItems();
                this.spalte.addItem(this.sprache.getString("db_m267"));
                for (n = 1; n <= n2; ++n) {
                    this.spalte.addItem(Integer.toString(n));
                }
                this.spalte.setSelectedIndex(0);
                this.arr = new String[n2];
                for (n = 0; n < n2; ++n) {
                    this.arr[n] = this.sprache.getString("db_m267");
                }
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(this, exception.toString(), this.sprache.getString("db_f70_titel"), 0);
        }
    }

    private void speichernButtonActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.spaltenNr > -1 && !this.spaltenWert.isEmpty()) {
                this.arr[this.spaltenNr] = this.spaltenWert;
            }
            if ("|".equals(this.trennzeichen.getText())) {
                JOptionPane.showMessageDialog(this, this.sprache.getString("db_f101"), this.sprache.getString("db_f101_titel"), 2);
            } else {
                boolean bl = true;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.arr.length; ++i) {
                    if (!this.arr[i].equals(this.sprache.getString("db_m267"))) continue;
                    bl = false;
                    stringBuilder.append(i).append(", ");
                }
                String string = stringBuilder.toString();
                if (string.length() > 2) {
                    string = string.substring(0, string.length() - 2);
                }
                if (!bl) {
                    JOptionPane.showMessageDialog(this, this.sprache.getString("db_f102") + "\n" + string, this.sprache.getString("db_f101_titel"), 2);
                } else {
                    int n = 0;
                    for (int i = 0; i < this.arr.length; ++i) {
                        if (!"Spalte ignorieren".equals(this.arr[i])) continue;
                        ++n;
                    }
                    if (n == this.arr.length) {
                        JOptionPane.showMessageDialog(this, this.sprache.getString("db_f103"), this.sprache.getString("db_f101_titel"), 2);
                    } else {
                        this.zeigeSpeichernEingabeDialog();
                    }
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.sprache.getString("db_f104") + "\n" + exception.toString(), this.sprache.getString("db_f92_titel"), 0);
        }
    }

    private void zeigeSpeichernEingabeDialog() throws IOException {
        File file = null;
        Object object = JOptionPane.showInputDialog(this, this.sprache.getString("db_m419"), "");
        if (object != null && !((String)object).trim().isEmpty()) {
            if (!((String)(object = ((String)object).trim())).endsWith(".csvc")) {
                object = (String)object + ".csvc";
            }
            file = new File("temp" + File.separator + (String)object);
            int n = 0;
            if (file.exists()) {
                n = JOptionPane.showConfirmDialog(this, this.sprache.getString("db_m254"), this.sprache.getString("db_m254_titel"), 0);
            }
            if (n == 0) {
                this.speicherEinstellungen(file);
                if (this.aktualisiereSchemaNamen()) {
                    this.schemen.setSelectedItem(file.getName());
                }
                JOptionPane.showMessageDialog(this, this.sprache.getString("db_m269"), this.sprache.getString("db_m214_titel"), 1);
            }
        }
    }

    private void speicherEinstellungen(File file) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Charset.forName("UTF-8")));){
            bufferedWriter.write("version=:=2");
            bufferedWriter.newLine();
            bufferedWriter.write("anzahl=:=" + this.arr.length);
            bufferedWriter.newLine();
            bufferedWriter.write("trenner=:=" + this.trennzeichen.getText());
            bufferedWriter.newLine();
            bufferedWriter.write("ignorieren=:=" + this.ignorierenzeichen.getText());
            bufferedWriter.newLine();
            bufferedWriter.write("kategorie=:=" + this.kategorie.getSelectedItem().toString());
            bufferedWriter.newLine();
            bufferedWriter.write("autor=:=" + this.autor.getText());
            bufferedWriter.newLine();
            for (int i = 0; i < this.arr.length; ++i) {
                bufferedWriter.write(i + 1 + "=:=" + this.arr[i]);
                bufferedWriter.newLine();
            }
        }
    }

    private void informationActionPerformed(ActionEvent actionEvent) {
        if (this.information.getItemCount() > 0 && this.spalte.getItemCount() > 0 && this.information.getSelectedIndex() > -1) {
            try {
                if (TSVSpaltenTyp.KATALOG_NR.toString().equals(this.information.getSelectedItem().toString())) {
                    Object object = JOptionPane.showInputDialog(this, this.sprache.getString("db_m270"), this.sprache.getString("db_m270_titel"), 3, null, this.kataloge, this.kataloge[0]);
                    if (object != null) {
                        this.spaltenNr = this.spalte.getSelectedIndex() - 1;
                        this.spaltenWert = this.information.getSelectedItem().toString() + object.toString();
                    }
                } else {
                    this.spaltenNr = this.spalte.getSelectedIndex() - 1;
                    this.spaltenWert = this.information.getSelectedItem().toString();
                }
            }
            catch (Exception exception) {
                this.logging.error(exception);
            }
        }
    }

    private void spalteActionPerformed(ActionEvent actionEvent) {
        if (this.information.getItemCount() > 0 && this.spalte.getItemCount() > 0) {
            try {
                if (this.spaltenNr > -1 && !this.spaltenWert.isEmpty()) {
                    this.arr[this.spaltenNr] = this.spaltenWert;
                }
                if (this.spalte.getSelectedIndex() > 0) {
                    this.information.setSelectedIndex(-1);
                    if (this.arr[this.spalte.getSelectedIndex() - 1].startsWith(TSVSpaltenTyp.KATALOG_NR.name())) {
                        this.information.setSelectedItem(TSVSpaltenTyp.KATALOG_NR.name());
                    } else {
                        this.information.setSelectedItem(this.arr[this.spalte.getSelectedIndex() - 1]);
                    }
                    if (this.information.getSelectedIndex() == -1) {
                        this.information.setSelectedItem(this.sprache.getString("db_m267"));
                    }
                }
            }
            catch (Exception exception) {
                this.logging.error(exception);
            }
        }
    }

    private void schemenActionPerformed(ActionEvent actionEvent) {
        if (this.schemen.getSelectedIndex() > 0) {
            try {
                FileUtils.copyFile(new File(new File("").getAbsolutePath() + "/temp" + File.separator + this.schemen.getSelectedItem().toString()), new File(new File("").getAbsolutePath() + "/temp" + File.separator + "csv_schema.txt"));
                this.ladeSchema();
            }
            catch (IOException iOException) {
                this.logging.error(iOException);
            }
        }
    }

    private void loeschenButtonActionPerformed(ActionEvent actionEvent) {
        try {
            int n;
            if (this.schemen.getSelectedIndex() > 0 && (n = JOptionPane.showConfirmDialog(this, this.sprache.getString("db_m420") + " '" + this.schemen.getSelectedItem().toString() + "' ?", this.sprache.getString("db_m200"), 0, 3)) == 0) {
                File file = new File("temp" + File.separator + this.schemen.getSelectedItem().toString());
                if (file.delete()) {
                    this.aktualisiereSchemaNamen();
                } else {
                    this.logging.warn("Fehler beim Loeschen der Datei '" + file.getName() + "'");
                }
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
        }
    }
}

