/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.exportierer.guis.ExportDialog;
import de.planetensuche.datenbank.exportierer.threads.ExportthreadXML;
import de.planetensuche.datenbank.importierer.api.FileImporter;
import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbank.importierer.csv.ExoplanetDiscovererFinder;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.nasa.ExofopPlanetStatus;
import de.planetensuche.datenbank.importierer.helfer.KorrigiereNamen;
import de.planetensuche.datenbank.importierer.helfer.KorrigiereSpektraltyp;
import de.planetensuche.datenbank.importierer.merge.CheckAndMerge;
import de.planetensuche.datenbank.importierer.merge.ExoplanetMatcher;
import de.planetensuche.datenbank.importierer.merge.PsObjectMergeException;
import de.planetensuche.datenbank.importierer.validator.CatalogNamesValidator;
import de.planetensuche.datenbank.importierer.validator.InvalidCatalogException;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;

public abstract class AbstractCsvImportierer
extends Thread
implements FileImporter {
    final ILogging logger;
    final ISprachcontainer i18n;
    final File csvDatei;
    final File xmlDatei;
    final IImportDialog importDialog;
    final ParameterDto parameter;
    final IPlanetensucheObjektRepository planetensucheObjektRepository;
    final IObjektnamenRepository objektnamenRepository;
    final PlanetensucheObjektPrueferDAO dao;
    final List<String> erfolgreichGespeicherteObjekte;
    final List<String> nichtEingefuegteObjekte;
    final List<IPlanetensucheObjekt> psobjekteFuerXMLDatei;
    int gesamteObjektanzahl;
    int verarbeiteteObjektanzahl;
    final KorrigiereNamen fixNames;
    final KorrigiereSpektraltyp korrigiereSpektraltyp;
    private InjectionDto injectionDto;
    final CheckAndMerge merger;
    private CatalogNamesValidator catalogNamesValidator;
    private final ExoplanetDiscovererFinder discovererFinder;
    private final File invalidCatalogLog = new File("logs/invalid_catalog.log");
    private final File mergeErrorLog = new File("logs/merge_error.log");
    private final KonfigurationDTO globaleKonfig;

    public AbstractCsvImportierer(File file, File file2, IImportDialog iImportDialog, ParameterDto parameterDto, InjectionDto injectionDto, Katalogerkenner katalogerkenner, KonfigurationDTO konfigurationDTO) throws IOException {
        if (iImportDialog == null || file == null) {
            throw new IllegalArgumentException("fehlende Aufrufparameter");
        }
        this.logger = LoggingFactory.getLoggerForClass(AbstractCsvImportierer.class);
        this.csvDatei = file;
        this.xmlDatei = file2;
        this.importDialog = iImportDialog;
        this.parameter = parameterDto;
        this.planetensucheObjektRepository = injectionDto.getPlanetensucheObjektRepository();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.dao = injectionDto.getDao();
        this.injectionDto = injectionDto;
        this.globaleKonfig = konfigurationDTO;
        this.discovererFinder = new ExoplanetDiscovererFinder(injectionDto.getEntdeckerRepository());
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.erfolgreichGespeicherteObjekte = new ArrayList<String>(2000);
        this.nichtEingefuegteObjekte = new ArrayList<String>(10);
        this.psobjekteFuerXMLDatei = new ArrayList<IPlanetensucheObjekt>();
        this.fixNames = new KorrigiereNamen(this.dao, katalogerkenner);
        this.korrigiereSpektraltyp = new KorrigiereSpektraltyp(this.importDialog, this.dao);
        this.catalogNamesValidator = new CatalogNamesValidator(katalogerkenner);
        this.merger = new CheckAndMerge(this.planetensucheObjektRepository, this.dao, this.catalogNamesValidator, injectionDto.getKatalogerkenner());
        try {
            String string = Instant.now().toString() + "\n";
            FileUtils.write(this.invalidCatalogLog, (CharSequence)string, "utf8", false);
            FileUtils.write(this.mergeErrorLog, (CharSequence)string, "utf8", false);
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
    }

    public IImportDialog getImportDialog() {
        return this.importDialog;
    }

    public ILogging getLogging() {
        return this.logger;
    }

    public List<String> getNichtEingefuegteObjekte() {
        return this.nichtEingefuegteObjekte;
    }

    public InjectionDto getInjectionDto() {
        return this.injectionDto;
    }

    @Override
    public boolean speichereZwischenstand() {
        return false;
    }

    @Override
    public void run() {
        try {
            this.importDialog.appendOutput(this.i18n.getString("db_m165_1") + " '" + this.csvDatei.getName() + "' " + this.i18n.getString("db_m165_2"));
            this.importDialog.setStatus(0);
            this.importDialog.setRestzeit(0L);
            this.importDialog.setStartButtonEnabled(false);
            this.importDialog.setCursurWait(true);
            if (this.importiereCsvDatei()) {
                this.importDialog.appendOutput(this.i18n.getString("db_m170"));
                this.importDialog.setStatus(100);
                if (!this.parameter.isQuiet()) {
                    JOptionPane.showMessageDialog(this.importDialog.getDialog(), this.i18n.getString("db_m176"), this.i18n.getString("db_m171_titel"), 1);
                }
            } else {
                this.importDialog.appendOutput(this.i18n.getString("db_m172"));
                JOptionPane.showMessageDialog(this.importDialog.getDialog(), this.i18n.getString("db_f36"), this.i18n.getString("db_f34_titel"), 0);
            }
            if (!this.parameter.isQuiet()) {
                System.out.println("erfolgreich importierte Objekte: " + this.erfolgreichGespeicherteObjekte.size());
                System.out.println("fehlerhafte Objekte: " + this.nichtEingefuegteObjekte.size() + "\n" + String.valueOf(this.nichtEingefuegteObjekte));
            }
        }
        catch (IOException | RuntimeException exception) {
            this.importDialog.appendOutput(this.i18n.getString("db_f34_titel") + "...");
            this.logger.error(exception);
        }
        this.importDialog.setCursurWait(false);
        this.importDialog.setStartButtonEnabled(true);
    }

    void handleInvalidCatalogException(InvalidCatalogException invalidCatalogException, CsvDto csvDto) {
        this.logger.warn(invalidCatalogException.getMessage(), invalidCatalogException);
        this.importDialog.appendOutput(invalidCatalogException.getMessage());
        this.nichtEingefuegteObjekte.add(csvDto.getSternName());
        this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
        try {
            FileUtils.write(this.invalidCatalogLog, (CharSequence)(invalidCatalogException.getMessage() + "\n" + csvDto.toString() + "\n\n"), "utf8", true);
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
    }

    void handleMergeException(PsObjectMergeException psObjectMergeException, CsvDto csvDto) {
        this.logger.warn(psObjectMergeException.getMessage(), psObjectMergeException);
        this.importDialog.appendOutput(psObjectMergeException.getMessage());
        this.nichtEingefuegteObjekte.add(csvDto.getSternName());
        this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
        try {
            FileUtils.write(this.mergeErrorLog, (CharSequence)(psObjectMergeException.getMessage() + "\n" + csvDto.toString() + "\n\n"), "utf8", true);
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
    }

    @Override
    public abstract boolean importiereCsvDatei() throws IOException;

    abstract void setzteSternSptyp(CsvDto var1, PlanetensucheObjektPruefer var2) throws SQLException;

    abstract void setzteSternRa(CsvDto var1, PlanetensucheObjektPruefer var2) throws SQLException;

    abstract void setzteSternDecl(CsvDto var1, PlanetensucheObjektPruefer var2) throws SQLException;

    void aktualisiereFortschrittsbalken(long l) {
        this.importDialog.setStatus(this.verarbeiteteObjektanzahl * 100 / this.gesamteObjektanzahl);
        long l2 = (System.currentTimeMillis() - l) / (long)(this.verarbeiteteObjektanzahl + 1) * (long)(this.gesamteObjektanzahl - (this.verarbeiteteObjektanzahl + 1)) / 1000L;
        this.importDialog.setRestzeit(l2);
    }

    void oeffneExportDialog(IPlanetensucheObjekt[] iPlanetensucheObjektArray) {
        ExportDialog exportDialog = new ExportDialog(this.parameter, this.injectionDto, this.globaleKonfig);
        exportDialog.setVisible(false);
        exportDialog.setUmgeleitetVonImport(iPlanetensucheObjektArray);
        ExportthreadXML exportthreadXML = new ExportthreadXML(this.xmlDatei, exportDialog, this.parameter, this.injectionDto, this.globaleKonfig);
        exportDialog.setVisible(true);
        exportthreadXML.start();
    }

    boolean speichereObjekt(PlanetensucheObjektPruefer planetensucheObjektPruefer, int n) throws SQLException, IOException {
        if (planetensucheObjektPruefer.getEntdeckerMitNachnamenVornamen().containsKey(EntdeckerWeltraumteleskope.TESS.getNameInDatabase())) {
            boolean bl;
            boolean bl2 = bl = planetensucheObjektPruefer.getEntdeckungsjahr() != 0 && planetensucheObjektPruefer.getEntdeckungsjahr() < 2018;
            if (bl || !"Transit-Suchmethode".equals(planetensucheObjektPruefer.getEntdeckungsmethode())) {
                Map<String, String> map = planetensucheObjektPruefer.getEntdeckerMitNachnamenVornamen();
                map.remove(EntdeckerWeltraumteleskope.TESS.getNameInDatabase());
                planetensucheObjektPruefer.setEntdeckerMitNachnamenVornamen(map);
            }
        }
        if (this.importDialog.umleitungInXML()) {
            planetensucheObjektPruefer.setStamp(new Timestamp(System.currentTimeMillis()));
            this.psobjekteFuerXMLDatei.add(planetensucheObjektPruefer);
            return true;
        }
        if (!this.importDialog.test() && this.saveStarOrPlanet(planetensucheObjektPruefer, n)) {
            this.erfolgreichGespeicherteObjekte.add(planetensucheObjektPruefer.getObjektNamen().get(0));
            return true;
        }
        this.nichtEingefuegteObjekte.add(planetensucheObjektPruefer.getObjektNamen().get(0));
        return false;
    }

    private boolean saveStarOrPlanet(PlanetensucheObjektPruefer planetensucheObjektPruefer, int n) throws SQLException, IOException {
        boolean bl = this.objektnamenRepository.gehoertZuEinerDatenid(planetensucheObjektPruefer.getObjektNamen());
        try {
            if (bl) {
                if (n > 0) {
                    boolean bl2;
                    boolean bl3 = bl2 = planetensucheObjektPruefer.isGeaendert() && (this.importDialog.objekteErsetzen() || this.importDialog.objekteUpdaten() || this.importDialog.objekteErgaenzen());
                    if (bl2) {
                        planetensucheObjektPruefer.setStamp(new Timestamp(System.currentTimeMillis()));
                        this.planetensucheObjektRepository.update(planetensucheObjektPruefer, true, this.injectionDto.getKatalogerkenner());
                    }
                    return true;
                }
                if (this.importDialog.objekteHinzufuegen() || this.importDialog.objekteErsetzen()) {
                    this.planetensucheObjektRepository.create(planetensucheObjektPruefer, true, this.injectionDto.getKatalogerkenner());
                    return true;
                }
                this.logger.info("objekt " + String.valueOf(planetensucheObjektPruefer.getObjektNamen()) + " wird nicht gespeichert weil nicht existiert und nicht angelegt werden soll");
            } else {
                boolean bl4 = this.mergeObjekte(planetensucheObjektPruefer);
                if (bl4) {
                    return true;
                }
                this.logger.info("objekt " + String.valueOf(planetensucheObjektPruefer.getObjektNamen()) + " wird nicht gespeichert da der merge mit einem anderen objekt fehl schlug");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().contains("kann nicht erneut eingefuegt werden")) {
                this.logger.debug(String.valueOf(planetensucheObjektPruefer.getObjektNamen()) + ": gehoertZuEinerDatenid? " + bl + ", anzahlExistierenderObjektnamen? " + n);
            }
            throw illegalArgumentException;
        }
        this.logger.warn("objekt nicht gespeichert: " + planetensucheObjektPruefer.toString());
        return false;
    }

    boolean mergeObjekte(PlanetensucheObjektPruefer planetensucheObjektPruefer) {
        this.logger.warn("Objekt '" + planetensucheObjektPruefer.getObjektNamen().toString() + "' kann nicht als 1 Objekt importiert werden, da es in der DB mehrere Objekte sind.");
        return false;
    }

    boolean eigenschaftUebernehmen(Double d, boolean bl) {
        if (CsvDto.istEigenschaftGesetzt(d)) {
            return this.wertUebernehmen(bl);
        }
        return false;
    }

    boolean wertUebernehmen(boolean bl) {
        return this.importDialog.objekteErgaenzen() && bl || !this.importDialog.objekteErgaenzen();
    }

    PlanetensucheObjektPruefer erzeugePlanetensucheObjektFuerStern(int n, List<String> list, String string) throws SQLException, InvalidCatalogException, PsObjectMergeException {
        Set<String> set = this.catalogNamesValidator.validate(list, ObjektKategorie.STERNE);
        PlanetensucheObjektPruefer planetensucheObjektPruefer = new PlanetensucheObjektPruefer(this.dao);
        if (n > 0 && !this.importDialog.umleitungInXML()) {
            Object object;
            List<Integer> list2 = this.objektnamenRepository.getIdsFuerNamen(set);
            if (list2.size() == 1) {
                object = this.planetensucheObjektRepository.read(list2.get(0));
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(object.getObjektNamen());
                arrayList.addAll(set);
                Set<String> set2 = this.catalogNamesValidator.validate(arrayList, ObjektKategorie.STERNE);
                planetensucheObjektPruefer.setDatenVonDto((IPlanetensucheObjekt)object);
                planetensucheObjektPruefer.setObjektNamen(set2);
            } else if (list2.isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("neues objekt erstellen f\u00fcr " + Arrays.toString(set.toArray()));
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    object = "es gibt " + list2.size() + " datenIds f\u00fcr " + Arrays.toString(set.toArray());
                    this.logger.debug(object);
                }
                object = this.merger.checkAndMerge(list2);
                planetensucheObjektPruefer.setDatenVonDto((IPlanetensucheObjekt)object);
            }
            object = new HashSet();
            object.addAll(planetensucheObjektPruefer.getObjektNamen());
            object.addAll(set);
            planetensucheObjektPruefer.setObjektNamen((Set<String>)object);
        } else {
            planetensucheObjektPruefer.setKategorie(ObjektKategorie.STERNE.getKategorienName());
            planetensucheObjektPruefer.setObjekttyp(StarObjectType.SINGLE_STAR.getTypeName());
            HashSet<String> hashSet = new HashSet<String>(set);
            planetensucheObjektPruefer.setObjektNamen(hashSet);
            planetensucheObjektPruefer.setAutor(string);
        }
        return planetensucheObjektPruefer;
    }

    PlanetensucheObjektPruefer erzeugePlanetensucheObjektPlanet(List<String> list, String string, IPlanetensucheObjekt iPlanetensucheObjekt, CsvDto csvDto) throws SQLException, InvalidCatalogException, PsObjectMergeException {
        IPlanetensucheObjekt iPlanetensucheObjekt2 = this.findExistingAndMergeIfNecessary(list, csvDto, iPlanetensucheObjekt, string);
        ExoplanetMatcher exoplanetMatcher = new ExoplanetMatcher();
        Set<Integer> set = iPlanetensucheObjekt.getWirdUmkreistVonIDs();
        if (iPlanetensucheObjekt2.getDatenid() != null) {
            set.remove(iPlanetensucheObjekt2.getDatenid());
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        if (iPlanetensucheObjekt2.getDatenid() != null) {
            arrayList.addAll(iPlanetensucheObjekt2.getObjektNamen());
        }
        for (Integer object2 : set) {
            try {
                IPlanetensucheObjekt illegalArgumentException = this.planetensucheObjektRepository.read(object2);
                if (!exoplanetMatcher.isTheSame(iPlanetensucheObjekt2, illegalArgumentException)) continue;
                this.logger.info("planet " + String.valueOf(illegalArgumentException.getObjektNamen()) + " match with " + String.valueOf(list) + " and will be merged");
                if (iPlanetensucheObjekt2.getDatenid() != null) {
                    iPlanetensucheObjekt2 = this.merger.checkAndMerge(List.of(iPlanetensucheObjekt2.getDatenid(), illegalArgumentException.getDatenid()));
                }
                arrayList.addAll(illegalArgumentException.getObjektNamen());
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.warn("sollte nicht vorkommen", illegalArgumentException);
            }
        }
        Set<String> set2 = this.catalogNamesValidator.validate(arrayList, ObjektKategorie.PLANETEN);
        PlanetensucheObjektPruefer planetensucheObjektPruefer = new PlanetensucheObjektPruefer(this.dao);
        if (iPlanetensucheObjekt2.getDatenid() != null) {
            planetensucheObjektPruefer.setDatenVonDto(iPlanetensucheObjekt2);
            planetensucheObjektPruefer.setObjektNamen(set2);
        } else {
            planetensucheObjektPruefer.setCategory(ObjektKategorie.PLANETEN);
            planetensucheObjektPruefer.setObjekttyp("Planet");
            planetensucheObjektPruefer.setObjektNamen(set2);
            planetensucheObjektPruefer.setAutor(string);
        }
        return planetensucheObjektPruefer;
    }

    private IPlanetensucheObjekt findExistingAndMergeIfNecessary(List<String> list, CsvDto csvDto, IPlanetensucheObjekt iPlanetensucheObjekt, String string) throws SQLException, PsObjectMergeException, InvalidCatalogException {
        Object object;
        HashMap<Integer, IPlanetensucheObjekt> hashMap = new HashMap<Integer, IPlanetensucheObjekt>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : list) {
            try {
                IPlanetensucheObjekt illegalArgumentException = this.planetensucheObjektRepository.read(object2);
                if (illegalArgumentException == null || hashMap.get(illegalArgumentException.getDatenid()) != null) continue;
                hashMap.put(illegalArgumentException.getDatenid(), illegalArgumentException);
                arrayList.addAll(illegalArgumentException.getObjektNamen());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (hashMap.size() == 1) {
            object = (IPlanetensucheObjekt)hashMap.values().iterator().next();
        } else if (hashMap.size() > 1) {
            this.logger.info("existing planets matched by names and will be merged: " + String.valueOf(arrayList));
            object = this.merger.checkAndMerge(hashMap.keySet());
            HashSet<Integer> hashSet = new HashSet<Integer>(iPlanetensucheObjekt.getWirdUmkreistVonIDs());
            hashSet.removeAll(hashMap.keySet());
            hashSet.add(object.getDatenid());
            iPlanetensucheObjekt.setWirdUmkreistVonIDs(hashSet);
        } else {
            object = new PlanetensucheObjekt();
            object.setCategory(ObjektKategorie.PLANETEN);
            if (csvDto.getPlanetUmlaufszeit() != null) {
                object.setUmlaufszeit(csvDto.getPlanetUmlaufszeit());
            }
            object.setUmkreistDatenId(iPlanetensucheObjekt.getDatenid());
            object.setUmkreistObjekt(iPlanetensucheObjekt.getObjektNamen().get(0));
            object.setAutor(string);
        }
        return object;
    }

    void setzteDatenFuerStern(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        this.setzteSternSptyp(csvDto, planetensucheObjektPruefer);
        this.setzteSternRa(csvDto, planetensucheObjektPruefer);
        this.setzteSternDecl(csvDto, planetensucheObjektPruefer);
        if (this.eigenschaftUebernehmen(csvDto.getSternEntfernungInPc(), planetensucheObjektPruefer.isEntfernungUnbekannt())) {
            planetensucheObjektPruefer.setEntfernung(csvDto.getSternEntfernungInPc() * 3.2616);
        }
        if (this.eigenschaftUebernehmen(csvDto.getSternMasse(), planetensucheObjektPruefer.isMasseUnbekannt())) {
            if (ObjektKategorie.BR_ZWERGE.getKategorienName().equals(planetensucheObjektPruefer.getKategorie())) {
                planetensucheObjektPruefer.setMasse(csvDto.getSternMasse() * 1053.997);
            } else {
                planetensucheObjektPruefer.setMasse(csvDto.getSternMasse());
            }
        }
        if (this.eigenschaftUebernehmen(csvDto.getSternMetallizitaet(), planetensucheObjektPruefer.isMetallizitaetUnbekannt())) {
            planetensucheObjektPruefer.setMetallizitaet(csvDto.getSternMetallizitaet());
        }
        if (this.eigenschaftUebernehmen(csvDto.getSternTemperatur(), planetensucheObjektPruefer.isTemperaturUnbekannt())) {
            planetensucheObjektPruefer.setTemperatur(csvDto.getSternTemperatur());
        }
        if (this.eigenschaftUebernehmen(csvDto.getSternAlter(), planetensucheObjektPruefer.isAlterInMrdJahreUnbekannt())) {
            planetensucheObjektPruefer.setAlterInMrdJahre(csvDto.getSternAlter());
        }
        if (this.eigenschaftUebernehmen(csvDto.getSternRadialgeschwindigkeit(), planetensucheObjektPruefer.isGeschwindigkeitUnbekannt())) {
            planetensucheObjektPruefer.setGeschwindigkeit(csvDto.getSternRadialgeschwindigkeit());
        }
        if (this.eigenschaftUebernehmen(csvDto.getSternBv(), planetensucheObjektPruefer.isBVUnbekannt())) {
            planetensucheObjektPruefer.setBV(csvDto.getSternBv());
        }
        if (this.eigenschaftUebernehmen(csvDto.getSternSh(), planetensucheObjektPruefer.isScheinbareHelligkeitUnbekannt())) {
            planetensucheObjektPruefer.setScheinbareHelligkeit(csvDto.getSternSh());
        }
        if (this.eigenschaftUebernehmen(csvDto.getSternRadius(), planetensucheObjektPruefer.isDurchmesserUnbekannt())) {
            if (ObjektKategorie.BR_ZWERGE.getKategorienName().equals(planetensucheObjektPruefer.getKategorie())) {
                planetensucheObjektPruefer.setDurchmesser(csvDto.getSternRadius() * 9.74014);
            } else {
                planetensucheObjektPruefer.setDurchmesser(csvDto.getSternRadius());
            }
        }
    }

    void setzteDatenFuerPlanet(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer, List<String> list, List<String> list2) throws SQLException {
        for (String string : list) {
            if (planetensucheObjektPruefer.setUmkreistObjekt(string)) break;
        }
        if (Check.isEmpty(planetensucheObjektPruefer.getUmkreistObjekt())) {
            throw new IllegalStateException(String.valueOf(list2) + " umkreist " + String.valueOf(list) + " aber Sternbezeichnungen alle invalide!");
        }
        if (this.eigenschaftUebernehmen(csvDto.getPlanetTemperatur(), planetensucheObjektPruefer.isTemperaturUnbekannt())) {
            planetensucheObjektPruefer.setTemperatur(csvDto.getPlanetTemperatur());
        }
        if (this.eigenschaftUebernehmen(csvDto.getPlanetMasse(), planetensucheObjektPruefer.isMasseUnbekannt())) {
            planetensucheObjektPruefer.setMasse(csvDto.getPlanetMasse());
            this.korrigierteObjekttypAnhandMasse(planetensucheObjektPruefer);
        }
        if (this.eigenschaftUebernehmen(csvDto.getPlanetRadius(), planetensucheObjektPruefer.isDurchmesserUnbekannt())) {
            planetensucheObjektPruefer.setDurchmesser(csvDto.getPlanetRadius());
        }
        if (this.eigenschaftUebernehmen(csvDto.getPlanetUmlaufszeit(), planetensucheObjektPruefer.isUmlaufszeitUnbekannt())) {
            planetensucheObjektPruefer.setUmlaufszeit(csvDto.getPlanetUmlaufszeit());
        }
        if (this.eigenschaftUebernehmen(csvDto.getPlanetGrosseHalbachse(), planetensucheObjektPruefer.isEntfernungUnbekannt())) {
            planetensucheObjektPruefer.setEntfernung(csvDto.getPlanetGrosseHalbachse());
        }
        if (this.eigenschaftUebernehmen(csvDto.getPlanetExzentrizitaet(), planetensucheObjektPruefer.isExzentritaetUnbekannt())) {
            planetensucheObjektPruefer.setExzentritaet(csvDto.getPlanetExzentrizitaet());
        }
        if (CsvDto.istEigenschaftGesetzt(csvDto.getPlanetEntdeckungsjahr()) && planetensucheObjektPruefer.isEntdeckungsdatumUnbekannt()) {
            planetensucheObjektPruefer.setEntdeckungsdatum("00.00." + csvDto.getPlanetEntdeckungsjahr());
        }
        if (CsvDto.istEigenschaftGesetzt(csvDto.getPlanetEntdeckungsmethode()) && this.wertUebernehmen(planetensucheObjektPruefer.isEntdeckungsmethodeUnbekannt())) {
            planetensucheObjektPruefer.setEntdeckungsmethode(csvDto.getPlanetEntdeckungsmethode());
        }
        if (csvDto.isPlanetEntdeckungBestaetigt() != null) {
            planetensucheObjektPruefer.setEntdeckungBestaetigt(csvDto.isPlanetEntdeckungBestaetigt());
        }
        this.setzeEntdecker(csvDto, planetensucheObjektPruefer, list2);
        if (Check.isFilled(csvDto.getNotiz())) {
            planetensucheObjektPruefer.setNotiz(csvDto.getNotiz());
        }
    }

    void setzeEntdecker(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer, List<String> list) throws SQLException {
        Map<String, String> map = planetensucheObjektPruefer.getEntdeckerMitNachnamenVornamen();
        this.discovererFinder.sucheUndSetzeEntdecker(csvDto, map, list);
        if (csvDto.getPlanetExofopDisposition() != null) {
            ExofopPlanetStatus exofopPlanetStatus = ExofopPlanetStatus.parse(csvDto.getPlanetExofopDisposition());
            if (exofopPlanetStatus.isKnownPlanet()) {
                this.logger.debug("remove discoverer TESS from known exoplanet " + csvDto.getPlanetName());
                map.remove(EntdeckerWeltraumteleskope.TESS.getNameInDatabase());
            }
        } else if (planetensucheObjektPruefer.getEntdeckungsjahr() != 0 && planetensucheObjektPruefer.getEntdeckungsjahr() < 2018) {
            this.logger.debug("remove discoverer TESS from exoplanet " + csvDto.getPlanetName() + " discovered in " + planetensucheObjektPruefer.getEntdeckungsjahr());
            map.remove(EntdeckerWeltraumteleskope.TESS.getNameInDatabase());
        }
        planetensucheObjektPruefer.setEntdeckerMitNachnamenVornamen(map);
        if (planetensucheObjektPruefer.getEntdeckerMitNachnamenVornamen().isEmpty()) {
            this.logger.warn("no discoverer found for " + (planetensucheObjektPruefer.isEntdeckungBestaetigt() ? "confirmed" : "unconfirmed") + " exoplanet " + csvDto.getPlanetName());
        }
    }

    private void korrigierteObjekttypAnhandMasse(PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        if (planetensucheObjektPruefer.getMasse() > 13.0 && "Planeten".equals(planetensucheObjektPruefer.getKategorie())) {
            planetensucheObjektPruefer.setKategorie("Braune Zwerge");
            planetensucheObjektPruefer.setObjekttyp("Brauner Zwerg");
            if (!this.parameter.isQuiet()) {
                this.importDialog.appendOutput("Der Planet ist " + planetensucheObjektPruefer.getMasse() + " Mjup schwer und wurde darum in einen Braunen Zwerg geaendert!");
            }
        }
        if (planetensucheObjektPruefer.getMasse() <= 13.0 && "Braune Zwerge".equals(planetensucheObjektPruefer.getKategorie())) {
            planetensucheObjektPruefer.setKategorie("Planeten");
            planetensucheObjektPruefer.setObjekttyp("Gasriese");
            if (!this.parameter.isQuiet()) {
                this.importDialog.appendOutput("Der Br. Zwerg ist " + planetensucheObjektPruefer.getMasse() + " Mjup schwer und wurde darum in einen Planeten geaendert!");
            }
        }
    }

    public CatalogNamesValidator getCatalogNamesValidator() {
        return this.catalogNamesValidator;
    }
}

