/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.importierer.api.FileImporter;
import de.planetensuche.datenbank.importierer.csv.NasaExoplanetCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.NasaK2NamesCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.NasaKeplerNamesCsvImportierer;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.sql.SQLException;

public final class AllNasaExoplanetImporter
extends Thread
implements FileImporter {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final NasaK2NamesCsvImportierer k2NamesImporter1;
    private final NasaKeplerNamesCsvImportierer keplerNamesImporter1;
    private final NasaK2NamesCsvImportierer k2NamesImporter2;
    private final NasaKeplerNamesCsvImportierer keplerNamesImporter2;
    private final NasaExoplanetCsvImportierer nasaExoplanetImporter;
    private final IDAOhighService daoHighService;

    public AllNasaExoplanetImporter(NasaK2NamesCsvImportierer nasaK2NamesCsvImportierer, NasaK2NamesCsvImportierer nasaK2NamesCsvImportierer2, NasaKeplerNamesCsvImportierer nasaKeplerNamesCsvImportierer, NasaKeplerNamesCsvImportierer nasaKeplerNamesCsvImportierer2, NasaExoplanetCsvImportierer nasaExoplanetCsvImportierer, IDAOhighService iDAOhighService) {
        this.k2NamesImporter1 = nasaK2NamesCsvImportierer;
        this.keplerNamesImporter1 = nasaKeplerNamesCsvImportierer;
        this.k2NamesImporter2 = nasaK2NamesCsvImportierer2;
        this.keplerNamesImporter2 = nasaKeplerNamesCsvImportierer2;
        this.nasaExoplanetImporter = nasaExoplanetCsvImportierer;
        this.daoHighService = iDAOhighService;
    }

    @Override
    public void run() {
        this.logger.debug("start()");
        try {
            this.logger.debug("reset object cache before kepler names import");
            this.daoHighService.updateObjektnamenCache();
            this.keplerNamesImporter1.start();
            this.keplerNamesImporter1.join(30000L);
            this.logger.debug("reset object cache before k2 names import");
            this.daoHighService.updateObjektnamenCache();
            this.k2NamesImporter1.start();
            this.k2NamesImporter1.join(30000L);
            this.logger.debug("reset object cache before NASA exoplanets import");
            this.daoHighService.updateObjektnamenCache();
            this.nasaExoplanetImporter.start();
            this.nasaExoplanetImporter.join();
            this.logger.debug("reset object cache before kepler names import");
            this.daoHighService.updateObjektnamenCache();
            this.keplerNamesImporter2.start();
            this.keplerNamesImporter2.join(30000L);
            this.logger.debug("reset object cache before k2 names import");
            this.daoHighService.updateObjektnamenCache();
            this.k2NamesImporter2.start();
            this.k2NamesImporter2.join(30000L);
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
        catch (InterruptedException interruptedException) {
            this.logger.error(interruptedException);
        }
    }

    @Override
    public void interrupt() {
        this.keplerNamesImporter1.interrupt();
        this.k2NamesImporter1.interrupt();
        this.keplerNamesImporter2.interrupt();
        this.k2NamesImporter2.interrupt();
        this.nasaExoplanetImporter.interrupt();
    }

    @Override
    public boolean speichereZwischenstand() {
        return false;
    }

    @Override
    public boolean importiereCsvDatei() throws IOException {
        this.logger.debug("importiereCsvDatei()");
        try {
            this.logger.debug("reset object cache before kepler names import");
            this.daoHighService.updateObjektnamenCache();
            this.keplerNamesImporter1.importiereCsvDatei();
            this.logger.debug("reset object cache before k2 names import");
            this.daoHighService.updateObjektnamenCache();
            this.k2NamesImporter1.importiereCsvDatei();
            this.logger.debug("reset object cache before NASA exoplanets import");
            this.daoHighService.updateObjektnamenCache();
            this.nasaExoplanetImporter.importiereCsvDatei();
            this.logger.debug("reset object cache before kepler names import");
            this.daoHighService.updateObjektnamenCache();
            this.keplerNamesImporter1.importiereCsvDatei();
            this.logger.debug("reset object cache before k2 names import");
            this.daoHighService.updateObjektnamenCache();
            this.k2NamesImporter1.importiereCsvDatei();
            return true;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return false;
        }
    }
}

