/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.importierer.api.IAllNasaExoplanetOnlineImporter;
import de.planetensuche.datenbank.importierer.api.ImportController;
import de.planetensuche.datenbank.importierer.csv.nasa.NasaCsvDownloader;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class AllNasaExoplanetOnlineImporter
implements IAllNasaExoplanetOnlineImporter {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ITimestampDAO timestampDAO;
    private final JFrame datenbankDialog;
    private final ImportController importDialogController;
    private final ISprachcontainer sprachcontainer;
    private final NasaCsvDownloader nasaCsvDownloader;
    private final AtomicBoolean importIsRunning;

    public AllNasaExoplanetOnlineImporter(JFrame jFrame, ImportController importController, ITimestampDAO iTimestampDAO) {
        this.datenbankDialog = jFrame;
        this.importDialogController = importController;
        this.timestampDAO = iTimestampDAO;
        this.sprachcontainer = SprachcontainerFabrik.getSprachcontainer();
        this.nasaCsvDownloader = new NasaCsvDownloader("temp", jFrame);
        this.importIsRunning = new AtomicBoolean(false);
    }

    @Override
    public void updateDatabaseIfNeeded() {
        String string;
        LocalDateTime localDateTime = LocalDateTime.now().minusMonths(2L);
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        long l = this.timestampDAO.countInsertedExoplanetIdsAfterDate(instant);
        this.logger.debug("found " + l + " new (exo)planets since 2 months");
        if (l > 0L) {
            return;
        }
        String string2 = this.sprachcontainer.getString("db_m462");
        int n = JOptionPane.showConfirmDialog(this.datenbankDialog, string2, string = this.sprachcontainer.getString("db_m462_titel"), 0, 3);
        if (n == 1) {
            return;
        }
        this.updateDatabaseImmediately();
    }

    @Override
    public void updateDatabaseImmediately() {
        this.logger.debug("start online import...");
        if (this.importIsRunning.get()) {
            JOptionPane.showMessageDialog(this.datenbankDialog, this.sprachcontainer.getString("db_m465"), this.sprachcontainer.getString("db_m462_titel"), 1);
            return;
        }
        this.importIsRunning.set(true);
        AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
        asyncLoadingScreenCallbackExecutor.execute(this.datenbankDialog, () -> {
            try {
                boolean bl = this.nasaCsvDownloader.downloadFiles(asyncLoadingScreenCallbackExecutor);
                this.logger.debug("downloadSuccess? " + bl);
                asyncLoadingScreenCallbackExecutor.disableWaitingDialog();
                if (bl) {
                    this.runImport();
                } else {
                    JOptionPane.showMessageDialog(this.datenbankDialog, this.sprachcontainer.getString("db_m463"), this.sprachcontainer.getString("db_m462_titel"), 0);
                }
            }
            catch (IOException | SQLException exception) {
                this.logger.error(exception);
            }
            this.importIsRunning.set(false);
        });
    }

    private void runImport() throws IOException, SQLException {
        this.importDialogController.showDialog();
        String string = this.sprachcontainer.getString("db_m461");
        this.importDialogController.setObjekteErsetzen(true);
        this.importDialogController.setImportType(string);
        File file = new File("temp");
        this.importDialogController.createAndRunImportThread(file, string);
    }
}

