/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.importierer.ImportDialog;
import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbank.importierer.csv.AbstractCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.CtoiUserTrustableChecker;
import de.planetensuche.datenbank.importierer.csv.DummyDialog;
import de.planetensuche.datenbank.importierer.csv.GaiaDataDownloader;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.nasa.CsvFileNames;
import de.planetensuche.datenbank.importierer.csv.nasa.CtoiCsvZuDtoKonverter;
import de.planetensuche.datenbank.importierer.csv.nasa.ExofopCsvDownloader;
import de.planetensuche.datenbank.importierer.csv.nasa.ExofopPlanetStatus;
import de.planetensuche.datenbank.importierer.csv.nasa.ToiCsvZuDtoKonverter;
import de.planetensuche.datenbank.importierer.merge.PsObjectMergeException;
import de.planetensuche.datenbank.importierer.validator.InvalidCatalogException;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbank.util.SimbadStarDownload;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public final class CtoiToiCsvImportierer
extends AbstractCsvImportierer {
    private static final File MY_CANIDATES_FILE = new File("conf" + File.separator + "my_candidates.txt");
    private static final ImportDialog DUMMY_DIALOG = new DummyDialog();
    private boolean toiImport = false;
    private final SimbadStarDownload simbadDownloader;
    private final IDAOhighService daoHighService;
    private final ExofopCsvDownloader exofopCsvDownloader;
    private final CtoiUserTrustableChecker ctoiUserTrustableChecker;
    private final GaiaDataDownloader gaiaDataDownloader;

    public CtoiToiCsvImportierer(ParameterDto parameterDto, InjectionDto injectionDto, Katalogerkenner katalogerkenner, IImportDialog iImportDialog, String string, KonfigurationDTO konfigurationDTO, boolean bl) throws IOException {
        super(new File(CsvFileNames.CTOI_CANDIDATES.getFilename()), null, iImportDialog != null ? iImportDialog : DUMMY_DIALOG, parameterDto, injectionDto, katalogerkenner, konfigurationDTO);
        DUMMY_DIALOG.setSelectedImportType(this.i18n.getString("db_gui135"));
        if (iImportDialog != null) {
            iImportDialog.setObjekteErgaenzen(false);
            iImportDialog.setObjekteErsetzen(false);
            iImportDialog.setObjekteHinzufuegen(true);
            iImportDialog.setObjekteUpdaten(true);
            iImportDialog.setUmleitungInXML(false);
            iImportDialog.setTest(false);
        }
        this.daoHighService = injectionDto.getDaoHighService();
        this.simbadDownloader = new SimbadStarDownload();
        this.exofopCsvDownloader = new ExofopCsvDownloader(string, bl);
        this.ctoiUserTrustableChecker = new CtoiUserTrustableChecker();
        this.gaiaDataDownloader = new GaiaDataDownloader();
    }

    public void addObjectNameToGaiaQueryWhiteList(String string) {
        this.gaiaDataDownloader.addObjectNameToGaiaQueryWhiteList(string);
    }

    @Override
    public boolean importiereCsvDatei() throws IOException {
        long l = System.currentTimeMillis();
        this.gesamteObjektanzahl = 3;
        this.verarbeiteteObjektanzahl = 0;
        this.importDialog.appendOutput("downloading...");
        File file = this.exofopCsvDownloader.downloadCtoiFile();
        ++this.verarbeiteteObjektanzahl;
        this.aktualisiereFortschrittsbalken(l);
        File file2 = this.exofopCsvDownloader.downloadToiFile();
        ++this.verarbeiteteObjektanzahl;
        this.aktualisiereFortschrittsbalken(l);
        HashSet<String> hashSet = new HashSet<String>(FileUtils.readLines(MY_CANIDATES_FILE, "utf8"));
        ++this.verarbeiteteObjektanzahl;
        this.aktualisiereFortschrittsbalken(l);
        try {
            HashSet<String> hashSet2 = new HashSet<String>();
            HashSet<String> hashSet3 = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>(hashSet);
            this.importCtoiList(file, hashSet2, hashSet, hashSet3, arrayList);
            this.importToiList(file2, hashSet2, hashSet, hashSet3, arrayList);
            this.logger.info(hashSet.size() - arrayList.size() + "/" + hashSet.size() + " von meinen Kandidaten importiert");
            this.logger.info("Kandidaten insgesamt: " + hashSet2.size() + " / PHT Kandidaten: " + hashSet3.size());
            this.logger.info("nicht importierte Kandidaten: " + ((Object)arrayList).toString());
            return true;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return false;
        }
    }

    private void importToiList(File file, Set<String> set, Set<String> set2, Set<String> set3, List<String> list) throws SQLException, IOException {
        this.logger.info("start TOI csv import...");
        this.importDialog.appendOutput("starting TOI import...");
        this.toiImport = true;
        this.daoHighService.updateObjektnamenCache();
        ToiCsvZuDtoKonverter toiCsvZuDtoKonverter = new ToiCsvZuDtoKonverter(this.getInjectionDto().getKatalogerkenner());
        List<CsvDto> list2 = toiCsvZuDtoKonverter.leseDtos(file);
        this.gesamteObjektanzahl = list2.size();
        this.verarbeiteteObjektanzahl = 0;
        long l = System.currentTimeMillis();
        for (CsvDto csvDto : list2) {
            boolean bl;
            if (this.isInterrupted()) {
                this.logger.warn("import was interupted");
                break;
            }
            set.add(csvDto.getPlanetName());
            if (set2.contains(csvDto.getPlanetName()) || csvDto.getPlanetEntdecker().contains("Eisner") || csvDto.getPlanetEntdecker().contains(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())) {
                set3.add(csvDto.getPlanetName());
            }
            if (set2.contains(csvDto.getPlanetName())) {
                csvDto.getPlanetEntdecker().add("G\u00fchne");
                csvDto.getPlanetEntdecker().add("Eisner");
                csvDto.getPlanetEntdecker().add(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase());
            }
            if (bl = this.verarbeiteDto(csvDto)) {
                list.remove(csvDto.getPlanetName());
            }
            ++this.verarbeiteteObjektanzahl;
            this.aktualisiereFortschrittsbalken(l);
        }
        this.logger.info("TOI csv import done...");
        this.importDialog.appendOutput("TOI import done...");
    }

    private void importCtoiList(File file, Set<String> set, Set<String> set2, Set<String> set3, List<String> list) throws IOException, SQLException {
        this.logger.info("start CTOI csv import...");
        this.importDialog.appendOutput("starting CTOI import...");
        this.toiImport = false;
        this.daoHighService.updateObjektnamenCache();
        CtoiCsvZuDtoKonverter ctoiCsvZuDtoKonverter = new CtoiCsvZuDtoKonverter();
        List<CsvDto> list2 = ctoiCsvZuDtoKonverter.leseDtos(file);
        this.gesamteObjektanzahl = list2.size();
        this.verarbeiteteObjektanzahl = 0;
        long l = System.currentTimeMillis();
        for (CsvDto csvDto : list2) {
            boolean bl;
            if (this.isInterrupted()) {
                this.logger.warn("import was interupted");
                break;
            }
            set.add(csvDto.getPlanetName());
            if (set2.contains(csvDto.getPlanetName()) || csvDto.getPlanetEntdecker().contains("Eisner") || csvDto.getPlanetEntdecker().contains(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())) {
                set3.add(csvDto.getPlanetName());
            }
            if (set2.contains(csvDto.getPlanetName())) {
                csvDto.getPlanetEntdecker().add("G\u00fchne");
                csvDto.getPlanetEntdecker().add("Eisner");
                csvDto.getPlanetEntdecker().add(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase());
            }
            if (bl = this.verarbeiteDto(csvDto)) {
                list.remove(csvDto.getPlanetName());
            }
            ++this.verarbeiteteObjektanzahl;
            this.aktualisiereFortschrittsbalken(l);
        }
        this.logger.info("CTOI csv import done...");
        this.importDialog.appendOutput("CTOI import done...");
    }

    @Override
    void setzteSternSptyp(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        String string;
        Optional<String> optional;
        if (csvDto.getPlanetEntdecker().contains("G\u00fchne") && (planetensucheObjektPruefer.isSpektralklasseUnbekannt() || planetensucheObjektPruefer.isLeuchtkraftklasseUnbekannt()) && (optional = this.simbadDownloader.getSptypFromSimbad(string = planetensucheObjektPruefer.getObjektNamen().get(0))).isPresent()) {
            this.korrigiereSpektraltyp.speichereSptypCSVBeliebig(planetensucheObjektPruefer, optional.get(), true);
        }
    }

    @Override
    void setzteSternRa(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        if (CsvDto.istEigenschaftGesetzt(csvDto.getSternRa())) {
            if (this.toiImport) {
                String[] stringArray = csvDto.getSternRa().split(":");
                double d = Double.parseDouble(stringArray[0]) + Double.parseDouble(stringArray[1]) / 60.0 + Double.parseDouble(stringArray[2]) / 3600.0;
                if (d != 0.0 && this.wertUebernehmen(planetensucheObjektPruefer.isRaUnbekannt())) {
                    planetensucheObjektPruefer.setRA(d);
                }
            } else {
                double d = Double.parseDouble(csvDto.getSternRa());
                if (d != 0.0 && this.wertUebernehmen(planetensucheObjektPruefer.isRaUnbekannt())) {
                    planetensucheObjektPruefer.setRA(d / 360.0 * 24.0);
                }
            }
        }
    }

    @Override
    void setzteSternDecl(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        if (CsvDto.istEigenschaftGesetzt(csvDto.getSternDecl())) {
            if (this.toiImport) {
                String[] stringArray = csvDto.getSternDecl().split(":");
                double d = Double.parseDouble(stringArray[0]);
                double d2 = Double.parseDouble(stringArray[1]) / 60.0 + Double.parseDouble(stringArray[2]) / 3600.0;
                d = d >= 0.0 ? (d += d2) : (d += -1.0 * d2);
                if (d != 0.0 && this.wertUebernehmen(planetensucheObjektPruefer.isDeclUnbekannt())) {
                    planetensucheObjektPruefer.setDECL(d);
                }
            } else {
                double d = Double.parseDouble(csvDto.getSternDecl());
                if (d != 0.0 && this.wertUebernehmen(planetensucheObjektPruefer.isDeclUnbekannt())) {
                    planetensucheObjektPruefer.setDECL(d);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verarbeiteDto(CsvDto csvDto) {
        try {
            ExofopPlanetStatus exofopPlanetStatus = ExofopPlanetStatus.parse(csvDto.getPlanetExofopDisposition());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(csvDto.getSternName());
            arrayList.addAll(csvDto.getWeitereSternnamen());
            int n = this.objektnamenRepository.countNamen(arrayList);
            PlanetensucheObjektPruefer planetensucheObjektPruefer = this.erzeugePlanetensucheObjektFuerStern(n, arrayList, "ExoFOP");
            this.setzteDatenFuerStern(csvDto, planetensucheObjektPruefer);
            if (exofopPlanetStatus.isEb()) {
                planetensucheObjektPruefer.setObjekttyp(StarObjectType.ECLIPSING_BINARY.getTypeName());
            }
            this.gaiaDataDownloader.downloadAndSetGaiaData(planetensucheObjektPruefer);
            boolean bl = this.speichereObjekt(planetensucheObjektPruefer, n);
            if (!bl) {
                this.logger.debug("nicht gespeichert: " + planetensucheObjektPruefer.toString());
                this.nichtEingefuegteObjekte.add(csvDto.getSternName());
                this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
                return false;
            }
            boolean bl2 = csvDto.getPlanetRadius() != null && csvDto.getPlanetRadius() <= 1.5;
            boolean bl3 = exofopPlanetStatus.isConfirmedPlanet() || exofopPlanetStatus.isKnownPlanet();
            boolean bl4 = this.ctoiUserTrustableChecker.isDiscovererTrustable(csvDto.getPlanetEntdecker());
            if (bl3 || exofopPlanetStatus.isPlanetCandidate() && bl2 && bl4) {
                boolean bl5;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(csvDto.getPlanetName());
                arrayList2.addAll(csvDto.getWeiterePlanetennamen());
                PlanetensucheObjektPruefer planetensucheObjektPruefer2 = this.erzeugePlanetensucheObjektPlanet(arrayList2, "ExoFOP", planetensucheObjektPruefer, csvDto);
                this.setzteDatenFuerPlanet(csvDto, planetensucheObjektPruefer2, planetensucheObjektPruefer.getObjektNamen(), planetensucheObjektPruefer2.getObjektNamen());
                if (planetensucheObjektPruefer2.getEntdeckerMitNachnamenVornamen().containsKey(EntdeckerWeltraumteleskope.TESS.getNameInDatabase()) && exofopPlanetStatus.isKnownPlanet()) {
                    Map<String, String> map = planetensucheObjektPruefer2.getEntdeckerMitNachnamenVornamen();
                    map.remove(EntdeckerWeltraumteleskope.TESS.getNameInDatabase());
                    planetensucheObjektPruefer2.setEntdeckerMitNachnamenVornamen(map);
                }
                if (bl5 = this.speichereObjekt(planetensucheObjektPruefer2, n = this.objektnamenRepository.countNamen(planetensucheObjektPruefer2.getObjektNamen()))) return true;
                this.logger.debug("nicht gespeichert: " + planetensucheObjektPruefer2.toString());
                this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
                return false;
            } else {
                this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
                this.removeFalsePositivePlanetIfExists(csvDto.getPlanetName(), csvDto.getWeiterePlanetennamen());
            }
            return false;
        }
        catch (InvalidCatalogException invalidCatalogException) {
            this.handleInvalidCatalogException(invalidCatalogException, csvDto);
            return false;
        }
        catch (PsObjectMergeException psObjectMergeException) {
            this.handleMergeException(psObjectMergeException, csvDto);
            return false;
        }
        catch (IOException | RuntimeException | SQLException exception) {
            String string = "Objekte fehlerhaft: " + csvDto.getSternName() + "/" + csvDto.getPlanetName();
            this.logger.error(string, exception);
            this.importDialog.appendOutput(string);
            this.nichtEingefuegteObjekte.add(csvDto.getSternName());
            this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
            if (!this.logger.isDebugEnabled()) return false;
            this.logger.debug("wrong data: " + csvDto.toString());
        }
        return false;
    }

    @Override
    void setzteDatenFuerPlanet(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer, List<String> list, List<String> list2) throws SQLException {
        if (planetensucheObjektPruefer.getDatenid() != null && planetensucheObjektPruefer.isEntdeckungBestaetigt()) {
            this.setzeEntdecker(csvDto, planetensucheObjektPruefer, list2);
        } else {
            super.setzteDatenFuerPlanet(csvDto, planetensucheObjektPruefer, list, list2);
        }
    }

    private void removeFalsePositivePlanetIfExists(String string, Set<String> set) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.add(string);
        for (String string2 : hashSet) {
            Integer n = this.objektnamenRepository.readDatenid(string2);
            if (n == null) continue;
            this.logger.info("delete false-positive planet candidate '" + string2 + "'");
            this.planetensucheObjektRepository.delete(n);
            return;
        }
    }
}

