/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import de.planetensuche.core.Check;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.HashSet;
import java.util.Set;

public class CtoiUserTrustableChecker {
    private final ILogging logger = LoggingFactory.getLoggerForClass(CtoiUserTrustableChecker.class);
    private final Set<String> trustableNames = this.createTrustableNameSet();

    public boolean isDiscovererTrustable(Set<String> set) {
        boolean bl;
        if (Check.isEmpty(set) || set.size() == 1 && set.contains(EntdeckerWeltraumteleskope.TESS.getNameInDatabase())) {
            return true;
        }
        if (this.isKnownScientist(set)) {
            return true;
        }
        boolean bl2 = set.contains("olmschenk") || set.contains("feliz") || set.contains("montalto") || set.contains("brahm") || set.contains("nardiello") || set.contains("bouma");
        boolean bl3 = bl = set.contains("christiansen") || set.contains("kruse") || set.contains("wilson") || set.contains("kcollins") || set.contains("feinstein");
        if (bl2 || bl) {
            return true;
        }
        this.logger.debug("ignore planet candidate from non trustable discoverer/user " + String.valueOf(set));
        return false;
    }

    private boolean isKnownScientist(Set<String> set) {
        for (String string : set) {
            if (!this.trustableNames.contains(string)) continue;
            return true;
        }
        return false;
    }

    private Set<String> createTrustableNameSet() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("eisner");
        hashSet.add("Eisner");
        hashSet.add("aigrain");
        hashSet.add("mason");
        hashSet.add("wzhou");
        hashSet.add("knguyen");
        hashSet.add("vach");
        hashSet.add("essack");
        hashSet.add("dragomir");
        hashSet.add("grunblatt");
        hashSet.add("schlecker");
        hashSet.add("zhou");
        hashSet.add("helminiak");
        hashSet.add("collins");
        hashSet.add("cloutier");
        hashSet.add("mzhang");
        hashSet.add("palumbo");
        hashSet.add("galgano");
        hashSet.add("feigelson");
        hashSet.add("montet");
        hashSet.add("earley");
        hashSet.add("munavarhussain");
        hashSet.add("fukui");
        hashSet.add("salinas");
        hashSet.add("steuer");
        hashSet.add("vogl");
        hashSet.add("lthomas");
        hashSet.add("marlecha");
        hashSet.add("osborn");
        hashSet.add("holstkristiansen");
        hashSet.add("gill");
        hashSet.add("dransfield");
        hashSet.add("french");
        hashSet.add("vanes");
        hashSet.add("lekkas");
        hashSet.add("tuson");
        hashSet.add("timmermans");
        hashSet.add("obrien");
        hashSet.add("devorapajares");
        hashSet.add("roche");
        hashSet.add("kunimoto");
        hashSet.add("correa");
        hashSet.add("sedgley");
        return hashSet;
    }
}

