/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.importierer.csv.ExoplanetDiscoveryProjectDetector;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ExoplanetDiscovererFinder {
    private final ILogging logger = LoggingFactory.getLoggerForClass(ExoplanetDiscovererFinder.class);
    private final IEntdeckerRepository entdeckerRepository;
    private final ExoplanetDiscoveryProjectDetector projectDetector;

    public ExoplanetDiscovererFinder(IEntdeckerRepository iEntdeckerRepository) {
        this.entdeckerRepository = iEntdeckerRepository;
        this.projectDetector = new ExoplanetDiscoveryProjectDetector();
    }

    public void sucheUndSetzeEntdecker(CsvDto csvDto, Map<String, String> map, List<String> list) throws SQLException {
        Object object;
        int n = 0;
        if (Check.isFilled(csvDto.getPlanetEntdecker())) {
            object = csvDto.getPlanetEntdecker().iterator();
            while (object.hasNext()) {
                String string = object.next();
                String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
                List<Entdecker> list2 = this.entdeckerRepository.findByLastname(string2);
                if (list2 != null && list2.size() == 1) {
                    Entdecker entdecker2 = list2.get(0);
                    map.put(string2, entdecker2.getVorname());
                    if (entdecker2.getTyp() == null || !entdecker2.getTyp().equals(1)) continue;
                    ++n;
                    continue;
                }
                if (list2 == null || list2.isEmpty()) {
                    this.logger.debug("Entdecker '" + string2 + "' lieferte keinen Treffer; manuell anlegen!");
                    continue;
                }
                if (list2.size() <= 1) continue;
                if ("Swift".equals(string2)) {
                    map.put(string2, "Jonathan J.");
                    continue;
                }
                this.logger.warn("Last name of discoverer '" + string2 + "' was found multiple times in the database!");
                list2.forEach(entdecker -> this.logger.debug(entdecker.getVorname() + " " + entdecker.getNachname()));
            }
        }
        if (n < 2 && ((Optional)(object = this.projectDetector.extractProjectFromName(list))).isPresent()) {
            map.put(((EntdeckerProjekte)((Object)((Optional)object).get())).getNameInDatabase(), "");
        }
    }
}

