/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import de.planetensuche.datamodel.api.GaiaNonSingleStar;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.gaia.doublestar.GaiaAstrometricDto;
import de.planetensuche.datenbank.gaia.doublestar.GaiaDoubleStarIndicatorService;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GaiaDataDownloader {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final GaiaDoubleStarIndicatorService gaiaDoubleStarService = new GaiaDoubleStarIndicatorService();
    private final List<String> whiteListObjectNamesForGaiaQuery = new ArrayList<String>();

    public void addObjectNameToGaiaQueryWhiteList(String string) {
        this.whiteListObjectNamesForGaiaQuery.add(string);
    }

    public void downloadAndSetGaiaData(PlanetensucheObjektPruefer planetensucheObjektPruefer) {
        try {
            boolean bl = this.isStarOnWhitelist(planetensucheObjektPruefer);
            if (!bl) {
                return;
            }
            if (planetensucheObjektPruefer.isGaiaAstroExNoiseSigUnbekannt() && planetensucheObjektPruefer.isGaiaRuweUnbekannt() && planetensucheObjektPruefer.isGaiaRvErrorUnbekannt()) {
                String string = this.findGaiaDr2Dr3Id(planetensucheObjektPruefer.getObjektNamen());
                if (string == null) {
                    this.logger.debug("cancel download Gaia stellar parameter: no Gaia DR2/DR3 id found for star " + String.valueOf(planetensucheObjektPruefer.getObjektNamen()));
                    return;
                }
                Optional<GaiaAstrometricDto> optional = this.gaiaDoubleStarService.queryGaia(string);
                if (optional.isPresent()) {
                    GaiaAstrometricDto gaiaAstrometricDto = optional.get();
                    if (gaiaAstrometricDto.getAstrometricExcessNoiseSignificance() != null) {
                        planetensucheObjektPruefer.setGaiaAstroExNoiseSig(gaiaAstrometricDto.getAstrometricExcessNoiseSignificance());
                    }
                    if (gaiaAstrometricDto.getRuwe() != null) {
                        planetensucheObjektPruefer.setGaiaRuwe(gaiaAstrometricDto.getRuwe());
                    }
                    if (gaiaAstrometricDto.getRvErrorInMeterPerSeconds() != null) {
                        planetensucheObjektPruefer.setGaiaRvError(gaiaAstrometricDto.getRvErrorInMeterPerSeconds() / 1000.0);
                    }
                    if (gaiaAstrometricDto.getRvInMeterPerSeconds() != null && planetensucheObjektPruefer.isGeschwindigkeitUnbekannt()) {
                        planetensucheObjektPruefer.setGeschwindigkeit(gaiaAstrometricDto.getRvInMeterPerSeconds() / 1000.0);
                    }
                    if (gaiaAstrometricDto.getIsSingleStar() == null) {
                        planetensucheObjektPruefer.setGaiaNonSingle(GaiaNonSingleStar.UNKNOWN);
                    } else if (gaiaAstrometricDto.getIsSingleStar().booleanValue()) {
                        planetensucheObjektPruefer.setGaiaNonSingle(GaiaNonSingleStar.SINGLE);
                    } else {
                        planetensucheObjektPruefer.setGaiaNonSingle(gaiaAstrometricDto.getNonSingleStarType());
                    }
                } else {
                    this.logger.warn("no gaia stellar data found for Gaia DR2/DR3 " + string);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("error during download or evaluate the gaia stellar data for star " + String.valueOf(planetensucheObjektPruefer.getObjektNamen()), runtimeException);
        }
    }

    private boolean isStarOnWhitelist(PlanetensucheObjektPruefer planetensucheObjektPruefer) {
        boolean bl = false;
        if (this.whiteListObjectNamesForGaiaQuery.isEmpty()) {
            bl = true;
        } else {
            for (String string : planetensucheObjektPruefer.getObjektNamen()) {
                if (!this.whiteListObjectNamesForGaiaQuery.contains(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private String findGaiaDr2Dr3Id(List<String> list) {
        for (String string : list) {
            if (!string.startsWith("Gaia DR2 ") && !string.startsWith("Gaia DR3 ")) continue;
            return string;
        }
        return null;
    }
}

