/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.importierer.api.ImportController;
import de.planetensuche.datenbank.importierer.csv.AbstractCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.GaiaDataDownloader;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.nasa.NasaMainTableCsvZuDtoKonverter;
import de.planetensuche.datenbank.importierer.merge.PsObjectMergeException;
import de.planetensuche.datenbank.importierer.validator.InvalidCatalogException;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbankkern.api.kategorien.IPlanetenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class NasaExoplanetCsvImportierer
extends AbstractCsvImportierer {
    private final GaiaDataDownloader gaiaDataDownloader;
    private final Set<Integer> datenIdsOfActiveExoplanets = new HashSet<Integer>();

    public NasaExoplanetCsvImportierer(File file, ImportController importController, ParameterDto parameterDto, InjectionDto injectionDto, Katalogerkenner katalogerkenner, KonfigurationDTO konfigurationDTO) throws IOException {
        super(file, importController.getXMLDatei(), importController.getDialog(), parameterDto, injectionDto, katalogerkenner, konfigurationDTO);
        this.gaiaDataDownloader = new GaiaDataDownloader();
    }

    public void addObjectNameToGaiaQueryWhiteList(String string) {
        this.gaiaDataDownloader.addObjectNameToGaiaQueryWhiteList(string);
    }

    @Override
    public boolean importiereCsvDatei() throws IOException {
        this.logger.info("start csv import...");
        NasaMainTableCsvZuDtoKonverter nasaMainTableCsvZuDtoKonverter = new NasaMainTableCsvZuDtoKonverter();
        List<CsvDto> list = nasaMainTableCsvZuDtoKonverter.leseDtos(this.csvDatei);
        this.gesamteObjektanzahl = list.size();
        this.verarbeiteteObjektanzahl = 0;
        long l = System.currentTimeMillis();
        for (CsvDto csvDto : list) {
            if (this.isInterrupted()) break;
            this.verarbeiteDto(csvDto);
            ++this.verarbeiteteObjektanzahl;
            this.aktualisiereFortschrittsbalken(l);
        }
        if (this.importDialog.umleitungInXML()) {
            if (!this.psobjekteFuerXMLDatei.isEmpty()) {
                IPlanetensucheObjekt[] iPlanetensucheObjektArray = new IPlanetensucheObjekt[this.psobjekteFuerXMLDatei.size()];
                for (int i = 0; i < this.psobjekteFuerXMLDatei.size(); ++i) {
                    iPlanetensucheObjektArray[i] = (IPlanetensucheObjekt)this.psobjekteFuerXMLDatei.get(i);
                }
                this.oeffneExportDialog(iPlanetensucheObjektArray);
            } else {
                this.importDialog.appendOutput(this.i18n.getString("db_f44"));
                this.importDialog.appendOutput(this.i18n.getString("db_f45"));
            }
        }
        this.printObsoleteExoplanetsIntoLog();
        return true;
    }

    @Override
    void setzteSternSptyp(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        PlanetensucheObjekt planetensucheObjekt = new PlanetensucheObjekt();
        this.korrigiereSpektraltyp.speichereSptypCSVBeliebig(planetensucheObjekt, csvDto.getSternSptyp(), true);
        if (this.wertUebernehmen(planetensucheObjektPruefer.isSpektralklasseUnbekannt())) {
            planetensucheObjektPruefer.setSpektralklasse(planetensucheObjekt.getSpektralklasse());
            planetensucheObjektPruefer.setSpektralklasse2(planetensucheObjekt.getSpektralklasse2());
        }
        if (this.wertUebernehmen(planetensucheObjektPruefer.isLeuchtkraftklasseUnbekannt())) {
            planetensucheObjektPruefer.setLeuchtkraftklasse(planetensucheObjekt.getLeuchtkraftklasse());
        }
    }

    @Override
    void setzteSternRa(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        double d;
        if (CsvDto.istEigenschaftGesetzt(csvDto.getSternRa()) && (d = Double.parseDouble(csvDto.getSternRa())) != 0.0 && this.wertUebernehmen(planetensucheObjektPruefer.isRaUnbekannt())) {
            planetensucheObjektPruefer.setRA(d / 360.0 * 24.0);
        }
    }

    @Override
    void setzteSternDecl(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        double d;
        if (CsvDto.istEigenschaftGesetzt(csvDto.getSternDecl()) && (d = Double.parseDouble(csvDto.getSternDecl())) != 0.0 && this.wertUebernehmen(planetensucheObjektPruefer.isDeclUnbekannt())) {
            planetensucheObjektPruefer.setDECL(d);
        }
    }

    @Override
    void setzteDatenFuerStern(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        super.setzteDatenFuerStern(csvDto, planetensucheObjektPruefer);
        if (StarObjectType.SINGLE_STAR.getTypeName().equals(planetensucheObjektPruefer.getObjekttyp())) {
            if (csvDto.getNumberOfStarsInSystem() > 2) {
                planetensucheObjektPruefer.setObjekttyp(StarObjectType.MULTI_STAR_SYSTEM.getTypeName());
            } else if (csvDto.getNumberOfStarsInSystem() > 1) {
                planetensucheObjektPruefer.setObjekttyp(StarObjectType.DOUBLE_STAR_REAL.getTypeName());
            }
        }
    }

    private void verarbeiteDto(CsvDto csvDto) {
        block13: {
            try {
                Object object;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList.add(this.fixNames.korrigiereNamen(csvDto.getSternName()));
                arrayList2.add(this.fixNames.korrigiereNamen(csvDto.getPlanetName()));
                if (((String)arrayList.get(0)).equals(arrayList2.get(0))) {
                    throw new IllegalArgumentException("Stern und Exoplanet haben den selben Namen (" + (String)arrayList.get(0) + ")!");
                }
                for (String object22 : csvDto.getWeitereSternnamen()) {
                    arrayList.add(this.fixNames.korrigiereNamen(object22));
                }
                for (String string : csvDto.getWeiterePlanetennamen()) {
                    arrayList2.add(this.fixNames.korrigiereNamen(string));
                }
                int n = this.objektnamenRepository.countNamen(arrayList);
                if (n <= 0) {
                    for (String string : arrayList) {
                        object = this.fixNames.korrigiereNamenMehrfachstern(string);
                        if (((String)object).equals(string)) continue;
                        arrayList.remove(string);
                        arrayList.add((String)object);
                        n = this.objektnamenRepository.countNamen(arrayList);
                        break;
                    }
                }
                PlanetensucheObjektPruefer planetensucheObjektPruefer = this.erzeugePlanetensucheObjektFuerStern(n, arrayList, "NASA");
                this.setzteDatenFuerStern(csvDto, planetensucheObjektPruefer);
                this.gaiaDataDownloader.downloadAndSetGaiaData(planetensucheObjektPruefer);
                boolean bl = this.speichereObjekt(planetensucheObjektPruefer, n);
                if (bl) {
                    object = this.erzeugePlanetensucheObjektPlanet(arrayList2, "NASA", planetensucheObjektPruefer, csvDto);
                    this.setzteDatenFuerPlanet(csvDto, (PlanetensucheObjektPruefer)object, planetensucheObjektPruefer.getObjektNamen(), ((PlanetensucheObjekt)object).getObjektNamen());
                    n = this.objektnamenRepository.countNamen(((PlanetensucheObjekt)object).getObjektNamen());
                    boolean bl2 = this.speichereObjekt((PlanetensucheObjektPruefer)object, n);
                    if (bl2) {
                        this.datenIdsOfActiveExoplanets.add(((PlanetensucheObjekt)object).getDatenid());
                    } else {
                        this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
                    }
                } else {
                    this.nichtEingefuegteObjekte.add(csvDto.getSternName());
                    this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
                }
            }
            catch (InvalidCatalogException invalidCatalogException) {
                this.handleInvalidCatalogException(invalidCatalogException, csvDto);
            }
            catch (PsObjectMergeException psObjectMergeException) {
                this.handleMergeException(psObjectMergeException, csvDto);
            }
            catch (IOException | RuntimeException | SQLException exception) {
                String string = "Objekte fehlerhaft: " + csvDto.getSternName() + "/" + csvDto.getPlanetName();
                this.logger.error(string, exception);
                this.importDialog.appendOutput(string);
                this.nichtEingefuegteObjekte.add(csvDto.getSternName());
                this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
                if (!this.logger.isDebugEnabled()) break block13;
                this.logger.debug("wrong data: " + csvDto.toString());
            }
        }
    }

    private void printObsoleteExoplanetsIntoLog() {
        IPlanetenRepository iPlanetenRepository = this.getInjectionDto().getPlanetenRepository();
        List<Integer> list = iPlanetenRepository.getDatenIdsConfirmedExoplanets();
        this.logger.debug(list.size() + " confirmed planets in DB vs " + this.datenIdsOfActiveExoplanets.size() + " confirmed planets in CSV");
        for (Integer n : list) {
            if (this.datenIdsOfActiveExoplanets.contains(n)) continue;
            try {
                List<String> list2 = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.KEINE_SORTIERUNG);
                this.logger.info("Exoplanet '" + String.valueOf(list2) + "' is not anymore in NASA csv - controversial planet or brown dwarf?");
            }
            catch (RuntimeException runtimeException) {
                this.logger.error("daten id = " + n, runtimeException);
            }
        }
    }
}

