/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import com.querydsl.core.QueryException;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.importierer.api.ImportController;
import de.planetensuche.datenbank.importierer.csv.AbstractCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.nasa.NasaK2NamesCsvZuDtoKonverter;
import de.planetensuche.datenbank.importierer.merge.PsObjectMergeException;
import de.planetensuche.datenbank.importierer.validator.InvalidCatalogException;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class NasaK2NamesCsvImportierer
extends AbstractCsvImportierer {
    public NasaK2NamesCsvImportierer(File file, ImportController importController, ParameterDto parameterDto, InjectionDto injectionDto, Katalogerkenner katalogerkenner, KonfigurationDTO konfigurationDTO) throws IOException {
        super(file, importController.getXMLDatei(), importController.getDialog(), parameterDto, injectionDto, katalogerkenner, konfigurationDTO);
    }

    @Override
    public boolean importiereCsvDatei() throws IOException {
        NasaK2NamesCsvZuDtoKonverter nasaK2NamesCsvZuDtoKonverter = new NasaK2NamesCsvZuDtoKonverter();
        List<CsvDto> list = nasaK2NamesCsvZuDtoKonverter.leseDtos(this.csvDatei);
        this.gesamteObjektanzahl = list.size();
        this.verarbeiteteObjektanzahl = 0;
        long l = System.currentTimeMillis();
        for (CsvDto csvDto : list) {
            if (this.isInterrupted()) break;
            this.verarbeiteDto(csvDto);
            ++this.verarbeiteteObjektanzahl;
            this.aktualisiereFortschrittsbalken(l);
        }
        if (this.importDialog.umleitungInXML()) {
            if (!this.psobjekteFuerXMLDatei.isEmpty()) {
                IPlanetensucheObjekt[] iPlanetensucheObjektArray = new IPlanetensucheObjekt[this.psobjekteFuerXMLDatei.size()];
                for (int i = 0; i < this.psobjekteFuerXMLDatei.size(); ++i) {
                    iPlanetensucheObjektArray[i] = (IPlanetensucheObjekt)this.psobjekteFuerXMLDatei.get(i);
                }
                this.oeffneExportDialog(iPlanetensucheObjektArray);
            } else {
                this.importDialog.appendOutput(this.i18n.getString("db_f44"));
                this.importDialog.appendOutput(this.i18n.getString("db_f45"));
            }
        }
        return true;
    }

    private void verarbeiteDto(CsvDto csvDto) {
        try {
            Object object;
            HashSet<String> hashSet = new HashSet<String>();
            for (String arrayList2 : csvDto.getWeitereSternnamen()) {
                String string = this.fixNames.korrigiereNamen(arrayList2);
                hashSet.add(string);
            }
            hashSet.add(this.fixNames.korrigiereNamen(csvDto.getSternName()));
            HashSet hashSet2 = new HashSet();
            for (String string : csvDto.getWeiterePlanetennamen()) {
                String string2 = this.fixNames.korrigiereNamen(string);
                hashSet2.add(string2);
            }
            hashSet2.add(this.fixNames.korrigiereNamen(csvDto.getPlanetName()));
            ArrayList<String> arrayList = new ArrayList<String>(hashSet);
            ArrayList<String> arrayList2 = new ArrayList<String>(hashSet2);
            int n = this.objektnamenRepository.countNamen(arrayList);
            if (n <= 0) {
                for (String string : arrayList) {
                    object = this.fixNames.korrigiereNamenMehrfachstern(string);
                    if (((String)object).equals(string)) continue;
                    arrayList.remove(string);
                    arrayList.add((String)object);
                    n = this.objektnamenRepository.countNamen(arrayList);
                    break;
                }
            }
            PlanetensucheObjektPruefer planetensucheObjektPruefer = this.erzeugePlanetensucheObjektFuerStern(n, arrayList, "NASA");
            this.setzteDatenFuerStern(csvDto, planetensucheObjektPruefer);
            boolean bl = this.speichereObjekt(planetensucheObjektPruefer, n);
            if (bl) {
                object = this.erzeugePlanetensucheObjektPlanet(arrayList2, "NASA", planetensucheObjektPruefer, csvDto);
                this.setzteDatenFuerPlanet(csvDto, (PlanetensucheObjektPruefer)object, planetensucheObjektPruefer.getObjektNamen(), ((PlanetensucheObjekt)object).getObjektNamen());
                n = this.objektnamenRepository.countNamen(((PlanetensucheObjekt)object).getObjektNamen());
                boolean bl2 = this.speichereObjekt((PlanetensucheObjektPruefer)object, n);
                if (!bl2) {
                    this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
                }
            } else {
                this.nichtEingefuegteObjekte.add(csvDto.getSternName());
                this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
            }
        }
        catch (InvalidCatalogException invalidCatalogException) {
            this.handleInvalidCatalogException(invalidCatalogException, csvDto);
        }
        catch (PsObjectMergeException psObjectMergeException) {
            this.handleMergeException(psObjectMergeException, csvDto);
        }
        catch (QueryException | IOException | IllegalArgumentException | StringIndexOutOfBoundsException | SQLException exception) {
            this.logger.error(exception);
            this.importDialog.appendOutput("Objekte fehlerhaft: " + csvDto.getSternName() + "/" + csvDto.getPlanetName());
            this.nichtEingefuegteObjekte.add(csvDto.getSternName());
            this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
        }
    }

    @Override
    void setzeEntdecker(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer, List<String> list) throws SQLException {
    }

    @Override
    void setzteSternSptyp(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
    }

    @Override
    void setzteSternRa(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
    }

    @Override
    void setzteSternDecl(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
    }
}

