/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv;

import com.querydsl.core.QueryException;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.importierer.api.ImportController;
import de.planetensuche.datenbank.importierer.csv.AbstractCsvImportierer;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.paris.ParisExoplanetCsvZuDtoKonverter;
import de.planetensuche.datenbank.importierer.merge.PsObjectMergeException;
import de.planetensuche.datenbank.importierer.validator.InvalidCatalogException;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class ParisExoplanetCsvImportierer
extends AbstractCsvImportierer {
    public ParisExoplanetCsvImportierer(File file, ImportController importController, ParameterDto parameterDto, InjectionDto injectionDto, Katalogerkenner katalogerkenner, KonfigurationDTO konfigurationDTO) throws IOException {
        super(file, importController.getXMLDatei(), importController.getDialog(), parameterDto, injectionDto, katalogerkenner, konfigurationDTO);
    }

    @Override
    public boolean importiereCsvDatei() throws IOException {
        System.out.println("start csv import...");
        ParisExoplanetCsvZuDtoKonverter parisExoplanetCsvZuDtoKonverter = new ParisExoplanetCsvZuDtoKonverter();
        List<CsvDto> list = parisExoplanetCsvZuDtoKonverter.leseDtos(this.csvDatei);
        this.gesamteObjektanzahl = list.size();
        this.verarbeiteteObjektanzahl = 0;
        long l = System.currentTimeMillis();
        for (CsvDto csvDto : list) {
            if (this.isInterrupted()) break;
            if (csvDto.getSternName() == null || "".equals(csvDto.getSternName())) {
                this.logger.warn("kein Sternname angegeben: " + csvDto.getPlanetName());
            } else {
                this.verarbeiteDto(csvDto);
            }
            ++this.verarbeiteteObjektanzahl;
            this.aktualisiereFortschrittsbalken(l);
        }
        if (this.importDialog.umleitungInXML()) {
            if (!this.psobjekteFuerXMLDatei.isEmpty()) {
                IPlanetensucheObjekt[] iPlanetensucheObjektArray = new IPlanetensucheObjekt[this.psobjekteFuerXMLDatei.size()];
                for (int i = 0; i < this.psobjekteFuerXMLDatei.size(); ++i) {
                    iPlanetensucheObjektArray[i] = (IPlanetensucheObjekt)this.psobjekteFuerXMLDatei.get(i);
                }
                this.oeffneExportDialog(iPlanetensucheObjektArray);
            } else {
                this.importDialog.appendOutput(this.i18n.getString("db_f44"));
                this.importDialog.appendOutput(this.i18n.getString("db_f45"));
            }
        }
        return true;
    }

    @Override
    void setzteSternSptyp(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        if (csvDto.getSternSptyp() != null && !csvDto.getSternSptyp().isEmpty()) {
            String[] stringArray = this.korrigiereSpektraltyp.getKorrigierterSptypFrObsCSV(csvDto.getSternSptyp()).split(";");
            if (stringArray.length == 3 && !stringArray[0].isEmpty()) {
                if (!"unbekannt".equals(stringArray[0])) {
                    if (this.wertUebernehmen(planetensucheObjektPruefer.isSpektralklasseUnbekannt())) {
                        planetensucheObjektPruefer.setSpektralklasse(stringArray[0].trim());
                        planetensucheObjektPruefer.setSpektralklasse2(Double.parseDouble(stringArray[1].trim()));
                    }
                    if (this.wertUebernehmen(planetensucheObjektPruefer.isLeuchtkraftklasseUnbekannt())) {
                        planetensucheObjektPruefer.setLeuchtkraftklasse(stringArray[2].trim());
                    }
                }
            } else {
                String string = "Spektraltyp nicht erkannt: '" + csvDto.getSternSptyp() + "'";
                this.logger.debug(string);
                this.importDialog.appendOutput(string);
            }
        }
    }

    @Override
    void setzteSternRa(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        if (CsvDto.istEigenschaftGesetzt(csvDto.getSternRa())) {
            double d = Double.parseDouble(csvDto.getSternRa());
            if ((d = d / 360.0 * 24.0) != 0.0 && this.wertUebernehmen(planetensucheObjektPruefer.isRaUnbekannt())) {
                planetensucheObjektPruefer.setRA(d);
            }
        }
    }

    @Override
    void setzteSternDecl(CsvDto csvDto, PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException {
        double d;
        if (CsvDto.istEigenschaftGesetzt(csvDto.getSternDecl()) && (d = Double.parseDouble(csvDto.getSternDecl())) != 0.0 && this.wertUebernehmen(planetensucheObjektPruefer.isDeclUnbekannt())) {
            planetensucheObjektPruefer.setDECL(d);
        }
    }

    private void verarbeiteDto(CsvDto csvDto) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add(this.fixNames.korrigiereNamen(csvDto.getSternName()));
            arrayList2.add(this.fixNames.korrigiereNamen(csvDto.getPlanetName()));
            if (((String)arrayList.get(0)).equals(arrayList2.get(0))) {
                this.logger.warn("Stern und Exoplanet haben den selben Namen (" + (String)arrayList.get(0) + ")!");
                this.importDialog.appendOutput("Objekte fehlerhaft: " + csvDto.getSternName());
                this.nichtEingefuegteObjekte.add(csvDto.getSternName());
                return;
            }
            int n = this.objektnamenRepository.countNamen(arrayList);
            if (n <= 0) {
                for (String object2 : arrayList) {
                    String string = this.fixNames.korrigiereNamenMehrfachstern(object2);
                    if (string.equals(object2)) continue;
                    arrayList.remove(object2);
                    arrayList.add(string);
                    n = this.objektnamenRepository.countNamen(arrayList);
                    break;
                }
            }
            PlanetensucheObjektPruefer planetensucheObjektPruefer = this.erzeugePlanetensucheObjektFuerStern(n, arrayList, "Jean Schneider");
            this.setzteDatenFuerStern(csvDto, planetensucheObjektPruefer);
            this.speichereObjekt(planetensucheObjektPruefer, n);
            PlanetensucheObjektPruefer planetensucheObjektPruefer2 = this.erzeugePlanetensucheObjektPlanet(arrayList2, "Jean Schneider", planetensucheObjektPruefer, csvDto);
            this.setzteDatenFuerPlanet(csvDto, planetensucheObjektPruefer2, arrayList, arrayList2);
            n = this.objektnamenRepository.countNamen(planetensucheObjektPruefer2.getObjektNamen());
            this.speichereObjekt(planetensucheObjektPruefer2, n);
        }
        catch (InvalidCatalogException invalidCatalogException) {
            this.handleInvalidCatalogException(invalidCatalogException, csvDto);
        }
        catch (PsObjectMergeException psObjectMergeException) {
            this.handleMergeException(psObjectMergeException, csvDto);
        }
        catch (QueryException | IOException | IllegalArgumentException | SQLException exception) {
            this.logger.error(exception);
            this.importDialog.appendOutput("Objekte fehlerhaft: " + csvDto.getSternName() + "/" + csvDto.getPlanetName());
            this.nichtEingefuegteObjekte.add(csvDto.getSternName());
            this.nichtEingefuegteObjekte.add(csvDto.getPlanetName());
        }
    }
}

