/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvException;
import de.planetensuche.core.Check;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.base.CsvZuDtoKonverterStrategie;
import de.planetensuche.datenbank.importierer.csv.base.FileHeaderNotCompleteException;
import de.planetensuche.datenbank.importierer.csv.nasa.ExofopPlanetStatus;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class CtoiCsvZuDtoKonverter
implements CsvZuDtoKonverterStrategie {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private int spalteSternCtoiName = -1;
    private int spalteSternRa = -1;
    private int spalteSternDecl = -1;
    private int spalteSternEntfernung = -1;
    private int spalteSternTemperatur = -1;
    private int spalteSternRadius = -1;
    private int spaltePlanetCtoiName = -1;
    private int spaltePlanetRadius = -1;
    private int spaltePlanetUmlaufszeit = -1;
    private int spaltePlanetUmlaufszeitError = -1;
    private int spaltePlanetTemperatur = -1;
    private int spaltePlanetEntfernung = -1;
    private int spaltePlanetEntdecker = -1;
    private int spaltePlanetEntdeckungsdatum = -1;
    private int spaltePlanetStatusUser = -1;
    private int spaltePlanetStatusExofop = -1;
    private int spaltePlanetTransitEpoch = -1;
    private int spaltePlanetTransitEpochError = -1;
    private int spalteWeitereNamen = -1;
    private int spalteNotiz = -1;

    @Override
    public List<CsvDto> leseDtos(File file) throws IOException {
        ArrayList<CsvDto> arrayList = new ArrayList<CsvDto>();
        CSVParser cSVParser = new CSVParserBuilder().withSeparator(',').build();
        try (CSVReader cSVReader = new CSVReaderBuilder(new FileReader(file)).withCSVParser(cSVParser).build();){
            try {
                List<String[]> list = cSVReader.readAll();
                this.logging.info(list.size() + " lines parsed from csv file");
                for (Object[] objectArray : list) {
                    try {
                        String string = objectArray[0];
                        if (string.startsWith("TIC ID")) {
                            this.erkenneSpaltenaufbau((String[])objectArray);
                            continue;
                        }
                        ExofopPlanetStatus exofopPlanetStatus = ExofopPlanetStatus.parse((String)objectArray[this.spaltePlanetStatusExofop]);
                        CsvDto csvDto = this.getDtoFuerZeile((String[])objectArray, exofopPlanetStatus);
                        arrayList.add(csvDto);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logging.error("Zeile fehlerhaft: '" + Arrays.toString(objectArray) + "'", numberFormatException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.logging.warn("Zeile fehlerhaft: Exofop Status '" + (String)objectArray[this.spaltePlanetStatusExofop] + "', User Status '" + (String)objectArray[this.spaltePlanetStatusUser] + "' f\u00fcr TIC " + (String)objectArray[0], illegalArgumentException);
                    }
                }
            }
            catch (CsvException csvException) {
                throw new IOException(csvException);
            }
        }
        return arrayList;
    }

    private CsvDto getDtoFuerZeile(String[] stringArray, ExofopPlanetStatus exofopPlanetStatus) {
        double d;
        CsvDto csvDto = new CsvDto();
        csvDto.setPlanetName("TIC " + stringArray[this.spaltePlanetCtoiName]);
        csvDto.setSternName("TIC " + stringArray[this.spalteSternCtoiName]);
        String string = stringArray[this.spalteWeitereNamen];
        if (Check.isFilled(string)) {
            csvDto.getWeiterePlanetennamen().add("TOI-" + string);
            csvDto.getWeitereSternnamen().add("TOI-" + string.substring(0, string.length() - 3));
        }
        csvDto.setSternRa(stringArray[this.spalteSternRa]);
        csvDto.setSternDecl(stringArray[this.spalteSternDecl]);
        if (Check.isFilled(stringArray[this.spalteSternEntfernung]) && (d = Double.parseDouble(stringArray[this.spalteSternEntfernung])) > 0.0) {
            csvDto.setSternEntfernungInPc(d);
        }
        if (Check.isFilled(stringArray[this.spalteSternTemperatur]) && (d = Double.parseDouble(stringArray[this.spalteSternTemperatur])) > 0.0) {
            csvDto.setSternTemperatur(d);
        }
        if (Check.isFilled(stringArray[this.spalteSternRadius]) && (d = Double.parseDouble(stringArray[this.spalteSternRadius])) > 0.0) {
            csvDto.setSternRadius(d);
        }
        if (Check.isFilled(stringArray[this.spaltePlanetTransitEpoch])) {
            csvDto.setPlanetTransitBjd(Double.parseDouble(stringArray[this.spaltePlanetTransitEpoch]));
        }
        if (Check.isFilled(stringArray[this.spaltePlanetTransitEpochError])) {
            csvDto.setPlanetTransitBjdError(Double.parseDouble(stringArray[this.spaltePlanetTransitEpochError]));
        }
        if (Check.isFilled(stringArray[this.spaltePlanetUmlaufszeit]) && (d = Double.parseDouble(stringArray[this.spaltePlanetUmlaufszeit])) > 0.0) {
            csvDto.setPlanetUmlaufszeit(d);
        }
        if (Check.isFilled(stringArray[this.spaltePlanetUmlaufszeitError])) {
            csvDto.setPlanetUmlaufszeitError(Double.parseDouble(stringArray[this.spaltePlanetUmlaufszeitError]));
        }
        if (Check.isFilled(stringArray[this.spaltePlanetRadius]) && (d = Double.parseDouble(stringArray[this.spaltePlanetRadius])) > 0.0) {
            csvDto.setPlanetRadius(d * 0.0892);
        }
        if (Check.isFilled(stringArray[this.spaltePlanetTemperatur]) && (d = Double.parseDouble(stringArray[this.spaltePlanetTemperatur])) != 0.0) {
            csvDto.setPlanetTemperatur(d);
        }
        if (Check.isFilled(stringArray[this.spaltePlanetEntfernung]) && (d = Double.parseDouble(stringArray[this.spaltePlanetEntfernung])) > 0.0) {
            csvDto.setPlanetGrosseHalbachse(d);
        }
        csvDto.setPlanetEntdeckungsjahr(stringArray[this.spaltePlanetEntdeckungsdatum].substring(0, 4));
        csvDto.setPlanetEntdeckungBestaetigt(exofopPlanetStatus.isConfirmedPlanet());
        if (Check.isEmpty(stringArray[this.spaltePlanetStatusExofop])) {
            csvDto.setPlanetExofopDisposition(stringArray[this.spaltePlanetStatusUser]);
        } else {
            csvDto.setPlanetExofopDisposition(stringArray[this.spaltePlanetStatusExofop]);
        }
        csvDto.setPlanetEntdeckungsmethode("Transit-Suchmethode");
        this.setDiscoverer(stringArray, csvDto, exofopPlanetStatus);
        if (Check.isFilled(stringArray[this.spalteNotiz])) {
            csvDto.setNotiz(stringArray[this.spalteNotiz]);
        }
        csvDto.setExofopEntryCreated(Timestamp.valueOf(stringArray[this.spaltePlanetEntdeckungsdatum]));
        return csvDto;
    }

    private void setDiscoverer(String[] stringArray, CsvDto csvDto, ExofopPlanetStatus exofopPlanetStatus) {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        if (!exofopPlanetStatus.isKnownPlanet()) {
            hashSet.add(EntdeckerWeltraumteleskope.TESS.getNameInDatabase());
        }
        if ("eisner".equals(string = stringArray[this.spaltePlanetEntdecker]) || "mason".equals(string) || "aigrain".equals(string) || "spencer".equals(string) || "nunes".equals(string)) {
            hashSet.add("Eisner");
            hashSet.add(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase());
        } else {
            hashSet.add(string);
        }
        csvDto.setPlanetEntdecker(hashSet);
    }

    private void erkenneSpaltenaufbau(String[] stringArray) {
        int n = 0;
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            String string;
            switch (string = stringArray2[i]) {
                case "TIC ID": {
                    this.spalteSternCtoiName = n;
                    break;
                }
                case "CTOI": {
                    this.spaltePlanetCtoiName = n;
                    break;
                }
                case "Promoted to TOI": {
                    this.spalteWeitereNamen = n;
                    break;
                }
                case "User Disposition": {
                    this.spaltePlanetStatusUser = n;
                    break;
                }
                case "TFOPWG Disposition": {
                    this.spaltePlanetStatusExofop = n;
                    break;
                }
                case "RA": {
                    this.spalteSternRa = n;
                    break;
                }
                case "Dec": {
                    this.spalteSternDecl = n;
                    break;
                }
                case "Transit Epoch (BJD)": {
                    this.spaltePlanetTransitEpoch = n;
                    break;
                }
                case "Transit Epoch (BJD) err": {
                    this.spaltePlanetTransitEpochError = n;
                    break;
                }
                case "Period (days)": {
                    this.spaltePlanetUmlaufszeit = n;
                    break;
                }
                case "Period (days) Error": {
                    this.spaltePlanetUmlaufszeitError = n;
                    break;
                }
                case "Planet Radius (R_Earth)": {
                    this.spaltePlanetRadius = n;
                    break;
                }
                case "Equilibrium Temp (K)": {
                    this.spaltePlanetTemperatur = n;
                    break;
                }
                case "Semi-Major Axis (AU)": {
                    this.spaltePlanetEntfernung = n;
                    break;
                }
                case "Stellar Distance (pc)": {
                    this.spalteSternEntfernung = n;
                    break;
                }
                case "Stellar Eff Temp (K)": {
                    this.spalteSternTemperatur = n;
                    break;
                }
                case "Stellar Radius (R_Sun)": {
                    this.spalteSternRadius = n;
                    break;
                }
                case "CTOI lastmod": {
                    this.spaltePlanetEntdeckungsdatum = n;
                    break;
                }
                case "User": {
                    this.spaltePlanetEntdecker = n;
                    break;
                }
                case "Notes": {
                    this.spalteNotiz = n;
                    break;
                }
            }
            ++n;
        }
        this.validateFileHeader();
    }

    private void validateFileHeader() {
        if (this.spalteSternCtoiName == -1) {
            throw new FileHeaderNotCompleteException("column for star TIC id not found");
        }
        if (this.spaltePlanetCtoiName == -1) {
            throw new FileHeaderNotCompleteException("column for planet TIC id not found");
        }
    }
}

