/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import de.planetensuche.datenbank.importierer.csv.nasa.CsvFileNames;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ExofopCsvDownloader {
    private static final String CTOI_URL = "https://exofop.ipac.caltech.edu/tess/download_ctoi.php?sort=ctoi&output=csv";
    private static final String TOI_URL = "https://exofop.ipac.caltech.edu/tess/download_toi.php?output=csv";
    private static final long ONE_DAY_IN_MS = 86400000L;
    private final ILogging logger = LoggingFactory.getLoggerForClass(ExofopCsvDownloader.class);
    private final String importFolder;
    private final boolean withDownloadFiles;

    public ExofopCsvDownloader(String string, boolean bl) {
        this.importFolder = string;
        this.withDownloadFiles = bl;
    }

    public File downloadCtoiFile() throws IOException {
        File file = new File(this.importFolder + File.separator + CsvFileNames.CTOI_CANDIDATES.getFilename());
        if (file.exists() && file.lastModified() > System.currentTimeMillis() - 86400000L) {
            this.logger.info("use existing CTOI csv file...");
        } else if (this.withDownloadFiles) {
            this.logger.info("download CTOI csv file...");
            List<String> list = IOUtils.readLines(new URL(CTOI_URL).openStream(), "utf8");
            FileUtils.writeLines(file, "utf8", list, false);
        }
        return file;
    }

    public File downloadToiFile() throws IOException {
        File file = new File(this.importFolder + File.separator + CsvFileNames.TOI_CANDIDATES.getFilename());
        if (file.exists() && file.lastModified() > System.currentTimeMillis() - 86400000L) {
            this.logger.info("use existing TOI csv file...");
        } else if (this.withDownloadFiles) {
            this.logger.info("download TOI csv file...");
            List<String> list = IOUtils.readLines(new URL(TOI_URL).openStream(), "utf8");
            FileUtils.writeLines(file, "utf8", list, false);
        }
        return file;
    }
}

