/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

public enum ExofopPlanetStatus {
    CONFIRMED_PLANET("CP"),
    KNOWN_PLANET("KP"),
    PLANET_CANDIDATE("PC"),
    AMBIGUOUS_PLANET_CANDIDATE("APC"),
    FALSE_POSITIVE("FP"),
    FALSE_ALARM("FA"),
    ECLIPSING_BINARY("EB"),
    OTHER("O"),
    UNKNOWN("");

    private final String exofopKuerzel;

    private ExofopPlanetStatus(String string2) {
        this.exofopKuerzel = string2;
    }

    public String getExofopKuerzel() {
        return this.exofopKuerzel;
    }

    public static ExofopPlanetStatus parse(String string) {
        for (ExofopPlanetStatus exofopPlanetStatus : ExofopPlanetStatus.values()) {
            if (!exofopPlanetStatus.exofopKuerzel.equals(string)) continue;
            return exofopPlanetStatus;
        }
        throw new IllegalArgumentException("unknown exofop status '" + string + "'");
    }

    public boolean isConfirmedPlanet() {
        return this.exofopKuerzel.equals(ExofopPlanetStatus.CONFIRMED_PLANET.exofopKuerzel) || this.exofopKuerzel.equals(ExofopPlanetStatus.KNOWN_PLANET.exofopKuerzel);
    }

    public boolean isPlanetCandidate() {
        return this.exofopKuerzel.equals(ExofopPlanetStatus.PLANET_CANDIDATE.exofopKuerzel);
    }

    public boolean isFalsePositive() {
        return this.exofopKuerzel.equals(ExofopPlanetStatus.FALSE_POSITIVE.exofopKuerzel) || this.exofopKuerzel.equals(ExofopPlanetStatus.ECLIPSING_BINARY.exofopKuerzel) || this.exofopKuerzel.equals(ExofopPlanetStatus.FALSE_ALARM.exofopKuerzel) || this.exofopKuerzel.equals(ExofopPlanetStatus.AMBIGUOUS_PLANET_CANDIDATE.exofopKuerzel) || this.exofopKuerzel.equals(ExofopPlanetStatus.OTHER.exofopKuerzel);
    }

    public boolean isUnknown() {
        return this.exofopKuerzel.equals(ExofopPlanetStatus.UNKNOWN.exofopKuerzel);
    }

    public boolean isKnownPlanet() {
        return this.exofopKuerzel.equals(ExofopPlanetStatus.KNOWN_PLANET.exofopKuerzel);
    }

    public boolean isEb() {
        return this.exofopKuerzel.equals(ExofopPlanetStatus.ECLIPSING_BINARY.exofopKuerzel);
    }
}

