/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class LoggingInterceptor
implements ClientHttpRequestInterceptor {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    @Override
    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] byArray, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        this.logger.debug(httpRequest.getMethod().toString() + " " + httpRequest.getURI().toString());
        this.logger.debug("request header: " + String.valueOf(httpRequest.getHeaders()));
        this.logger.debug("Request body:");
        this.logger.debug(new String(byArray, StandardCharsets.UTF_8));
        ClientHttpResponse clientHttpResponse = clientHttpRequestExecution.execute(httpRequest, byArray);
        this.logger.debug("response status: " + String.valueOf(clientHttpResponse.getStatusCode()));
        if (this.logger.isDebugEnabled()) {
            InputStreamReader inputStreamReader = new InputStreamReader(clientHttpResponse.getBody(), StandardCharsets.UTF_8);
            String string = new BufferedReader(inputStreamReader).lines().collect(Collectors.joining("\n"));
            this.logger.debug("Response body:");
            this.logger.debug(string);
        }
        return clientHttpResponse;
    }
}

