/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import de.planetensuche.datenbank.importierer.csv.nasa.CsvFileNames;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public final class NasaCsvDownloader {
    private static final String URL_EXOPLANET_MAIN_COMPOSITE = "https://exoplanetarchive.ipac.caltech.edu/TAP/sync?query=select+hostname,hd_name,hip_name,tic_id,gaia_dr2_id,gaia_dr3_id,pl_letter,pl_name,ra,dec,sy_dist,sy_vmag,sy_bmag,st_teff,st_mass,st_rad,st_radv,st_spectype,st_met,st_age,sy_snum,pl_controv_flag,pl_orbper,pl_orbsmax,pl_orbeccen,pl_bmassj,pl_radj,pl_eqt,discoverymethod,disc_year,disc_pubdate,disc_refname,disc_facility,disc_telescope,disc_instrument+from+pscomppars&format=csv";
    private static final String URL_KEPLER_NAMES = "https://exoplanetarchive.ipac.caltech.edu/TAP/sync?query=select+*+from+keplernames&format=csv";
    private static final String URL_K2_NAMES = "https://exoplanetarchive.ipac.caltech.edu/TAP/sync?query=select+epic_id,k2_name,pl_name+from+k2names&format=csv";
    private static final int EXOPLANET_MAIN_MIN_NUMBER_OF_LINES = 5000;
    private static final int EXOPLANET_MAIN_MIN_NUMBER_OF_COLUMNS = 31;
    private static final int KEPLER_NAMES_MIN_NUMBER_OF_LINES = 2300;
    private static final int KEPLER_NAMES_MIN_NUMBER_OF_COLUMNS = 4;
    private static final int K2_NAMES_MIN_NUMBER_OF_LINES = 300;
    private static final int K2_NAMES_MIN_NUMBER_OF_COLUMNS = 3;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final String tempDir;
    private final JFrame databaseDialog;
    private final ISprachcontainer sprachcontainer;
    private final RestTemplate restTemplate;

    public NasaCsvDownloader(String string, JFrame jFrame) {
        this.tempDir = string;
        this.databaseDialog = jFrame;
        this.sprachcontainer = SprachcontainerFabrik.getSprachcontainer();
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpComponentsClientHttpRequestFactory.setConnectionRequestTimeout(16000);
        httpComponentsClientHttpRequestFactory.setReadTimeout(16000);
        this.restTemplate = new RestTemplate();
        this.restTemplate.setRequestFactory(httpComponentsClientHttpRequestFactory);
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setSupportedMediaTypes(Arrays.asList(new MediaType("text", "plain", StandardCharsets.UTF_8)));
        this.restTemplate.setMessageConverters(Arrays.asList(stringHttpMessageConverter));
    }

    public boolean downloadFiles(AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor) {
        boolean bl = false;
        try {
            asyncLoadingScreenCallbackExecutor.setProgress(0);
            ResponseEntity<String> responseEntity = this.restTemplate.getForEntity(URI.create(URL_EXOPLANET_MAIN_COMPOSITE), String.class);
            this.logger.debug("main table status code: " + responseEntity.getStatusCode().toString());
            asyncLoadingScreenCallbackExecutor.setProgress(10);
            List<String> list = Arrays.asList(((String)responseEntity.getBody()).split("\\n"));
            FileUtils.writeLines(new File(this.tempDir + "/" + CsvFileNames.NASA_EXOPLANETS.getFilename()), "utf8", list, bl);
            this.logger.debug("exoplanet main table downloaded");
            asyncLoadingScreenCallbackExecutor.setProgress(20);
            if (!this.checkCsvIntegrity(list, 5000, 31)) {
                this.showErrorMsg("db_m464", "db_m463_titel");
                return false;
            }
            asyncLoadingScreenCallbackExecutor.setProgress(30);
            responseEntity = this.restTemplate.getForEntity(URI.create(URL_KEPLER_NAMES), String.class);
            this.logger.debug("kepler names status code: " + responseEntity.getStatusCode().toString());
            asyncLoadingScreenCallbackExecutor.setProgress(40);
            list = Arrays.asList(((String)responseEntity.getBody()).split("\\n"));
            FileUtils.writeLines(new File(this.tempDir + "/" + CsvFileNames.NASA_KEPLER_NAMES.getFilename()), "utf8", list, bl);
            this.logger.debug("exoplanet kepler names downloaded");
            asyncLoadingScreenCallbackExecutor.setProgress(50);
            if (!this.checkCsvIntegrity(list, 2300, 4)) {
                this.showErrorMsg("db_m464", "db_m463_titel2");
                return false;
            }
            asyncLoadingScreenCallbackExecutor.setProgress(60);
            responseEntity = this.restTemplate.getForEntity(URI.create(URL_K2_NAMES), String.class);
            this.logger.debug("k2 names status code: " + responseEntity.getStatusCode().toString());
            asyncLoadingScreenCallbackExecutor.setProgress(70);
            list = Arrays.asList(((String)responseEntity.getBody()).split("\\n"));
            FileUtils.writeLines(new File(this.tempDir + "/" + CsvFileNames.NASA_K2_NAMES.getFilename()), "utf8", list, bl);
            this.logger.debug("exoplanet k2 names downloaded");
            asyncLoadingScreenCallbackExecutor.setProgress(80);
            if (!this.checkCsvIntegrity(list, 300, 3)) {
                this.showErrorMsg("db_m464", "db_m463_titel3");
                return false;
            }
            asyncLoadingScreenCallbackExecutor.setProgress(90);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            String string;
            Throwable throwable = ExceptionUtils.getRootCause(exception);
            if (exception instanceof SocketTimeoutException || throwable instanceof SocketTimeoutException) {
                string = this.sprachcontainer.getString("db_f120");
                this.logger.warn("NASA download error", exception);
            } else {
                string = this.sprachcontainer.getString("db_f118");
                this.logger.error("NASA download error", exception);
            }
            JOptionPane.showMessageDialog(this.databaseDialog, string, this.sprachcontainer.getString("db_f120_titel"), 0);
            return false;
        }
    }

    private boolean checkCsvIntegrity(List<String> list, int n, int n2) {
        if (list == null) {
            this.logger.error("file have no lines!", null);
            return false;
        }
        if (list.size() >= n) {
            String string = list.get(0);
            String[] stringArray = string.split(",");
            if (stringArray.length >= n2) {
                return true;
            }
            this.logger.warn("file contains " + stringArray.length + " columns and min. " + n2 + " columns are expected");
        }
        this.logger.warn("file contains " + list.size() + " lines and min. " + n + " lines are expected");
        return false;
    }

    private void showErrorMsg(String string, String string2) {
        String string3 = this.sprachcontainer.getString(string);
        String string4 = this.sprachcontainer.getString(string2);
        JOptionPane.showMessageDialog(this.databaseDialog, string3, string4, 0);
    }
}

