/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import java.util.HashSet;
import java.util.Set;

public final class NasaEntdeckerParser {
    public Set<String> getLastNames(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        String string2 = string;
        if (string.startsWith("<a href=") || string.startsWith("<a refstr=")) {
            int n = string.indexOf(">");
            String string3 = string.substring(n + 1, string.length());
            int n2 = string3.indexOf("<");
            string2 = string3.substring(0, n2).trim();
        }
        Set<String> set = this.processDiscovererParsing(string2);
        this.fixDiscovererNameTypos(set);
        return set;
    }

    private void fixDiscovererNameTypos(Set<String> set) {
        if (set.contains("Dollinger")) {
            set.remove("Dollinger");
            set.add("Doellinger");
        }
        if (set.contains("McArthur")) {
            set.remove("McArthur");
            set.add("Mc Arthur");
        }
        if (set.contains("McCarthy")) {
            set.remove("McCarthy");
            set.add("Mc Carthy");
        }
        if (set.contains("McCullogh")) {
            set.remove("McCullogh");
            set.add("McCullough");
        }
        if (set.contains("Neuhauser")) {
            set.remove("Neuhauser");
            set.add("Neuhaeuser");
        }
        if (set.contains("Kane")) {
            set.remove("Kane");
            set.add("O'Kane");
        }
        if (set.contains("Kurster")) {
            set.remove("Kurster");
            set.add("Kuerster");
        }
        if (set.contains("Lafreni\u00e8re")) {
            set.remove("Lafreni\u00e8re");
            set.add("Lafreniere");
        }
        if (set.contains("Collier Cameron")) {
            set.remove("Collier Cameron");
            set.add("Collier-Cameron");
        }
        if (set.contains("Gomez")) {
            set.remove("Gomez");
            set.add("Gomez Maqueo Chew");
        }
    }

    private Set<String> processDiscovererParsing(String string) {
        String[] stringArray;
        int n;
        String string2 = string;
        if (string2.contains("et al.")) {
            n = string2.indexOf("et al.");
            string2 = string2.substring(0, n).trim();
        }
        if (string2.contains("20") || string2.contains("19")) {
            string2 = string2.substring(0, string2.length() - 4).trim();
        }
        if (string2.contains("acute;")) {
            n = string2.indexOf("acute;");
            stringArray = string2.substring(n - 1, n);
            string2 = string2.replace("&" + (String)stringArray + "acute;", (CharSequence)stringArray);
        }
        if ((string2 = string2.replace("&uuml;", "\u00fc").replace("&ouml;", "\u00f6").replace("&auml;", "\u00e4").replace("&euml;", "\u00eb")).contains("Lafreni&egrave;re")) {
            string2 = "Lafreniere";
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (string2.contains(" & ")) {
            stringArray = string2.split(" & ");
            hashSet.add(stringArray[0]);
            hashSet.add(stringArray[1]);
        } else if (string2.contains(" &amp; ")) {
            stringArray = string2.split(" &amp; ");
            hashSet.add(stringArray[0]);
            hashSet.add(stringArray[1]);
        } else {
            hashSet.add(string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length()));
        }
        return hashSet;
    }
}

