/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class NasaExoplanetProjectParser {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Set<String> parseDiscovererProject(String string, String string2, String string3, CsvDto csvDto) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null || string.isEmpty()) {
            return hashSet;
        }
        String string4 = string.toLowerCase();
        String string5 = string2.toLowerCase();
        if (string4.contains("kepler") || string5.contains("kepler") || "k2".equalsIgnoreCase(string4)) {
            hashSet.add(EntdeckerWeltraumteleskope.KEPLER.getNameInDatabase());
            Set<String> set = csvDto.getPlanetEntdecker();
            if (Check.isFilled(set) && set.contains("Borucki")) {
                hashSet.add(EntdeckerProjekte.KEPLER_K2_TEAM.getNameInDatabase());
            }
        } else if (string4.contains("spitzer")) {
            hashSet.add(EntdeckerWeltraumteleskope.SPITZER.getNameInDatabase());
        } else if (string4.contains("hubble")) {
            hashSet.add(EntdeckerWeltraumteleskope.HUBBLE.getNameInDatabase());
        } else if (string4.contains("corot")) {
            hashSet.add(EntdeckerWeltraumteleskope.COROT.getNameInDatabase());
            hashSet.add(EntdeckerProjekte.COROT_TEAM.getNameInDatabase());
        } else if (string4.contains("(jwst)") || string5.contains("james webb space telescope")) {
            hashSet.add(EntdeckerWeltraumteleskope.JWST.getNameInDatabase());
        } else if (string4.contains("(tess)")) {
            hashSet.add(EntdeckerWeltraumteleskope.TESS.getNameInDatabase());
            Set<String> set = csvDto.getPlanetEntdecker();
            if (Check.isFilled(set)) {
                List<String> list = Arrays.asList("Collins", "Crossfield", "Dragomir", "Huang", "Quinn", "Shporer", "Vanderburg", "Rodriguez", "Daylan", "Burt", "Vanderspek", "G\u00fcnther");
                for (String string6 : list) {
                    if (!set.contains(string6)) continue;
                    hashSet.add(EntdeckerProjekte.TESS_SCIENCE_OFFICE.getNameInDatabase());
                    break;
                }
            }
        } else if (string4.contains("cheops")) {
            hashSet.add(EntdeckerWeltraumteleskope.CHEOPS.getNameInDatabase());
        } else if (string4.contains("gaia")) {
            hashSet.add(EntdeckerWeltraumteleskope.GAIA.getNameInDatabase());
            Set<String> set = csvDto.getPlanetEntdecker();
            if (Check.isFilled(set)) {
                List<String> list = Arrays.asList("Panahi", "Zucker", "Clementini", "Audard", "Binnenfeld", "Cusano", "Evans", "Gomel", "Holl");
                for (String string7 : list) {
                    if (!set.contains(string7)) continue;
                    hashSet.add(EntdeckerProjekte.DPAC_GAIA.getNameInDatabase());
                    break;
                }
            }
        }
        if (string4.contains("anglo-australian")) {
            hashSet.add(EntdeckerProjekte.AAPS.getNameInDatabase());
        } else if (string4.contains("la silla") || string4.contains("haute-provence")) {
            hashSet.add(EntdeckerProjekte.GENEVA.getNameInDatabase());
        } else if (string5.contains("keck i ") || string4.contains("lick")) {
            hashSet.add(EntdeckerProjekte.CALIFORNIA.getNameInDatabase());
        } else if (string4.contains("hatnet")) {
            hashSet.add(EntdeckerProjekte.HAT.getNameInDatabase());
        } else if (string4.contains("hatsouth")) {
            hashSet.add(EntdeckerProjekte.HAT_SOUTH.getNameInDatabase());
        } else if (string4.contains("kelt")) {
            hashSet.add(EntdeckerProjekte.KELT.getNameInDatabase());
        } else if (string5.contains("magellan")) {
            hashSet.add(EntdeckerProjekte.MAGELLAN.getNameInDatabase());
        } else if (string4.equalsIgnoreCase("moa")) {
            hashSet.add(EntdeckerProjekte.MOA.getNameInDatabase());
        } else if (string4.contains("ogle")) {
            hashSet.add(EntdeckerProjekte.OGLE.getNameInDatabase());
        } else if (string4.contains("okayama")) {
            hashSet.add(EntdeckerProjekte.OKAYAMA.getNameInDatabase());
        } else if (string4.contains("tres")) {
            hashSet.add(EntdeckerProjekte.TRES.getNameInDatabase());
        } else if (string4.contains("wasp")) {
            hashSet.add(EntdeckerProjekte.WASP.getNameInDatabase());
        } else if (string4.equalsIgnoreCase("xo")) {
            hashSet.add(EntdeckerProjekte.XO.getNameInDatabase());
        } else if (string4.contains("kmtnet")) {
            hashSet.add(EntdeckerProjekte.KMT.getNameInDatabase());
        } else if (string4.contains("qatar")) {
            hashSet.add(EntdeckerProjekte.QATAR.getNameInDatabase());
        }
        if (string4.contains("gemini")) {
            hashSet.add(EntdeckerProjekte.GEMINI.getNameInDatabase());
        }
        if (string4.contains("mcdonald")) {
            hashSet.add(EntdeckerProjekte.MCDONALD.getNameInDatabase());
        }
        if (string4.contains("subaru")) {
            hashSet.add(EntdeckerProjekte.N2K.getNameInDatabase());
        }
        if (string3.equalsIgnoreCase("carmenes")) {
            hashSet.add(EntdeckerProjekte.CARMENES.getNameInDatabase());
        }
        if (string3.equalsIgnoreCase("Carnegie Planet Finder Spectrograph")) {
            hashSet.add(EntdeckerProjekte.CALIFORNIA.getNameInDatabase());
        }
        if (string3.equalsIgnoreCase("ESPRESSO")) {
            hashSet.add(EntdeckerProjekte.ESPRESSO.getNameInDatabase());
        }
        if (string3.contains("harps")) {
            hashSet.add(EntdeckerProjekte.HARPS.getNameInDatabase());
        }
        if (string3.equalsIgnoreCase("SPHERE")) {
            hashSet.add(EntdeckerProjekte.SPHERE.getNameInDatabase());
        }
        if (string3.contains("coralie")) {
            hashSet.add(EntdeckerProjekte.CORALIE.getNameInDatabase());
        }
        if (hashSet.isEmpty() && !string4.contains("multiple")) {
            this.logger.debug("kein exoplaneten Projekt gefunden f\u00fcr '" + string4 + "', '" + string5 + "', " + string3);
        }
        return hashSet;
    }
}

