/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvException;
import de.planetensuche.core.Check;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.base.CsvZuDtoKonverterStrategie;
import de.planetensuche.datenbank.importierer.csv.base.FileHeaderNotCompleteException;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class NasaK2NamesCsvZuDtoKonverter
implements CsvZuDtoKonverterStrategie {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private int spalteEpic = -1;
    private int spalteK2Name = -1;
    private int spalteAlternativeName = -1;

    @Override
    public List<CsvDto> leseDtos(File file) throws IOException {
        ArrayList<CsvDto> arrayList = new ArrayList<CsvDto>();
        CSVParser cSVParser = new CSVParserBuilder().withSeparator(',').build();
        try (CSVReader cSVReader = new CSVReaderBuilder(new FileReader(file)).withCSVParser(cSVParser).build();){
            try {
                List<String[]> list = cSVReader.readAll();
                for (Object[] objectArray : list) {
                    try {
                        String string = objectArray[0];
                        if (string.startsWith("#")) continue;
                        if (string.startsWith("rowid") || string.startsWith("epic_id")) {
                            this.erkenneSpaltenaufbau((String[])objectArray);
                            continue;
                        }
                        CsvDto csvDto = this.getDtoFuerZeile((String[])objectArray);
                        arrayList.add(csvDto);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logging.error("Zeile fehlerhaft: '" + Arrays.toString(objectArray) + "'", numberFormatException);
                    }
                }
            }
            catch (CsvException csvException) {
                throw new IOException(csvException);
            }
        }
        return arrayList;
    }

    private CsvDto getDtoFuerZeile(String[] stringArray) {
        String string;
        CsvDto csvDto = new CsvDto();
        String string2 = stringArray[this.spalteK2Name];
        csvDto.setPlanetName(string2);
        csvDto.setSternName(string2.substring(0, string2.length() - 2));
        String string3 = stringArray[this.spalteAlternativeName];
        if (Check.isFilled(string3)) {
            csvDto.getWeiterePlanetennamen().add(string3);
            int n = string3.contains(".") ? 3 : 2;
            csvDto.getWeitereSternnamen().add(string3.substring(0, string3.length() - n));
        }
        if (Check.isFilled(string = stringArray[this.spalteEpic])) {
            csvDto.getWeitereSternnamen().add(string);
        }
        return csvDto;
    }

    private void erkenneSpaltenaufbau(String[] stringArray) {
        int n = 0;
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            String string;
            switch (string = stringArray2[i]) {
                case "epic_id": {
                    this.spalteEpic = n;
                    break;
                }
                case "k2_name": {
                    this.spalteK2Name = n;
                    break;
                }
                case "pl_name": {
                    this.spalteAlternativeName = n;
                    break;
                }
            }
            ++n;
        }
        this.validateFileHeader();
    }

    private void validateFileHeader() {
        if (this.spalteEpic == -1) {
            throw new FileHeaderNotCompleteException("column for star EPIC id not found");
        }
        if (this.spalteK2Name == -1) {
            throw new FileHeaderNotCompleteException("column for planet K2 id not found");
        }
        if (this.spalteAlternativeName == -1) {
            throw new FileHeaderNotCompleteException("column for planet alternative name not found");
        }
    }
}

