/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvException;
import de.planetensuche.core.Check;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.base.CsvZuDtoKonverterStrategie;
import de.planetensuche.datenbank.importierer.csv.base.FileHeaderNotCompleteException;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public final class NasaKeplerNamesCsvZuDtoKonverter
implements CsvZuDtoKonverterStrategie {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private int spalteKic = -1;
    private int spalteKoi = -1;
    private int spalteKeplerName = -1;
    private int spalteAlternateName = -1;

    @Override
    public List<CsvDto> leseDtos(File file) throws IOException {
        ArrayList<CsvDto> arrayList = new ArrayList<CsvDto>();
        CSVParser cSVParser = new CSVParserBuilder().withSeparator(',').build();
        try (CSVReader cSVReader = new CSVReaderBuilder(new FileReader(file)).withCSVParser(cSVParser).build();){
            try {
                List<String[]> list = cSVReader.readAll();
                for (Object[] objectArray : list) {
                    try {
                        String string = objectArray[0];
                        if (string.startsWith("#")) continue;
                        if (string.startsWith("rowid") || string.startsWith("kepid")) {
                            this.erkenneSpaltenaufbau((String[])objectArray);
                            continue;
                        }
                        CsvDto csvDto = this.getDtoFuerZeile((String[])objectArray);
                        arrayList.add(csvDto);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logging.error("Zeile fehlerhaft: '" + Arrays.toString(objectArray) + "'", numberFormatException);
                    }
                }
            }
            catch (CsvException csvException) {
                throw new IOException(csvException);
            }
        }
        return arrayList;
    }

    private CsvDto getDtoFuerZeile(String[] stringArray) {
        String string;
        String string2;
        CsvDto csvDto = new CsvDto();
        String string3 = stringArray[this.spalteKeplerName];
        csvDto.setPlanetName(string3);
        csvDto.setSternName(string3.substring(0, string3.length() - 2));
        String string4 = stringArray[this.spalteKic];
        if (Check.isFilled(string4)) {
            string2 = string3.substring(string3.length() - 1, string3.length());
            csvDto.getWeiterePlanetennamen().add("KIC " + string4 + " " + string2);
            csvDto.getWeitereSternnamen().add("KIC " + string4);
        }
        if (Check.isFilled(string2 = stringArray[this.spalteKoi])) {
            double d = Double.parseDouble(string2.substring(1));
            String string5 = "" + d;
            if (string5.indexOf(46) == string5.length() - 2) {
                string5 = string5 + "0";
            }
            csvDto.getWeiterePlanetennamen().add("KOI-" + string5);
            csvDto.getWeitereSternnamen().add("KOI-" + (int)d);
        }
        if (Check.isFilled(string = stringArray[this.spalteAlternateName]) && !string3.equals(string)) {
            csvDto.getWeiterePlanetennamen().add(string);
            if (Pattern.matches(".* (b|c|d|e|f|g|h|i)", string)) {
                csvDto.getWeitereSternnamen().add(string.substring(0, string.length() - 2));
            } else if (string.startsWith("KOI-")) {
                csvDto.getWeitereSternnamen().add(string.substring(0, string.length() - 3));
            } else {
                this.logging.warn("aus planeten name " + string + " konnte kein sternname ermittelt werden");
            }
        }
        return csvDto;
    }

    private void erkenneSpaltenaufbau(String[] stringArray) {
        int n = 0;
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            String string;
            switch (string = stringArray2[i]) {
                case "kepid": {
                    this.spalteKic = n;
                    break;
                }
                case "koi_name": {
                    this.spalteKoi = n;
                    break;
                }
                case "kepler_name": {
                    this.spalteKeplerName = n;
                    break;
                }
                case "pl_name": {
                    this.spalteAlternateName = n;
                    break;
                }
            }
            ++n;
        }
        this.validateFileHeader();
    }

    private void validateFileHeader() {
        if (this.spalteKic == -1) {
            throw new FileHeaderNotCompleteException("column for star KIC id not found");
        }
        if (this.spalteKoi == -1) {
            throw new FileHeaderNotCompleteException("column for planet KOI id not found");
        }
        if (this.spalteKeplerName == -1) {
            throw new FileHeaderNotCompleteException("column for planet kepler name not found");
        }
        if (this.spalteAlternateName == -1) {
            throw new FileHeaderNotCompleteException("column for planet alternative name not found");
        }
    }
}

