/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvException;
import de.planetensuche.core.Check;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.base.CsvZuDtoKonverterStrategie;
import de.planetensuche.datenbank.importierer.csv.base.EntdeckungsmethodenParserStrategie;
import de.planetensuche.datenbank.importierer.csv.base.FileHeaderNotCompleteException;
import de.planetensuche.datenbank.importierer.csv.nasa.NasaEntdeckerParser;
import de.planetensuche.datenbank.importierer.csv.nasa.NasaEntdeckungsmethodenParser;
import de.planetensuche.datenbank.importierer.csv.nasa.NasaExoplanetProjectParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class NasaMainTableCsvZuDtoKonverter
implements CsvZuDtoKonverterStrategie {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private int spaltePlanetName = -1;
    private int spaltePlanetBuchstabe = -1;
    private int spaltePlanetEntdeckungsmethode = -1;
    private int spaltePlanetStatus = -1;
    private int spaltePlanetUmlaufszeit = -1;
    private int spaltePlanetEntfernung = -1;
    private int spaltePlanetExzentrizitaet = -1;
    private int spaltePlanetMasse = -1;
    private int spaltePlanetRadius = -1;
    private int spaltePlanetTemperatur = -1;
    private int spaltePlanetEntdeckungsjahr = -1;
    private int spaltePlanetEntdecker = -1;
    private int spaltePlanetStandort = -1;
    private int spaltePlanetTeleskope = -1;
    private int spaltePlanetInstrument = -1;
    private int spalteSternname = -1;
    private int spalteSternRa = -1;
    private int spalteSternDecl = -1;
    private int spalteSternEntfernung = -1;
    private int spalteSternVmag = -1;
    private int spalteSternTemperatur = -1;
    private int spalteSternMasse = -1;
    private int spalteSternRadius = -1;
    private int spalteSternHd = -1;
    private int spalteSternHip = -1;
    private int spalteSternTic = -1;
    private int spalteSternGaiaDr2 = -1;
    private int spalteSternGaiaDr3 = -1;
    private int spalteSternRadialgeschwindigkeit = -1;
    private int spalteSternSptyp = -1;
    private int spalteSternMetallizitaet = -1;
    private int spalteSternBmag = -1;
    private int spalteSternAlter = -1;
    private int spalteAnzahlSterneImSystem = -1;

    @Override
    public List<CsvDto> leseDtos(File file) throws IOException {
        ArrayList<CsvDto> arrayList = new ArrayList<CsvDto>();
        NasaEntdeckungsmethodenParser nasaEntdeckungsmethodenParser = new NasaEntdeckungsmethodenParser();
        NasaEntdeckerParser nasaEntdeckerParser = new NasaEntdeckerParser();
        NasaExoplanetProjectParser nasaExoplanetProjectParser = new NasaExoplanetProjectParser();
        CSVParser cSVParser = new CSVParserBuilder().withSeparator(',').build();
        try (CSVReader cSVReader = new CSVReaderBuilder(new FileReader(file)).withCSVParser(cSVParser).build();){
            try {
                List<String[]> list = cSVReader.readAll();
                for (Object[] objectArray : list) {
                    try {
                        String string = objectArray[0];
                        if (string.startsWith("hostname")) {
                            this.erkenneSpaltenaufbau((String[])objectArray);
                            continue;
                        }
                        CsvDto csvDto = this.getDtoFuerZeile((String[])objectArray, nasaEntdeckungsmethodenParser, nasaEntdeckerParser, nasaExoplanetProjectParser);
                        arrayList.add(csvDto);
                    }
                    catch (RuntimeException runtimeException) {
                        this.logger.error("Zeile fehlerhaft: '" + Arrays.toString(objectArray) + "'", runtimeException);
                    }
                }
            }
            catch (CsvException csvException) {
                throw new IOException(csvException);
            }
        }
        return arrayList;
    }

    private CsvDto getDtoFuerZeile(String[] stringArray, EntdeckungsmethodenParserStrategie entdeckungsmethodenParserStrategie, NasaEntdeckerParser nasaEntdeckerParser, NasaExoplanetProjectParser nasaExoplanetProjectParser) {
        String string;
        String string2;
        String string3;
        String string4;
        CsvDto csvDto = new CsvDto();
        String string5 = stringArray[this.spalteSternname];
        String string6 = stringArray[this.spaltePlanetBuchstabe];
        String string7 = stringArray[this.spaltePlanetName];
        if (!(string5.endsWith(" A") || string5.endsWith(" B") || string5.endsWith(" C"))) {
            csvDto.setPlanetName(string5 + " " + string6);
        } else {
            csvDto.setPlanetName(string7);
        }
        if (!csvDto.getPlanetName().equals(string7)) {
            csvDto.getWeiterePlanetennamen().add(string7);
        }
        String string8 = entdeckungsmethodenParserStrategie.parseEntdeckungsmethode(stringArray[this.spaltePlanetEntdeckungsmethode]);
        csvDto.setPlanetEntdeckungsmethode(string8);
        int n = Integer.parseInt(stringArray[this.spaltePlanetStatus]);
        csvDto.setPlanetEntdeckungBestaetigt(n == 0);
        csvDto.setPlanetUmlaufszeit(this.getZahl(stringArray[this.spaltePlanetUmlaufszeit]));
        csvDto.setPlanetGrosseHalbachse(this.getZahl(stringArray[this.spaltePlanetEntfernung]));
        csvDto.setPlanetExzentrizitaet(this.getZahl(stringArray[this.spaltePlanetExzentrizitaet]));
        csvDto.setPlanetMasse(this.getZahl(stringArray[this.spaltePlanetMasse]));
        csvDto.setPlanetRadius(this.getZahl(stringArray[this.spaltePlanetRadius]));
        csvDto.setPlanetTemperatur(this.getZahl(stringArray[this.spaltePlanetTemperatur]));
        csvDto.setPlanetEntdeckungsjahr(stringArray[this.spaltePlanetEntdeckungsjahr]);
        csvDto.setPlanetEntdecker(nasaEntdeckerParser.getLastNames(stringArray[this.spaltePlanetEntdecker]));
        if (csvDto.getPlanetEntdecker() == null) {
            csvDto.setPlanetEntdecker(new HashSet<String>());
        }
        csvDto.getPlanetEntdecker().addAll(nasaExoplanetProjectParser.parseDiscovererProject(stringArray[this.spaltePlanetStandort], stringArray[this.spaltePlanetTeleskope], stringArray[this.spaltePlanetInstrument], csvDto));
        csvDto.setSternName(string5);
        csvDto.setSternRa(stringArray[this.spalteSternRa]);
        csvDto.setSternDecl(stringArray[this.spalteSternDecl]);
        csvDto.setSternEntfernungInPc(this.getZahl(stringArray[this.spalteSternEntfernung]));
        csvDto.setSternSh(this.getZahl(stringArray[this.spalteSternVmag]));
        csvDto.setSternTemperatur(this.getZahl(stringArray[this.spalteSternTemperatur]));
        csvDto.setSternMasse(this.getZahl(stringArray[this.spalteSternMasse]));
        csvDto.setSternRadius(this.getZahl(stringArray[this.spalteSternRadius]));
        String string9 = stringArray[this.spalteSternHd];
        if (Check.isFilled(string9)) {
            csvDto.getWeitereSternnamen().add(string9);
            csvDto.getWeiterePlanetennamen().add(string9 + " " + string6);
        }
        if (Check.isFilled(string4 = stringArray[this.spalteSternHip])) {
            csvDto.getWeitereSternnamen().add(string4);
            csvDto.getWeiterePlanetennamen().add(string4 + " " + string6);
        }
        if (Check.isFilled(string3 = stringArray[this.spalteSternTic])) {
            csvDto.getWeitereSternnamen().add(string3);
        }
        if (Check.isFilled(string2 = stringArray[this.spalteSternGaiaDr2])) {
            csvDto.getWeitereSternnamen().add(string2);
        }
        if (Check.isFilled(string = stringArray[this.spalteSternGaiaDr3])) {
            csvDto.getWeitereSternnamen().add(string);
        }
        csvDto.setSternRadialgeschwindigkeit(this.getZahl(stringArray[this.spalteSternRadialgeschwindigkeit]));
        csvDto.setSternSptyp(stringArray[this.spalteSternSptyp]);
        csvDto.setSternMetallizitaet(this.getZahl(stringArray[this.spalteSternMetallizitaet]));
        Double d = this.getZahl(stringArray[this.spalteSternBmag]);
        if (d != null && csvDto.getSternSh() != null) {
            csvDto.setSternBv(d - csvDto.getSternSh());
        }
        Double d2 = this.getZahl(stringArray[this.spalteSternAlter]);
        csvDto.setSternAlter(d2);
        csvDto.setNumberOfStarsInSystem(Integer.valueOf(stringArray[this.spalteAnzahlSterneImSystem]));
        return csvDto;
    }

    private Double getZahl(String string) {
        String string2 = string.trim();
        if (!string2.isEmpty()) {
            return Double.valueOf(string2);
        }
        return null;
    }

    private boolean setzteSpaltenFuerPlanet(String string, int n) {
        switch (string) {
            case "pl_name": {
                this.spaltePlanetName = n;
                break;
            }
            case "pl_letter": {
                this.spaltePlanetBuchstabe = n;
                break;
            }
            case "discoverymethod": {
                this.spaltePlanetEntdeckungsmethode = n;
                break;
            }
            case "pl_controv_flag": {
                this.spaltePlanetStatus = n;
                break;
            }
            case "pl_orbper": {
                this.spaltePlanetUmlaufszeit = n;
                break;
            }
            case "pl_orbsmax": {
                this.spaltePlanetEntfernung = n;
                break;
            }
            case "pl_orbeccen": {
                this.spaltePlanetExzentrizitaet = n;
                break;
            }
            case "pl_massj": 
            case "pl_bmassj": {
                this.spaltePlanetMasse = n;
                break;
            }
            case "pl_radj": {
                this.spaltePlanetRadius = n;
                break;
            }
            case "pl_eqt": {
                this.spaltePlanetTemperatur = n;
                break;
            }
            case "disc_year": {
                this.spaltePlanetEntdeckungsjahr = n;
                break;
            }
            case "disc_refname": {
                this.spaltePlanetEntdecker = n;
                break;
            }
            case "disc_facility": {
                this.spaltePlanetStandort = n;
                break;
            }
            case "disc_telescope": {
                this.spaltePlanetTeleskope = n;
                break;
            }
            case "disc_instrument": {
                this.spaltePlanetInstrument = n;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void erkenneSpaltenaufbau(String[] stringArray) {
        int n = 0;
        for (String string : stringArray) {
            if (!this.setzteSpaltenFuerPlanet(string, n)) {
                this.setzteSpaltenFuerStern(string, n);
            }
            ++n;
        }
        this.validateFileHeader();
    }

    private void setzteSpaltenFuerStern(String string, int n) {
        switch (string) {
            case "hostname": {
                this.spalteSternname = n;
                break;
            }
            case "ra": {
                this.spalteSternRa = n;
                break;
            }
            case "dec": {
                this.spalteSternDecl = n;
                break;
            }
            case "sy_dist": {
                this.spalteSternEntfernung = n;
                break;
            }
            case "sy_vmag": {
                this.spalteSternVmag = n;
                break;
            }
            case "st_teff": {
                this.spalteSternTemperatur = n;
                break;
            }
            case "st_mass": {
                this.spalteSternMasse = n;
                break;
            }
            case "st_rad": {
                this.spalteSternRadius = n;
                break;
            }
            case "hd_name": {
                this.spalteSternHd = n;
                break;
            }
            case "hip_name": {
                this.spalteSternHip = n;
                break;
            }
            case "tic_id": {
                this.spalteSternTic = n;
                break;
            }
            case "gaia_dr2_id": {
                this.spalteSternGaiaDr2 = n;
                break;
            }
            case "gaia_dr3_id": {
                this.spalteSternGaiaDr3 = n;
                break;
            }
            case "st_radv": {
                this.spalteSternRadialgeschwindigkeit = n;
                break;
            }
            case "st_spectype": {
                this.spalteSternSptyp = n;
                break;
            }
            case "st_met": {
                this.spalteSternMetallizitaet = n;
                break;
            }
            case "sy_bmag": {
                this.spalteSternBmag = n;
                break;
            }
            case "st_age": {
                this.spalteSternAlter = n;
                break;
            }
            case "sy_snum": {
                this.spalteAnzahlSterneImSystem = n;
                break;
            }
        }
    }

    private void validateFileHeader() {
        if (this.spalteSternname == -1) {
            throw new FileHeaderNotCompleteException("column for star name not found");
        }
        if (this.spaltePlanetName == -1) {
            throw new FileHeaderNotCompleteException("column for planet name not found");
        }
        if (this.spaltePlanetBuchstabe == -1) {
            throw new FileHeaderNotCompleteException("column for planet letter not found");
        }
        if (this.spaltePlanetEntdeckungsmethode == -1) {
            throw new FileHeaderNotCompleteException("column for planet discovery method not found");
        }
        if (this.spaltePlanetStatus == -1) {
            throw new FileHeaderNotCompleteException("column for planet discovery status not found");
        }
        if (this.spaltePlanetUmlaufszeit == -1) {
            throw new FileHeaderNotCompleteException("column for planet orbit period not found");
        }
        if (this.spaltePlanetEntfernung == -1) {
            throw new FileHeaderNotCompleteException("column for planet distance not found");
        }
        if (this.spaltePlanetExzentrizitaet == -1) {
            throw new FileHeaderNotCompleteException("column for planet excentricity not found");
        }
        if (this.spaltePlanetMasse == -1) {
            throw new FileHeaderNotCompleteException("column for planet mass not found");
        }
        if (this.spaltePlanetRadius == -1) {
            throw new FileHeaderNotCompleteException("column for planet radius not found");
        }
        if (this.spalteSternRa == -1) {
            throw new FileHeaderNotCompleteException("column for star RA not found");
        }
        if (this.spalteSternDecl == -1) {
            throw new FileHeaderNotCompleteException("column for star DECL not found");
        }
        if (this.spalteSternEntfernung == -1) {
            throw new FileHeaderNotCompleteException("column for star distance not found");
        }
        if (this.spalteSternVmag == -1) {
            throw new FileHeaderNotCompleteException("column for star visual mag not found");
        }
        if (this.spalteSternTemperatur == -1) {
            throw new FileHeaderNotCompleteException("column for star temperature not found");
        }
        if (this.spalteSternMasse == -1) {
            throw new FileHeaderNotCompleteException("column for star mass not found");
        }
        if (this.spalteSternRadius == -1) {
            throw new FileHeaderNotCompleteException("column for star radius not found");
        }
        if (this.spalteSternAlter == -1) {
            throw new FileHeaderNotCompleteException("column for star age not found");
        }
        if (this.spalteSternHd == -1) {
            throw new FileHeaderNotCompleteException("column for star HD id not found");
        }
        if (this.spalteSternHip == -1) {
            throw new FileHeaderNotCompleteException("column for star HIP id not found");
        }
        if (this.spalteSternTic == -1) {
            throw new FileHeaderNotCompleteException("column for star TIC id not found");
        }
        if (this.spalteSternGaiaDr2 == -1) {
            throw new FileHeaderNotCompleteException("column for star Gaia DR2 id not found");
        }
        if (this.spalteSternGaiaDr3 == -1) {
            throw new FileHeaderNotCompleteException("column for star Gaia DR3 id not found");
        }
        if (this.spalteSternRadialgeschwindigkeit == -1) {
            throw new FileHeaderNotCompleteException("column for star RV not found");
        }
        if (this.spalteSternSptyp == -1) {
            throw new FileHeaderNotCompleteException("column for star sptype not found");
        }
        if (this.spalteSternMetallizitaet == -1) {
            throw new FileHeaderNotCompleteException("column for star metalicity not found");
        }
        if (this.spalteSternBmag == -1) {
            throw new FileHeaderNotCompleteException("column for star B-mag not found");
        }
        if (this.spaltePlanetTemperatur == -1) {
            throw new FileHeaderNotCompleteException("column for planet sureface temperature not found");
        }
        if (this.spaltePlanetEntdeckungsjahr == -1) {
            throw new FileHeaderNotCompleteException("column for planet discovery year not found");
        }
        if (this.spaltePlanetEntdecker == -1) {
            throw new FileHeaderNotCompleteException("column for planet discoverer/team not found");
        }
        if (this.spaltePlanetStandort == -1) {
            throw new FileHeaderNotCompleteException("column for planet discovery facility not found");
        }
        if (this.spaltePlanetTeleskope == -1) {
            throw new FileHeaderNotCompleteException("column for planet discovery telescope not found");
        }
        if (this.spaltePlanetInstrument == -1) {
            throw new FileHeaderNotCompleteException("column for planet discovery instrument not found");
        }
    }
}

