/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.kataloge.KnownCatalogDetectorService;
import java.util.Arrays;
import java.util.List;

public class ToiCommentPlanetNameParser {
    private final List<String> planetChars = Arrays.asList(" b", " c", " d", " e", " f", " g", " h", " i");
    private final List<String> planetNumbers = Arrays.asList(".01", ".02", ".03", ".04", ".05", ".06", ".07", ".08");
    private final KnownCatalogDetectorService katalogerkenner;

    public ToiCommentPlanetNameParser(KnownCatalogDetectorService knownCatalogDetectorService) {
        this.katalogerkenner = knownCatalogDetectorService;
    }

    public void parseAdditionalNamesFromComments(CsvDto csvDto) {
        String[] stringArray = csvDto.getNotiz().contains(" / ") ? csvDto.getNotiz().split(" / ") : (csvDto.getNotiz().contains(";") ? csvDto.getNotiz().split(";") : new String[]{csvDto.getNotiz()});
        for (String string : stringArray) {
            String string2 = string.trim();
            if (!this.isPlanetChar(string2) || !this.katalogerkenner.isKnownCatalog(string2)) continue;
            csvDto.getWeiterePlanetennamen().add(string2);
            int n = -1;
            for (int i = string2.length() - 1; i > 0; --i) {
                if (string2.charAt(i) != ' ' && string2.charAt(i) != '.') continue;
                n = i;
                break;
            }
            if (n <= 1) continue;
            csvDto.getWeitereSternnamen().add(string2.substring(0, n));
        }
    }

    private boolean isPlanetChar(String string) {
        for (String string2 : this.planetChars) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        for (String string2 : this.planetNumbers) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

