/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.nasa;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvException;
import de.planetensuche.core.Check;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.base.CsvZuDtoKonverterStrategie;
import de.planetensuche.datenbank.importierer.csv.base.FileHeaderNotCompleteException;
import de.planetensuche.datenbank.importierer.csv.nasa.ExofopPlanetStatus;
import de.planetensuche.datenbank.importierer.csv.nasa.ToiCommentPlanetNameParser;
import de.planetensuche.datenbank.kataloge.KnownCatalogDetectorService;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class ToiCsvZuDtoKonverter
implements CsvZuDtoKonverterStrategie {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final ToiCommentPlanetNameParser toiCommentPlanetNameParser;
    private int spalteSternTicName = -1;
    private int spalteSternRa = -1;
    private int spalteSternDecl = -1;
    private int spalteSternEntfernung = -1;
    private int spalteSternTemperatur = -1;
    private int spalteSternRadius = -1;
    private int spalteSternMasse = -1;
    private int spalteSternMetal = -1;
    private int spaltePlanetRadius = -1;
    private int spaltePlanetUmlaufszeit = -1;
    private int spaltePlanetUmlaufszeitError = -1;
    private int spaltePlanetTemperatur = -1;
    private int spaltePlanetEntdeckungsdatum = -1;
    private int spaltePlanetStatusTess = -1;
    private int spaltePlanetStatusExofop = -1;
    private int spaltePlanetTransitEpoch = -1;
    private int spaltePlanetTransitEpochError = -1;
    private int spalteWeitereNamen = -1;
    private int spalteNotiz = -1;

    public ToiCsvZuDtoKonverter(KnownCatalogDetectorService knownCatalogDetectorService) {
        this.toiCommentPlanetNameParser = new ToiCommentPlanetNameParser(knownCatalogDetectorService);
    }

    @Override
    public List<CsvDto> leseDtos(File file) throws IOException {
        ArrayList<CsvDto> arrayList = new ArrayList<CsvDto>();
        CSVParser cSVParser = new CSVParserBuilder().withSeparator(',').build();
        try (CSVReader cSVReader = new CSVReaderBuilder(new FileReader(file)).withCSVParser(cSVParser).build();){
            try {
                List<String[]> list = cSVReader.readAll();
                this.logging.info(list.size() + " lines parsed from csv file");
                for (Object[] objectArray : list) {
                    try {
                        String string = objectArray[0];
                        if (string.startsWith("TIC ID")) {
                            this.erkenneSpaltenaufbau((String[])objectArray);
                            continue;
                        }
                        ExofopPlanetStatus exofopPlanetStatus = ExofopPlanetStatus.parse((String)objectArray[this.spaltePlanetStatusExofop]);
                        ExofopPlanetStatus exofopPlanetStatus2 = ExofopPlanetStatus.parse((String)objectArray[this.spaltePlanetStatusTess]);
                        CsvDto csvDto = this.getDtoFuerZeile((String[])objectArray, exofopPlanetStatus.isUnknown() ? exofopPlanetStatus2 : exofopPlanetStatus);
                        arrayList.add(csvDto);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logging.error("Zeile fehlerhaft: '" + Arrays.toString(objectArray) + "'", numberFormatException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.logging.warn("Zeile fehlerhaft: Exofop Status '" + (String)objectArray[this.spaltePlanetStatusExofop] + "', Tess Status '" + (String)objectArray[this.spaltePlanetStatusTess] + "' f\u00fcr TIC " + (String)objectArray[0], illegalArgumentException);
                    }
                }
            }
            catch (CsvException csvException) {
                throw new IOException(csvException);
            }
        }
        return arrayList;
    }

    private CsvDto getDtoFuerZeile(String[] stringArray, ExofopPlanetStatus exofopPlanetStatus) {
        double d;
        CsvDto csvDto = new CsvDto();
        csvDto.setSternName("TIC " + stringArray[this.spalteSternTicName]);
        String string = stringArray[this.spalteWeitereNamen];
        if (Check.isFilled(string)) {
            csvDto.getWeiterePlanetennamen().add("TOI-" + string);
            csvDto.getWeitereSternnamen().add("TOI-" + string.substring(0, string.length() - 3));
            csvDto.setPlanetName(csvDto.getSternName() + string.substring(string.length() - 3, string.length()));
        }
        csvDto.setSternRa(stringArray[this.spalteSternRa]);
        csvDto.setSternDecl(stringArray[this.spalteSternDecl]);
        if (Check.isFilled(stringArray[this.spalteSternEntfernung]) && (d = Double.parseDouble(stringArray[this.spalteSternEntfernung])) > 0.0) {
            csvDto.setSternEntfernungInPc(d);
        }
        if (Check.isFilled(stringArray[this.spalteSternTemperatur]) && (d = Double.parseDouble(stringArray[this.spalteSternTemperatur])) > 0.0) {
            csvDto.setSternTemperatur(d);
        }
        if (Check.isFilled(stringArray[this.spalteSternRadius]) && (d = Double.parseDouble(stringArray[this.spalteSternRadius])) > 0.0) {
            csvDto.setSternRadius(d);
        }
        if (Check.isFilled(stringArray[this.spalteSternMasse]) && (d = Double.parseDouble(stringArray[this.spalteSternMasse])) > 0.0) {
            csvDto.setSternMasse(d);
        }
        if (Check.isFilled(stringArray[this.spalteSternMetal])) {
            csvDto.setSternMetallizitaet(Double.parseDouble(stringArray[this.spalteSternMetal]));
        }
        if (Check.isFilled(stringArray[this.spaltePlanetTransitEpoch])) {
            csvDto.setPlanetTransitBjd(Double.parseDouble(stringArray[this.spaltePlanetTransitEpoch]));
        }
        if (Check.isFilled(stringArray[this.spaltePlanetTransitEpochError])) {
            csvDto.setPlanetTransitBjdError(Double.parseDouble(stringArray[this.spaltePlanetTransitEpochError]));
        }
        if (Check.isFilled(stringArray[this.spaltePlanetUmlaufszeit]) && (d = Double.parseDouble(stringArray[this.spaltePlanetUmlaufszeit])) > 0.0) {
            csvDto.setPlanetUmlaufszeit(d);
        }
        if (Check.isFilled(stringArray[this.spaltePlanetUmlaufszeitError])) {
            csvDto.setPlanetUmlaufszeitError(Double.parseDouble(stringArray[this.spaltePlanetUmlaufszeitError]));
        }
        if (Check.isFilled(stringArray[this.spaltePlanetRadius]) && (d = Double.parseDouble(stringArray[this.spaltePlanetRadius])) > 0.0) {
            csvDto.setPlanetRadius(d * 0.0892);
        }
        if (Check.isFilled(stringArray[this.spaltePlanetTemperatur])) {
            csvDto.setPlanetTemperatur(Double.parseDouble(stringArray[this.spaltePlanetTemperatur]));
        }
        csvDto.setPlanetEntdeckungsjahr(stringArray[this.spaltePlanetEntdeckungsdatum].substring(0, 4));
        csvDto.setPlanetEntdeckungBestaetigt(exofopPlanetStatus.isConfirmedPlanet());
        if (ExofopPlanetStatus.ECLIPSING_BINARY.getExofopKuerzel().equals(stringArray[this.spaltePlanetStatusTess])) {
            csvDto.setPlanetExofopDisposition(stringArray[this.spaltePlanetStatusTess]);
        } else if (Check.isEmpty(stringArray[this.spaltePlanetStatusExofop])) {
            csvDto.setPlanetExofopDisposition(stringArray[this.spaltePlanetStatusTess]);
        } else {
            csvDto.setPlanetExofopDisposition(stringArray[this.spaltePlanetStatusExofop]);
        }
        if (!exofopPlanetStatus.isKnownPlanet()) {
            csvDto.setPlanetEntdeckungsmethode("Transit-Suchmethode");
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (!exofopPlanetStatus.isKnownPlanet()) {
            hashSet.add(EntdeckerWeltraumteleskope.TESS.getNameInDatabase());
        }
        csvDto.setPlanetEntdecker(hashSet);
        if (Check.isFilled(stringArray[this.spalteNotiz])) {
            this.processCommentsField(csvDto, stringArray);
        }
        csvDto.setExofopEntryCreated(Timestamp.valueOf(stringArray[this.spaltePlanetEntdeckungsdatum] + " 00:00:00"));
        return csvDto;
    }

    private void processCommentsField(CsvDto csvDto, String[] stringArray) {
        csvDto.setNotiz(stringArray[this.spalteNotiz]);
        this.parseDiscovererFromComments(csvDto);
        this.toiCommentPlanetNameParser.parseAdditionalNamesFromComments(csvDto);
    }

    private void parseDiscovererFromComments(CsvDto csvDto) {
        if (csvDto.getNotiz().contains("PHT ") || csvDto.getNotiz().contains(" PHT") || csvDto.getNotiz().toLowerCase().contains("planet hunters tess") || csvDto.getNotiz().contains("Planethunters-TESS")) {
            csvDto.getPlanetEntdecker().add("Eisner");
            csvDto.getPlanetEntdecker().add(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase());
        }
    }

    private void erkenneSpaltenaufbau(String[] stringArray) {
        int n = 0;
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            String string;
            switch (string = stringArray2[i]) {
                case "TIC ID": {
                    this.spalteSternTicName = n;
                    break;
                }
                case "TOI": {
                    this.spalteWeitereNamen = n;
                    break;
                }
                case "RA": {
                    this.spalteSternRa = n;
                    break;
                }
                case "Dec": {
                    this.spalteSternDecl = n;
                    break;
                }
                case "Epoch (BJD)": {
                    this.spaltePlanetTransitEpoch = n;
                    break;
                }
                case "Epoch (BJD) err": {
                    this.spaltePlanetTransitEpochError = n;
                    break;
                }
                case "Period (days)": {
                    this.spaltePlanetUmlaufszeit = n;
                    break;
                }
                case "Period (days) err": {
                    this.spaltePlanetUmlaufszeitError = n;
                    break;
                }
                case "Planet Radius (R_Earth)": {
                    this.spaltePlanetRadius = n;
                    break;
                }
                case "Planet Equil Temp (K)": {
                    this.spaltePlanetTemperatur = n;
                    break;
                }
                case "TFOPWG Disposition": {
                    this.spaltePlanetStatusExofop = n;
                    break;
                }
                case "TESS Disposition": {
                    this.spaltePlanetStatusTess = n;
                    break;
                }
                case "Stellar Distance (pc)": {
                    this.spalteSternEntfernung = n;
                    break;
                }
                case "Stellar Eff Temp (K)": {
                    this.spalteSternTemperatur = n;
                    break;
                }
                case "Stellar Radius (R_Sun)": {
                    this.spalteSternRadius = n;
                    break;
                }
                case "Stellar Mass (M_Sun)": {
                    this.spalteSternMasse = n;
                    break;
                }
                case "Stellar Metallicity": {
                    this.spalteSternMetal = n;
                    break;
                }
                case "Date TOI Alerted (UTC)": {
                    this.spaltePlanetEntdeckungsdatum = n;
                    break;
                }
                case "Comments": {
                    this.spalteNotiz = n;
                    break;
                }
            }
            ++n;
        }
        this.validateFileHeader();
    }

    private void validateFileHeader() {
        if (this.spalteSternTicName == -1) {
            throw new FileHeaderNotCompleteException("column for star TIC id not found");
        }
    }
}

