/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.csv.paris;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvException;
import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.base.CsvZuDtoKonverterStrategie;
import de.planetensuche.datenbank.importierer.csv.base.EntdeckungsmethodenParserStrategie;
import de.planetensuche.datenbank.importierer.csv.paris.ParisExoplanetEntdeckungsmethodenParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ParisExoplanetCsvZuDtoKonverter
implements CsvZuDtoKonverterStrategie {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private int planetName = -1;
    private int planetMasse = -1;
    private int planetRadius = -1;
    private int planetUmlaufszeit = -1;
    private int planetEntfernung = -1;
    private int planetExzentrizitaet = -1;
    private int planetEntdeckungsjahr = -1;
    private int planetEntdeckungsmethode = -1;
    private int sternName = -1;
    private int sternRa = -1;
    private int sternDecl = -1;
    private int sternVmag = -1;
    private int sternEntfernung = -1;
    private int sternMetallizitaet = -1;
    private int sternMasse = -1;
    private int sternRadius = -1;
    private int sternSptyp = -1;
    private int sternAlter = -1;
    private int sternTemperatur = -1;

    @Override
    public List<CsvDto> leseDtos(File file) throws IOException {
        ArrayList<CsvDto> arrayList = new ArrayList<CsvDto>();
        ParisExoplanetEntdeckungsmethodenParser parisExoplanetEntdeckungsmethodenParser = new ParisExoplanetEntdeckungsmethodenParser();
        CSVParser cSVParser = new CSVParserBuilder().withSeparator(',').build();
        try (CSVReader cSVReader = new CSVReaderBuilder(new FileReader(file)).withCSVParser(cSVParser).build();){
            try {
                List<String[]> list = cSVReader.readAll();
                for (Object[] objectArray : list) {
                    if (objectArray.length < 30) {
                        this.logging.warn("Anzahl Spalten zu kurz (" + objectArray.length + ")");
                        throw new UnsupportedOperationException("file format changed?");
                    }
                    try {
                        if ("# name".equals(objectArray[0])) {
                            this.erkenneSpaltenaufbau((String[])objectArray);
                            continue;
                        }
                        CsvDto csvDto = this.getDtoFuerZeile((String[])objectArray, parisExoplanetEntdeckungsmethodenParser);
                        arrayList.add(csvDto);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logging.error("Zeile fehlerhaft: '" + Arrays.toString(objectArray) + "'", numberFormatException);
                    }
                }
            }
            catch (CsvException csvException) {
                throw new IOException(csvException);
            }
        }
        return arrayList;
    }

    private void erkenneSpaltenaufbau(String[] stringArray) {
        int n = 0;
        for (String string : stringArray) {
            if (!this.setzteSpaltenFuerPlanet(string.trim(), n)) {
                this.setzteSpaltenFuerStern(string.trim(), n);
            }
            ++n;
        }
        this.pruefeObAllePlanetenSpaltenErkanntWurden();
        this.pruefeObAlleSternSpaltenErkanntWurden();
    }

    private void pruefeObAllePlanetenSpaltenErkanntWurden() {
        if (this.planetEntdeckungsjahr == -1) {
            this.logAndThrowError("Entdeckungsjahr");
        }
        if (this.planetEntdeckungsmethode == -1) {
            this.logAndThrowError("Entdeckungsmethode");
        }
        if (this.planetEntfernung == -1) {
            this.logAndThrowError("Bahnabstand");
        }
        if (this.planetExzentrizitaet == -1) {
            this.logAndThrowError("Exzentrizit\u00e4t");
        }
        if (this.planetMasse == -1) {
            this.logAndThrowError("Planeten-Masse");
        }
        if (this.planetName == -1) {
            this.logAndThrowError("Planetenname");
        }
        if (this.planetRadius == -1) {
            this.logAndThrowError("Planeten-Radius");
        }
        if (this.planetUmlaufszeit == -1) {
            this.logAndThrowError("Umlaufszeit");
        }
    }

    private void logAndThrowError(String string) {
        this.logging.warn(string + " wurde nicht in der Datei gefunden");
        throw new UnsupportedOperationException("file format changed?");
    }

    private CsvDto getDtoFuerZeile(String[] stringArray, EntdeckungsmethodenParserStrategie entdeckungsmethodenParserStrategie) {
        CsvDto csvDto = new CsvDto();
        csvDto.setPlanetName(stringArray[this.planetName].trim());
        csvDto.setPlanetMasse(this.getZahl(stringArray[this.planetMasse]));
        csvDto.setPlanetRadius(this.getZahl(stringArray[this.planetRadius]));
        csvDto.setPlanetUmlaufszeit(this.getZahl(stringArray[this.planetUmlaufszeit]));
        csvDto.setPlanetGrosseHalbachse(this.getZahl(stringArray[this.planetEntfernung]));
        csvDto.setPlanetExzentrizitaet(this.getZahl(stringArray[this.planetExzentrizitaet]));
        csvDto.setPlanetEntdeckungsjahr(stringArray[this.planetEntdeckungsjahr].trim());
        String string = stringArray[this.planetEntdeckungsmethode].trim();
        if ("controversial".equals(string)) {
            csvDto.setPlanetEntdeckungBestaetigt(false);
        } else {
            csvDto.setPlanetEntdeckungBestaetigt(true);
            String string2 = entdeckungsmethodenParserStrategie.parseEntdeckungsmethode(string);
            csvDto.setPlanetEntdeckungsmethode(string2);
        }
        csvDto.setSternName(stringArray[this.sternName].trim());
        csvDto.setSternRa(stringArray[this.sternRa].trim());
        csvDto.setSternDecl(stringArray[this.sternDecl].trim());
        csvDto.setSternSh(this.getZahl(stringArray[this.sternVmag]));
        csvDto.setSternEntfernungInPc(this.getZahl(stringArray[this.sternEntfernung]));
        csvDto.setSternMetallizitaet(this.getZahl(stringArray[this.sternMetallizitaet]));
        csvDto.setSternMasse(this.getZahl(stringArray[this.sternMasse]));
        csvDto.setSternRadius(this.getZahl(stringArray[this.sternRadius]));
        csvDto.setSternSptyp(stringArray[this.sternSptyp].trim());
        csvDto.setSternAlter(this.getZahl(stringArray[this.sternAlter]));
        csvDto.setSternTemperatur(this.getZahl(stringArray[this.sternTemperatur]));
        return csvDto;
    }

    private Double getZahl(String string) {
        String string2 = string.trim();
        if (!string2.isEmpty()) {
            return Double.parseDouble(string2);
        }
        return null;
    }

    private boolean setzteSpaltenFuerPlanet(String string, int n) {
        switch (string) {
            case "# name": {
                this.planetName = n;
                break;
            }
            case "mass": {
                this.planetMasse = n;
                break;
            }
            case "radius": {
                this.planetRadius = n;
                break;
            }
            case "orbital_period": {
                this.planetUmlaufszeit = n;
                break;
            }
            case "semi_major_axis": {
                this.planetEntfernung = n;
                break;
            }
            case "eccentricity": {
                this.planetExzentrizitaet = n;
                break;
            }
            case "discovered": {
                this.planetEntdeckungsjahr = n;
                break;
            }
            case "detection_type": {
                this.planetEntdeckungsmethode = n;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void setzteSpaltenFuerStern(String string, int n) {
        switch (string) {
            case "star_name": {
                this.sternName = n;
                break;
            }
            case "ra": {
                this.sternRa = n;
                break;
            }
            case "dec": {
                this.sternDecl = n;
                break;
            }
            case "mag_v": {
                this.sternVmag = n;
                break;
            }
            case "star_distance": {
                this.sternEntfernung = n;
                break;
            }
            case "star_metallicity": {
                this.sternMetallizitaet = n;
                break;
            }
            case "star_mass": {
                this.sternMasse = n;
                break;
            }
            case "star_radius": {
                this.sternRadius = n;
                break;
            }
            case "star_sp_type": {
                this.sternSptyp = n;
                break;
            }
            case "star_age": {
                this.sternAlter = n;
                break;
            }
            case "star_teff": {
                this.sternTemperatur = n;
                break;
            }
        }
    }

    private void pruefeObAlleSternSpaltenErkanntWurden() {
        if (this.sternAlter == -1) {
            this.logAndThrowError("Alter");
        }
        if (this.sternDecl == -1) {
            this.logAndThrowError("Decl");
        }
        if (this.sternEntfernung == -1) {
            this.logAndThrowError("Stern-Entfernung");
        }
        if (this.sternMasse == -1) {
            this.logAndThrowError("Sternmasse");
        }
        if (this.sternMetallizitaet == -1) {
            this.logAndThrowError("Metallizit\u00e4t");
        }
        if (this.sternName == -1) {
            this.logAndThrowError("Sternname");
        }
        if (this.sternRa == -1) {
            this.logAndThrowError("Ra");
        }
        if (this.sternRadius == -1) {
            this.logAndThrowError("Stern-Radius");
        }
        if (this.sternSptyp == -1) {
            this.logAndThrowError("Sptyp");
        }
        if (this.sternTemperatur == -1) {
            this.logAndThrowError("Stern-Temperatur");
        }
        if (this.sternVmag == -1) {
            this.logAndThrowError("Vmag");
        }
    }
}

