/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.gaia;

import com.google.inject.Injector;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.GaiaNonSingleStar;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.IPlanetensucheObjektPruefer;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.gaia.doublestar.GaiaAstrometricDto;
import de.planetensuche.datenbank.gaia.doublestar.GaiaDoubleStarIndicatorService;
import de.planetensuche.datenbank.gaia.main.GaiaDataRelease;
import de.planetensuche.datenbank.gaia.main.GaiaStellarDataDto;
import de.planetensuche.datenbank.gaia.main.GaiaStellarDataService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenKlassifiziererService;
import de.planetensuche.datenbankkern.impl.cache.IdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QGaiaStars;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class GaiaDataOnlineImportService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final GaiaDoubleStarIndicatorService gaiaDoubleStarIndicatorService = new GaiaDoubleStarIndicatorService();
    private final GaiaStellarDataService gaiaStellarDataService = new GaiaStellarDataService();
    private final IDatenbankverbinder datenbankverbinder;
    private final IdCacheDAO idCacheDao;
    private final IPlanetensucheObjektRepository planetensucheRepo;
    private final PlanetensucheObjektPrueferDAO psObjectCheckerDao;
    private final ObjektnamenKlassifiziererService objectnameClassifierService;

    public GaiaDataOnlineImportService(Injector injector) {
        this.datenbankverbinder = injector.getInstance(IDatenbankverbinder.class);
        this.idCacheDao = injector.getInstance(IdCacheDAO.class);
        this.planetensucheRepo = injector.getInstance(IPlanetensucheObjektRepository.class);
        this.psObjectCheckerDao = injector.getInstance(PlanetensucheObjektPrueferDAO.class);
        this.objectnameClassifierService = injector.getInstance(ObjektnamenKlassifiziererService.class);
    }

    public int downloadAndSave(int n) {
        this.logger.info("Gaia stellar data download started with limit " + n);
        int n2 = 0;
        try {
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            Integer n3 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(StarObjectType.ECLIPSING_BINARY.getTypeName()))).fetchOne();
            n2 = this.queryDbDownloadDataAndUpdateStars(List.of(n3), n);
            if (n2 < n) {
                n2 += this.queryDbDownloadDataAndUpdateStars(this.idCacheDao.getObjekttypenidsSterne(), n - n2);
            }
            this.logger.info("Gaia stellar data download finished");
            QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
            long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qGaiaStars.count()).from((Expression<?>)qGaiaStars)).fetchCount();
            this.logger.info("overall " + l + " Gaia stellar data stored");
        }
        catch (IOException | RuntimeException | SQLException exception) {
            this.logger.error(exception);
            this.logger.info("Gaia stellar data download terminated, because of " + exception.getMessage());
        }
        return n2;
    }

    private int queryDbDownloadDataAndUpdateStars(List<Integer> list, int n) throws SQLException, NumberFormatException, IOException {
        int n2 = 0;
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qNamen.namen, qDaten.id}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)list).and(qNamen.namen.startsWith("Gaia DR2 ")).and(qDaten.id.notIn((SubQueryExpression<Integer>)SQLExpressions.select(qGaiaStars.datenid).from((Expression<?>)qGaiaStars))))).fetch();
        this.logger.info("found " + list2.size() + " stars with Gaia DR2 id and object type ids " + String.valueOf(list) + ", but without Gaia data");
        int n3 = 0;
        for (Tuple tuple : list2) {
            long l;
            Optional<GaiaStellarDataDto> optional;
            Object object;
            ++n3;
            String string = tuple.get(qNamen.namen);
            if (string == null) {
                this.logger.warn("something is wrong with query result: no gaia DR2 name found");
                continue;
            }
            int n4 = tuple.get(qDaten.id);
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheRepo.read(n4);
            Optional<GaiaAstrometricDto> optional2 = this.gaiaDoubleStarIndicatorService.queryGaia(string);
            if (optional2.isPresent()) {
                object = optional2.get();
                this.logger.debug(((GaiaAstrometricDto)object).toString());
                if (((GaiaAstrometricDto)object).getIsSingleStar() == null) {
                    iPlanetensucheObjekt.setGaiaNonSingle(GaiaNonSingleStar.UNKNOWN);
                } else if (((GaiaAstrometricDto)object).getIsSingleStar().booleanValue()) {
                    iPlanetensucheObjekt.setGaiaNonSingle(GaiaNonSingleStar.SINGLE);
                } else {
                    iPlanetensucheObjekt.setGaiaNonSingle(((GaiaAstrometricDto)object).getNonSingleStarType());
                }
                if (((GaiaAstrometricDto)object).getAstrometricExcessNoiseSignificance() != null) {
                    iPlanetensucheObjekt.setGaiaAstroExNoiseSig(((GaiaAstrometricDto)object).getAstrometricExcessNoiseSignificance());
                }
                if (((GaiaAstrometricDto)object).getRuwe() != null) {
                    iPlanetensucheObjekt.setGaiaRuwe(((GaiaAstrometricDto)object).getRuwe());
                }
                if (((GaiaAstrometricDto)object).getRvErrorInMeterPerSeconds() != null) {
                    iPlanetensucheObjekt.setGaiaRvError(((GaiaAstrometricDto)object).getRvErrorInMeterPerSeconds() / 1000.0);
                }
                if (((GaiaAstrometricDto)object).getRvInMeterPerSeconds() != null && iPlanetensucheObjekt.isGeschwindigkeitUnbekannt()) {
                    iPlanetensucheObjekt.setGeschwindigkeit(((GaiaAstrometricDto)object).getRvInMeterPerSeconds() / 1000.0);
                }
            } else {
                this.logger.warn("unable to download Gaia stellar data for " + string);
                continue;
            }
            if ((iPlanetensucheObjekt.isEntfernungUnbekannt() || iPlanetensucheObjekt.isTemperaturUnbekannt() || iPlanetensucheObjekt.isDurchmesserUnbekannt() || iPlanetensucheObjekt.isMasseUnbekannt()) && (optional = this.gaiaStellarDataService.queryGaia(GaiaDataRelease.DR2, l = Long.parseLong(string.split(" ")[2]))).isPresent()) {
                this.logger.info("additional stellar data downloaded for " + string);
                GaiaStellarDataDto gaiaStellarDataDto = optional.get();
                this.logger.debug(gaiaStellarDataDto.toString());
                if (iPlanetensucheObjekt.isEntfernungUnbekannt() && gaiaStellarDataDto.distanceGspphotInPc() > 0.0) {
                    iPlanetensucheObjekt.setEntfernung(gaiaStellarDataDto.distanceGspphotInPc() * 3.2616);
                }
                if (iPlanetensucheObjekt.isTemperaturUnbekannt()) {
                    double d;
                    double d2 = d = gaiaStellarDataDto.teffGspphot() > 0.0 ? gaiaStellarDataDto.teffGspphot() : gaiaStellarDataDto.teffGspspec();
                    if (d > 0.0) {
                        iPlanetensucheObjekt.setTemperatur(d);
                    }
                }
                if (iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
                    iPlanetensucheObjekt.setDurchmesser(gaiaStellarDataDto.radiusFlame() > 0.0 ? gaiaStellarDataDto.radiusFlame() : gaiaStellarDataDto.radiusGspphot());
                }
                if (iPlanetensucheObjekt.isMasseUnbekannt() && gaiaStellarDataDto.massFlame() > 0.0) {
                    iPlanetensucheObjekt.setMasse(gaiaStellarDataDto.massFlame());
                }
            }
            object = new PlanetensucheObjektPruefer(this.psObjectCheckerDao, iPlanetensucheObjekt);
            ((PlanetensucheObjekt)object).setStamp(new Timestamp(System.currentTimeMillis()));
            this.planetensucheRepo.update((IPlanetensucheObjektPruefer)object, true, this.objectnameClassifierService);
            this.logger.info(string + " updated");
            int n5 = (int)Math.round((double)n3 * 100.0 / (double)list2.size());
            this.logger.info(n5 + "% done (" + n3 + " of " + list2.size() + ")");
            ++n2;
            if (n3 < n) continue;
            this.logger.info("cancel download/import because limit of " + n + " is reached");
            return n2;
        }
        return n2;
    }
}

