/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.helfer;

import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datenbank.api.GrichischesAlphabet;
import de.planetensuche.datenbank.importierer.helfer.MoaKatalogNameCorrector;
import de.planetensuche.datenbank.importierer.helfer.OgleKatalogNameCorrector;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class KorrigiereNamen {
    private final PlanetensucheObjektPrueferDAO dao;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final Map<String, String> objektnamenmapping;
    private final Katalogerkenner katalogerkenner;
    private final OgleKatalogNameCorrector ogleKatalogNameCorrector;
    private final MoaKatalogNameCorrector moaKatalogNameCorrector;

    public KorrigiereNamen(PlanetensucheObjektPrueferDAO planetensucheObjektPrueferDAO, Katalogerkenner katalogerkenner) throws IOException {
        this.dao = planetensucheObjektPrueferDAO;
        this.objektnamenmapping = new HashMap<String, String>();
        this.katalogerkenner = katalogerkenner;
        this.ogleKatalogNameCorrector = new OgleKatalogNameCorrector(this.katalogerkenner);
        this.moaKatalogNameCorrector = new MoaKatalogNameCorrector(this.katalogerkenner);
    }

    private void leseObjektnamenmapping() throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(new File("").getAbsolutePath() + "/conf/objektnamenmapping.conf"));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("=");
                if (stringArray.length != 2) continue;
                this.objektnamenmapping.put(stringArray[0], stringArray[1]);
            }
        }
    }

    public Katalogerkenner getKatalogerkenner() {
        return this.katalogerkenner;
    }

    public String korrigiereNamen(String string) throws IOException {
        Object object;
        block18: {
            if (this.objektnamenmapping.isEmpty()) {
                this.leseObjektnamenmapping();
            }
            object = string.replace("V* ", "").replace("Cl* ", "").replace("Cl ", "").replace("** ", "").replace("* ", "").trim();
            try {
                boolean bl;
                String[] stringArray;
                String string2 = this.objektnamenmapping.get(string);
                if (string2 != null) {
                    return string2;
                }
                object = this.trimEmptySpace((String)object);
                for (String string3 : stringArray = new String[]{"BD+", "BD-", "CD-", "AG+", "AG-", "CPD-", "CPD+", "CP-", "CP+"}) {
                    if (!((String)object).startsWith(string3)) continue;
                    if (((String)object).charAt(string3.length() + 2) == ' ') break;
                    object = this.korrigiereBdUndCdUndAgKatalogNamen((String)object, string3);
                    break;
                }
                boolean bl2 = bl = this.katalogerkenner.isHenryDraperCatalogue((String)object) || this.katalogerkenner.isHarvardCatalogue((String)object) || this.katalogerkenner.isGiclasDwarfKatalog((String)object) || this.katalogerkenner.isHipparcosCatalogue((String)object) || this.katalogerkenner.matchCatalogPattern("SAO", string);
                if (bl || this.katalogerkenner.isExoplanetenProjekt((String)object)) {
                    return object;
                }
                if (((String)object).startsWith("CP-")) {
                    object = "CPD-" + ((String)object).substring(3);
                    break block18;
                }
                if (((String)object).startsWith("NAME ")) {
                    object = KorrigiereNamen.fixSimbadName((String)object);
                    break block18;
                }
                if (((String)object).startsWith("Melotte ")) {
                    object = "Mel " + ((String)object).substring(8);
                    break block18;
                }
                if (((String)object).startsWith("Collinder ")) {
                    object = "Cr " + ((String)object).substring(10);
                    break block18;
                }
                if (((String)object).startsWith("Gliese ")) {
                    object = "Gl " + ((String)object).substring(7);
                    break block18;
                }
                if (((String)object).startsWith("Gj")) {
                    object = "GJ " + ((String)object).substring(3, ((String)object).length());
                    break block18;
                }
                if (((String)object).startsWith("CoRoT-Exo-") || ((String)object).startsWith("CoRoT-Exo ")) {
                    object = "CoRoT-" + ((String)object).substring(10, ((String)object).length());
                    break block18;
                }
                if (((String)object).startsWith("MOA")) {
                    object = this.moaKatalogNameCorrector.fixMoaName((String)object);
                    break block18;
                }
                if (((String)object).startsWith("OGLE")) {
                    object = this.ogleKatalogNameCorrector.fixOgleName((String)object);
                    break block18;
                }
                if ("BD ".startsWith((String)object) || "CD ".startsWith((String)object)) {
                    String string4 = ((String)object).substring(0, 2) + ((String)object).substring(3, ((String)object).length());
                    object = string4;
                } else if ("HAT-P ".startsWith((String)object)) {
                    object = "HAT-P-" + ((String)object).substring(6, ((String)object).length());
                }
                return this.fixBayerFlamsteedName((String)object);
            }
            catch (Exception exception) {
                this.logger.error("korrigiereNamen(" + string + ")", exception);
            }
        }
        return object;
    }

    private static String fixSimbadName(String string) {
        String string2 = string.charAt(5) + string.substring(6).toLowerCase();
        Object[] objectArray = string2.split(" ");
        if (objectArray.length > 1) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i].equalsIgnoreCase("A") || ((String)objectArray[i]).equalsIgnoreCase("B") || ((String)objectArray[i]).equalsIgnoreCase("C") || ((String)objectArray[i]).equalsIgnoreCase("D") || ((String)objectArray[i]).equalsIgnoreCase("AB")) {
                    objectArray[i] = ((String)objectArray[i]).toUpperCase();
                    continue;
                }
                if (((String)objectArray[i]).length() <= 1) continue;
                objectArray[i] = ((String)objectArray[i]).substring(0, 1).toUpperCase() + ((String)objectArray[i]).substring(1);
            }
            return StringUtils.join(objectArray, " ");
        }
        return string2;
    }

    private String fixBayerFlamsteedName(String string) {
        String string2;
        Object object = this.fixBayerName(string);
        String[] stringArray = ((String)object).split(" ");
        StringBuilder stringBuilder = new StringBuilder(stringArray.length);
        for (String string3 : stringArray) {
            if (string3.length() > 1) {
                stringBuilder.append(string3.substring(0, 1).toUpperCase());
                stringBuilder.append(string3.substring(1, string3.length())).append(" ");
                continue;
            }
            stringBuilder.append(string3).append(" ");
        }
        String string4 = stringBuilder.toString().trim();
        if (!string4.equals(string2 = this.korrigiereBayerNamen(string4)) && !string2.isEmpty()) {
            object = string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length());
            this.logger.info("(fehlerhafter) Name '" + (String)string4 + "' in '" + (String)object + "' korrigiert...");
        }
        return object;
    }

    private String fixBayerName(String string) {
        Object object = string;
        if (string.startsWith("gamma 1 Leo")) {
            object = "Gamma01 Leo" + string.substring(11);
        } else if (string.startsWith("alf ")) {
            object = "Alpha " + string.substring(3).trim();
        } else if (string.startsWith("alf01 ") || string.startsWith("alf02 ")) {
            object = "Alpha" + string.substring(3).trim();
        } else if (string.startsWith("mu ")) {
            object = "My " + string.substring(3);
        } else if (string.startsWith("nu ")) {
            object = "Ny " + string.substring(3);
        } else if (string.startsWith("tet") && (Character.isDigit(string.charAt(3)) || ' ' == string.charAt(3))) {
            object = "Theta" + string.substring(3);
        }
        if (Pattern.matches("^[a-zA-Z]{2}.(01|02|03|04|05|06|07|08|09|10)? [a-zA-Z]{3,20}( (A|B|C|D|E|AB))?( (b|c|d|e|f|g|h|i))?", (CharSequence)object)) {
            object = ((String)object).replace(".", "");
        }
        if (Pattern.matches("^[a-zA-Z]{3}(01|02|03|04|05|06|07|08|09|10)? [a-zA-Z]{3,20}( (A|B|C|D|E|AB))?( (b|c|d|e|f|g|h|i))?", (CharSequence)object)) {
            String string2 = ((String)object).substring(0, 3).toLowerCase().trim();
            for (String string3 : GrichischesAlphabet.getListe()) {
                if (string3.length() <= 3 || !string2.equalsIgnoreCase(string3.substring(0, 3))) continue;
                object = string3 + ((String)object).substring(3);
                break;
            }
        }
        if (Pattern.matches("^[a-zA-Z]{1,7}(01|02|03|04|05|06|07|08|09|10)? [a-zA-Z]{3}( (A|B|C|D|E|AB))?( (b|c|d|e|f|g|h|i))?", (CharSequence)object)) {
            int n;
            String string3;
            int n2 = ((String)object).indexOf(" ") + 1;
            string3 = ((String)object).substring(n2, n = ((String)object).length()).trim();
            int n3 = string3.indexOf(" ");
            if (n3 > 0) {
                string3 = string3.substring(0, n3);
                n = n2 + n3 + 1;
            }
            try {
                String string4 = this.dao.getSternbildGenitiv(string3);
                if (string4 != null) {
                    String string5 = n3 > 0 ? " " + ((String)object).substring(n) : "";
                    object = ((String)object).substring(0, n2).trim() + " " + string4 + string5;
                }
            }
            catch (SQLException sQLException) {
                this.logger.error(object, sQLException);
            }
        }
        int n = 0;
        if (((String)object).toLowerCase().startsWith("ups ")) {
            n = 4;
        }
        if (((String)object).toLowerCase().startsWith("upsilon ")) {
            n = 8;
        }
        if (n > 0) {
            object = "Ypsilon " + ((String)object).substring(n, ((String)object).length());
        }
        if (Character.isLetter(((String)object).charAt(1))) {
            object = ((String)object).substring(0, 1).toUpperCase() + ((String)object).substring(1);
        }
        return object;
    }

    private String trimEmptySpace(String string) {
        String string2 = string;
        if (string.contains("  ")) {
            String[] stringArray = string.split(" ");
            StringBuilder stringBuilder = new StringBuilder(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (stringArray[i].isEmpty()) continue;
                stringBuilder.append(stringArray[i]).append(" ");
            }
            string2 = stringBuilder.toString().trim();
        }
        return string2;
    }

    private String korrigiereBayerNamen(String string) {
        try {
            String string2 = string.trim();
            string2 = string2.replaceAll("upsilon", "Ypsilon");
            string2 = string2.replaceAll("Upsilon", "Ypsilon");
            string2 = string2.replaceAll("Ups", "Upsilon");
            String[] stringArray = string2.split(" ");
            if (stringArray.length < 2) {
                return "";
            }
            if (stringArray[1].length() != 3) {
                return string2;
            }
            List<String> list = this.dao.getSternbilderNamen(SternbildSprache.LATEINISCH_ABK);
            list.remove("");
            for (String string3 : list) {
                if (!stringArray[1].toLowerCase().equals(string3.toLowerCase())) continue;
                String string4 = this.dao.getSternbildGenitiv(string3);
                String string5 = stringArray[0] + " " + string4;
                if (stringArray.length == 3) {
                    string5 = string5 + " " + stringArray[2];
                } else if (stringArray.length == 4) {
                    string5 = string5 + " " + stringArray[2] + " " + stringArray[3];
                }
                return string5;
            }
            return string2;
        }
        catch (SQLException sQLException) {
            this.logger.error("Fehler in korrigiereBayerNamen(" + string + ")", sQLException);
            return string;
        }
    }

    public String korrigiereBdUndCdUndAgKatalogNamen(String string, String string2) {
        int n = string2.length() + 2;
        String string3 = string.substring(0, n);
        int n2 = string.length();
        String string4 = "";
        if (!Character.isDigit(string.charAt(string.length() - 1))) {
            n2 = string.length() - 2;
            string4 = string.substring(n2);
        }
        String string5 = string.substring(n, n2).trim();
        int n3 = Integer.parseInt(string5);
        String string6 = string3 + " " + n3 + string4;
        return string6;
    }

    public String korrigiereNamenMehrfachstern(String string) throws SQLException {
        try {
            if (string.endsWith(" AB") || string.endsWith(" CD")) {
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add(string.substring(0, string.length() - 3) + "AB");
                if (this.dao.isObjektInDatenbank(arrayList) > 0) {
                    return (String)arrayList.get(0);
                }
            } else if (string.endsWith("AB") || string.endsWith("CD")) {
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add(string.substring(0, string.length() - 2) + " AB");
                if (this.dao.isObjektInDatenbank(arrayList) > 0) {
                    return (String)arrayList.get(0);
                }
            } else if (string.endsWith(" A") || string.endsWith(" B") || string.endsWith(" C") || string.endsWith(" D") || string.endsWith(" E")) {
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add(string.substring(0, string.length() - 2) + string.charAt(string.length() - 1));
                if (this.dao.isObjektInDatenbank(arrayList) > 0) {
                    return (String)arrayList.get(0);
                }
            } else if (string.endsWith("A") || string.endsWith("B") || string.endsWith("C") || string.endsWith("D") || string.endsWith("E")) {
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add(string.substring(0, string.length() - 1) + " " + string.charAt(string.length() - 1));
                if (this.dao.isObjektInDatenbank(arrayList) > 0) {
                    return (String)arrayList.get(0);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.logger.error("korrigiereNamenMehrfachstern(" + string + ")", indexOutOfBoundsException);
        }
        return string;
    }
}

