/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.helfer;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datenbank.importierer.api.IImportBeobachter;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;

public final class KorrigiereSpektraltyp {
    private final IImportBeobachter beobachter;
    private final PlanetensucheObjektPrueferDAO dao;
    private final ILogging logger;
    private final ISprachcontainer sprache;

    public KorrigiereSpektraltyp(IImportBeobachter iImportBeobachter, PlanetensucheObjektPrueferDAO planetensucheObjektPrueferDAO) {
        this.beobachter = iImportBeobachter;
        this.dao = planetensucheObjektPrueferDAO;
        this.logger = LoggingFactory.getLoggerForClass(KorrigiereSpektraltyp.class);
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
    }

    public boolean speichereSptypCSVBeliebig(IPlanetensucheObjekt iPlanetensucheObjekt, String string, boolean bl) throws SQLException {
        boolean bl2;
        try {
            boolean bl3;
            Object object = string.trim();
            object = ((String)object).replace(",", ".");
            object = this.entferneNichtAuswertbareInfos((String)object);
            object = this.korrigiereUneindeutiges((String)object, bl);
            boolean bl4 = bl3 = ((String)object).startsWith("C") || ((String)object).startsWith("R") || ((String)object).startsWith("N");
            if (bl3) {
                object = "W" + (String)object;
                iPlanetensucheObjekt.setObjekttyp(this.sprache.getString("ps_ot_wolfrayet"));
            }
            Object object2 = "";
            Object object3 = "";
            Object object4 = "";
            int n = 0;
            for (char c : ((String)object).toCharArray()) {
                boolean bl5 = Character.isDigit(c);
                if (!(n != 0 && n != 1 || bl5 || Character.isLowerCase(c))) {
                    object2 = (String)object2 + c;
                } else if (n < 4 && (bl5 || c == '.')) {
                    object3 = (String)object3 + c;
                } else if (n < 5 && (bl5 || c == '.') && ((String)object2).startsWith("D")) {
                    object3 = (String)object3 + c;
                } else if (n >= 2 && (c == 'I' || c == 'V' || c == 'a' || c == 'b')) {
                    object4 = (String)object4 + c;
                }
                if (((String)object4).length() == 3) break;
                ++n;
            }
            iPlanetensucheObjekt.setSpektralklasse((String)object2);
            if (!((String)object3).isEmpty() && !".".equals(object3)) {
                double d = Double.parseDouble((String)object3);
                d = this.korrigiereSptyp2(d);
                iPlanetensucheObjekt.setSpektralklasse2(d);
            }
            if (Check.isEmpty(object4 = this.korrigiereLeuchtkraftklasse((String)object4)) && ((String)object).startsWith("D")) {
                iPlanetensucheObjekt.setLeuchtkraftklasse("VII");
            } else {
                Object object5 = this.dao.getLeuchtkraftklassen();
                for (int i = object5.size() - 1; i >= 0; --i) {
                    String string2 = (String)object5.get(i);
                    if (!((String)object4).startsWith(string2)) continue;
                    iPlanetensucheObjekt.setLeuchtkraftklasse(string2);
                    break;
                }
            }
            this.korrigiereONullUnsinn(iPlanetensucheObjekt);
            bl2 = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.beobachter.appendOutput("Sptyp: " + string + " " + numberFormatException.toString());
            this.logger.warn("speichereSptyp(<psobjekt>," + string + "," + bl + ")", numberFormatException);
            this.korrigiereONullUnsinn(iPlanetensucheObjekt);
            bl2 = false;
        }
        return bl2;
    }

    private void korrigiereONullUnsinn(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        if ("O".equals(iPlanetensucheObjekt.getSpektralklasse()) && iPlanetensucheObjekt.getSpektralklasse2() == 0.0) {
            iPlanetensucheObjekt.setSpektralklasse("unbekannt");
        }
    }

    public String getKorrigierterSptypFrObsCSV(String string) {
        try {
            boolean bl;
            Object object = string;
            if (((String)object).startsWith("KO") || ((String)object).startsWith("GO")) {
                object = ((String)object).substring(0, 1) + "0" + ((String)object).substring(2, ((String)object).length());
            }
            if ("G IV".equals(object)) {
                object = "G0IV";
            }
            if ("FIV8".equals(object)) {
                object = "F8IV";
            }
            boolean bl2 = "Catac. var.".equals(object) || "AM Her".equals(object);
            boolean bl3 = bl = "B D".equals(object) || "WD+M".equals(object);
            if (bl2 || "G or K".equals(object) || "kov".equals(object) || ((String)object).startsWith("sdB") || bl) {
                return "unbekannt;0.0;unbekannt";
            }
            PlanetensucheObjekt planetensucheObjekt = new PlanetensucheObjekt();
            this.speichereSptypCSVBeliebig(planetensucheObjekt, (String)object, true);
            return planetensucheObjekt.getSpektralklasse() + ";" + planetensucheObjekt.getSpektralklasse2() + ";" + planetensucheObjekt.getLeuchtkraftklasse();
        }
        catch (SQLException sQLException) {
            this.logger.warn(sQLException);
            return "unbekannt;0.0;unbekannt";
        }
    }

    private String entferneNichtAuswertbareInfos(String string) {
        String string2 = string.replaceAll(":", "");
        string2 = string2.replace("...", "");
        string2 = string2.replace("*", "");
        string2 = string2.replace("+", "");
        string2 = string2.replace("e", "");
        return string2.trim();
    }

    private double korrigiereSptyp2(double d) {
        double d2 = d;
        double d3 = d - (double)((int)d);
        if (d3 < 0.5) {
            d2 = d - d3;
        } else if (d3 > 0.5) {
            d2 = 1.0 + (double)((int)d);
        }
        if (d2 > 9.5) {
            d2 = 9.5;
        }
        return d2;
    }

    private String korrigiereLeuchtkraftklasse(String string) {
        Object object = string.trim();
        if (((String)(object = ((String)object).replace("B", ""))).endsWith("I") && !((String)object).endsWith("II") && !((String)object).endsWith("VI")) {
            object = (String)object + "a";
        }
        return object;
    }

    private String korrigiereUneindeutiges(String string, boolean bl) {
        int n;
        Object object = string;
        int n2 = string.indexOf(47);
        if (n2 > 0) {
            Object object2 = string.substring(0, n2);
            if (bl) {
                int n3 = string.indexOf(" ");
                if (n3 > n2) {
                    object2 = (String)object2 + string.substring(n3);
                } else {
                    int n4;
                    Object object3 = "";
                    for (int i = string.length() - 1; i > n2 && Character.isLetter((char)(n4 = string.charAt(i))); --i) {
                        object3 = (char)n4 + (String)object3;
                    }
                    if (Check.isFilled(object3)) {
                        char c;
                        Object object4 = "";
                        for (n4 = ((String)object2).length() - 1; n4 > 0 && Character.isLetter(c = ((String)object2).charAt(n4)); --n4) {
                            object4 = c + (String)object4;
                        }
                        if (Check.isFilled(object4) && ((String)object4).length() > 1 && !this.isLkGueltig((String)object4)) {
                            for (n4 = 1; n4 < ((String)object4).length() - 1; ++n4) {
                                String string2 = ((String)object4).substring(0, ((String)object4).length() - n4);
                                if (!this.isLkGueltig(string2)) continue;
                                object4 = string2;
                                break;
                            }
                        }
                        object2 = !this.isLkGueltig((String)object3) && this.isLkGueltig((String)object4) ? ((String)object2).trim() + " " + (String)object4 : (Check.isFilled(object4) ? ((String)object2).substring(0, ((String)object2).indexOf((String)object4)).trim() + " " + (String)object3 : ((String)object2).trim() + " " + (String)object3);
                    }
                }
            }
            object = object2;
        }
        if ((n2 = ((String)object).indexOf("(")) > 0) {
            int n5 = ((String)object).indexOf(")");
            object = n2 < 3 && n5 > n2 + 1 ? ((String)object).substring(0, n2) + ((String)object).substring(n2 + 1, n5) : ((String)object).substring(0, n2);
        }
        if ((n = ((String)object).indexOf("-")) > 2) {
            object = ((String)object).substring(0, n);
        }
        if (!string.equals(object)) {
            String string3 = "sptyp '" + string + "' in '" + (String)object + "' korrigiert";
            this.logger.debug(string3);
        }
        return object;
    }

    private boolean isLkGueltig(String string) {
        try {
            if (Check.isEmpty(string)) {
                return false;
            }
            List<String> list = this.dao.getLeuchtkraftklassen();
            boolean bl = list.contains(string);
            return bl;
        }
        catch (SQLException sQLException) {
            this.logger.error("LK lesen gescheitert", sQLException);
            return true;
        }
    }
}

