/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.helfer;

import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.regex.Pattern;

public final class MoaKatalogNameCorrector {
    private final ILogging logging;
    private final Katalogerkenner katalogerkenner;

    public MoaKatalogNameCorrector(Katalogerkenner katalogerkenner) {
        this.katalogerkenner = katalogerkenner;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public String fixMoaName(String string) {
        Object object = string;
        int n = 1;
        while (true) {
            if (this.katalogerkenner.isMicrolensingObservationsInAstrophysics((String)object)) {
                if (!((String)object).equals(string)) {
                    this.logging.debug("fixed MOA name from '" + string + "' into '" + (String)object + "'");
                }
                return object;
            }
            if (n >= 6) {
                this.logging.warn("unable to fix wrong MOA name '" + string + "' completly (" + (String)object + ")");
                return object;
            }
            ++n;
            if (((String)object).startsWith("MOA ")) {
                object = "MOA-" + ((String)object).substring(4);
                continue;
            }
            boolean bl = Pattern.compile("^MOA-[0-9]{4}-[0-9]{3,4}.*").matcher((CharSequence)object).matches();
            if (bl) {
                object = ((String)object).substring(0, 8) + "-BLG" + ((String)object).substring(8);
                continue;
            }
            bl = Pattern.compile("^MOA-[0-9]{2}-(BLG-)*[0-9]{3,4}.*").matcher((CharSequence)object).matches();
            if (bl) {
                object = ((String)object).substring(0, 4) + "20" + ((String)object).substring(4);
                continue;
            }
            bl = Pattern.compile("^MOA-[0-9]{4}-BLG-[0-9]{3,4}").matcher((CharSequence)object).matches();
            if (bl) {
                object = (String)object + "L";
                continue;
            }
            bl = Pattern.compile("^MOA-[0-9]{4}-BLG-[0-9]{2}(L)* (b|c|d|e|f|g|h)*").matcher((CharSequence)object).matches();
            if (bl) {
                object = ((String)object).substring(0, 13) + "0" + ((String)object).substring(13);
                continue;
            }
            bl = Pattern.compile("^MOA-[0-9]{4}-BLG-[0-9]{3,4}\\(AB\\) (b|c|d|e|f|g|h)*").matcher((CharSequence)object).matches();
            if (bl) {
                int n2 = ((String)object).indexOf("(AB)");
                object = ((String)object).substring(0, n2) + "L" + ((String)object).substring(n2);
                continue;
            }
            bl = Pattern.compile("^MOA-[0-9]{4}-BLG-[0-9]{3,4} (b|c|d|e|f|g|h)").matcher((CharSequence)object).matches();
            if (!bl) continue;
            object = ((String)object).substring(0, ((String)object).length() - 2) + "L" + ((String)object).substring(((String)object).length() - 2);
        }
    }
}

