/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.helfer;

import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.regex.Pattern;

public final class OgleKatalogNameCorrector {
    private final ILogging logging;
    private final Katalogerkenner katalogerkenner;

    public OgleKatalogNameCorrector(Katalogerkenner katalogerkenner) {
        this.katalogerkenner = katalogerkenner;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public String fixOgleName(String string) {
        Object object = string;
        int n = 1;
        while (true) {
            if (this.katalogerkenner.isOpticalGravitationalLensingExperiment((String)object)) {
                if (!((String)object).equals(string)) {
                    this.logging.debug("fixed OGLE name from '" + string + "' into '" + (String)object + "'");
                }
                return object;
            }
            if (n >= 6) {
                this.logging.warn("unable to fix wrong OGLE name '" + string + "' completly (" + (String)object + ")");
                return object;
            }
            ++n;
            if (((String)object).startsWith("OGLE ")) {
                object = "OGLE-" + ((String)object).substring(5);
                continue;
            }
            boolean bl = Pattern.compile("^OGLE-[0-9]{4}-[0-9]{3,4}.*").matcher((CharSequence)object).matches();
            if (bl) {
                object = ((String)object).substring(0, 9) + "-BLG" + ((String)object).substring(9);
                continue;
            }
            bl = Pattern.compile("^OGLE-[0-9]{2}-(BLG-)*[0-9]{3,4}.*").matcher((CharSequence)object).matches();
            if (bl) {
                object = ((String)object).substring(0, 5) + "20" + ((String)object).substring(5);
                continue;
            }
            bl = Pattern.compile("^OGLE-[0-9]{4}-BLG-[0-9]{3,4}").matcher((CharSequence)object).matches();
            if (bl) {
                object = (String)object + "L";
                continue;
            }
            bl = Pattern.compile("^OGLE-[0-9]{4}-BLG-[0-9]{2}(L)* (b|c|d|e|f|g|h)*").matcher((CharSequence)object).matches();
            if (bl) {
                object = ((String)object).substring(0, 14) + "0" + ((String)object).substring(14);
                continue;
            }
            bl = Pattern.compile("^OGLE-[0-9]{4}-BLG-[0-9]{3,4}\\(AB\\) (b|c|d|e|f|g|h)*").matcher((CharSequence)object).matches();
            if (bl) {
                int n2 = ((String)object).indexOf("(AB)");
                object = ((String)object).substring(0, n2) + "L" + ((String)object).substring(n2);
                continue;
            }
            bl = Pattern.compile("^OGLE-[0-9]{4}-BLG-[0-9]{3,4} (b|c|d|e|f|g|h)").matcher((CharSequence)object).matches();
            if (!bl) continue;
            object = ((String)object).substring(0, ((String)object).length() - 2) + "L" + ((String)object).substring(((String)object).length() - 2);
        }
    }
}

