/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.merge;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datenbank.importierer.merge.DefaultMerger;
import de.planetensuche.datenbank.importierer.merge.PlanetensucheObjectMatcher;
import de.planetensuche.datenbank.importierer.merge.PlanetensucheObjectMatcherFactory;
import de.planetensuche.datenbank.importierer.merge.PsObjectMergeException;
import de.planetensuche.datenbank.importierer.validator.CatalogNamesValidator;
import de.planetensuche.datenbank.importierer.validator.InvalidCatalogException;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenKlassifiziererService;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckAndMerge {
    private final ILogging logger;
    private final DefaultMerger defaultMerger;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;

    public CheckAndMerge(IPlanetensucheObjektRepository iPlanetensucheObjektRepository, PlanetensucheObjektPrueferDAO planetensucheObjektPrueferDAO, CatalogNamesValidator catalogNamesValidator, ObjektnamenKlassifiziererService objektnamenKlassifiziererService) {
        this.defaultMerger = new DefaultMerger(iPlanetensucheObjektRepository, planetensucheObjektPrueferDAO, catalogNamesValidator, objektnamenKlassifiziererService);
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public IPlanetensucheObjekt checkAndMerge(Collection<Integer> collection) throws InvalidCatalogException, PsObjectMergeException {
        if (collection.size() <= 1) {
            throw new PsObjectMergeException("es m\u00fcssen mindestens 2 datenid's f\u00fcr einen merge vorhanden sein");
        }
        try {
            List<IPlanetensucheObjekt> list = this.findObjectsForDatenIds(collection);
            IPlanetensucheObjekt iPlanetensucheObjekt = list.get(0);
            this.testIfMergeIsPossible(iPlanetensucheObjekt, list);
            return this.defaultMerger.merge(list);
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
            throw new PsObjectMergeException(exception.getMessage());
        }
    }

    private List<IPlanetensucheObjekt> findObjectsForDatenIds(Collection<Integer> collection) throws SQLException {
        ArrayList<IPlanetensucheObjekt> arrayList = new ArrayList<IPlanetensucheObjekt>();
        for (Integer n : collection) {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n);
            arrayList.add(iPlanetensucheObjekt);
        }
        return arrayList;
    }

    private void testIfMergeIsPossible(IPlanetensucheObjekt iPlanetensucheObjekt, List<IPlanetensucheObjekt> list) throws PsObjectMergeException {
        PlanetensucheObjectMatcher planetensucheObjectMatcher = PlanetensucheObjectMatcherFactory.get(iPlanetensucheObjekt.getKategorie());
        for (IPlanetensucheObjekt iPlanetensucheObjekt2 : list) {
            if (iPlanetensucheObjekt == iPlanetensucheObjekt2 || planetensucheObjectMatcher.isTheSame(iPlanetensucheObjekt, iPlanetensucheObjekt2)) continue;
            throw new PsObjectMergeException("object " + String.valueOf(iPlanetensucheObjekt.getObjektNamen()) + " match not with object " + String.valueOf(iPlanetensucheObjekt2.getObjektNamen()) + ", cancel merge");
        }
    }
}

