/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.merge;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.helfer.PlanetensucheObjektMerger;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.importierer.merge.LastEditComparator;
import de.planetensuche.datenbank.importierer.merge.PsObjectMergeException;
import de.planetensuche.datenbank.importierer.validator.CatalogNamesValidator;
import de.planetensuche.datenbank.importierer.validator.InvalidCatalogException;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenKlassifiziererService;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class DefaultMerger {
    private final ILogging logging;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final PlanetensucheObjektPrueferDAO daoHigh;
    private final CatalogNamesValidator catalogNamesValidator;
    private final ObjektnamenKlassifiziererService katalogerkenner;

    DefaultMerger(IPlanetensucheObjektRepository iPlanetensucheObjektRepository, PlanetensucheObjektPrueferDAO planetensucheObjektPrueferDAO, CatalogNamesValidator catalogNamesValidator, ObjektnamenKlassifiziererService objektnamenKlassifiziererService) {
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.daoHigh = planetensucheObjektPrueferDAO;
        this.catalogNamesValidator = catalogNamesValidator;
        this.katalogerkenner = objektnamenKlassifiziererService;
    }

    public IPlanetensucheObjekt merge(List<IPlanetensucheObjekt> list) throws InvalidCatalogException, PsObjectMergeException {
        if (list.size() <= 1) {
            throw new PsObjectMergeException("es m\u00fcssen mindestens 2 datenid's f\u00fcr einen merge vorhanden sein");
        }
        List<Integer> list2 = list.stream().map(iPlanetensucheObjekt -> iPlanetensucheObjekt.getDatenid()).collect(Collectors.toList());
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (IPlanetensucheObjekt object22 : list) {
                arrayList.addAll(object22.getObjektNamen());
            }
            this.validateObjectCategory(list, list2);
            this.catalogNamesValidator.validate(arrayList, list.get(0).getCategory());
            Object object3 = "";
            for (IPlanetensucheObjekt iPlanetensucheObjekt2 : list) {
                object3 = (String)object3 + " " + String.valueOf(iPlanetensucheObjekt2.getObjektNamen()) + " with";
            }
            this.logging.warn("start to merge object" + ((String)object3).substring(0, ((String)object3).length() - 4));
            IPlanetensucheObjekt iPlanetensucheObjekt3 = this.findMergeBase(list);
            for (IPlanetensucheObjekt iPlanetensucheObjekt4 : list) {
                if (iPlanetensucheObjekt4 == iPlanetensucheObjekt3) continue;
                this.mergeMainData(iPlanetensucheObjekt3, iPlanetensucheObjekt4);
            }
            this.deleteOldObjects(list2, iPlanetensucheObjekt3);
            PlanetensucheObjektPruefer planetensucheObjektPruefer = new PlanetensucheObjektPruefer(this.daoHigh, iPlanetensucheObjekt3);
            this.planetensucheObjektRepository.update(planetensucheObjektPruefer, true, this.katalogerkenner);
            return planetensucheObjektPruefer;
        }
        catch (IOException | SQLException exception) {
            this.logging.error("merge(" + Arrays.toString(list2.toArray()) + ")", exception);
            throw new PsObjectMergeException("merge with ids " + Arrays.toString(list2.toArray()) + " not possible because of " + exception.getMessage());
        }
    }

    private void deleteOldObjects(List<Integer> list, IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        for (Integer n : list) {
            if (n.intValue() == iPlanetensucheObjekt.getDatenid().intValue()) continue;
            this.logging.debug("delete old object with id " + n + " after merge");
            this.planetensucheObjektRepository.updateReferences(iPlanetensucheObjekt.getDatenid(), n);
            this.planetensucheObjektRepository.delete(n);
        }
    }

    private IPlanetensucheObjekt findMergeBase(List<IPlanetensucheObjekt> list) {
        IPlanetensucheObjekt iPlanetensucheObjekt = null;
        if (ObjektKategorie.PLANETEN.getKategorienName().equals(list.get(0).getKategorie())) {
            for (IPlanetensucheObjekt iPlanetensucheObjekt2 : list) {
                if (!iPlanetensucheObjekt2.isEntdeckungBestaetigt() || "ExoFOP".equals(iPlanetensucheObjekt2.getAutor())) continue;
                iPlanetensucheObjekt = iPlanetensucheObjekt2;
                break;
            }
        }
        if (iPlanetensucheObjekt == null) {
            Collections.sort(list, new LastEditComparator());
            iPlanetensucheObjekt = list.get(0);
        }
        return iPlanetensucheObjekt;
    }

    private void validateObjectCategory(List<IPlanetensucheObjekt> list, Collection<Integer> collection) throws PsObjectMergeException {
        String string = list.get(0).getKategorie();
        for (IPlanetensucheObjekt iPlanetensucheObjekt : list) {
            if (DefaultMerger.isCategoryCompatible(iPlanetensucheObjekt.getKategorie(), string)) continue;
            String string2 = "merge for " + Arrays.toString(collection.toArray()) + " not possible, category '" + string + "' and '" + iPlanetensucheObjekt.getKategorie() + "' detected!";
            this.logging.warn(string2);
            throw new PsObjectMergeException(string2);
        }
    }

    private static boolean isCategoryCompatible(String string, String string2) {
        if (ObjektKategorie.BR_ZWERGE.getKategorienName().equals(string) && ObjektKategorie.PLANETEN.getKategorienName().equals(string2)) {
            return true;
        }
        if (ObjektKategorie.PLANETEN.getKategorienName().equals(string) && ObjektKategorie.BR_ZWERGE.getKategorienName().equals(string2)) {
            return true;
        }
        return string.equals(string2);
    }

    private void mergeMainData(IPlanetensucheObjekt iPlanetensucheObjekt, IPlanetensucheObjekt iPlanetensucheObjekt2) throws SQLException {
        PlanetensucheObjektMerger.merge(this.logging, iPlanetensucheObjekt2, iPlanetensucheObjekt);
        if (iPlanetensucheObjekt.getBilder().isEmpty()) {
            iPlanetensucheObjekt.setBilder(iPlanetensucheObjekt2.getBilder());
        }
        if (!iPlanetensucheObjekt.getObjekttyp().equalsIgnoreCase(iPlanetensucheObjekt2.getObjekttyp()) && StarObjectType.SINGLE_STAR.getTypeName().equalsIgnoreCase(iPlanetensucheObjekt.getObjekttyp())) {
            iPlanetensucheObjekt.setObjekttyp(iPlanetensucheObjekt2.getObjekttyp());
        }
        if (iPlanetensucheObjekt.getNotiz() == null || iPlanetensucheObjekt.getNotiz().trim().isEmpty()) {
            iPlanetensucheObjekt.setNotiz(iPlanetensucheObjekt2.getNotiz());
        }
        if (iPlanetensucheObjekt.getUmkreistObjekt() == null || iPlanetensucheObjekt.getUmkreistObjekt().isEmpty()) {
            iPlanetensucheObjekt.setUmkreistObjekt(iPlanetensucheObjekt2.getUmkreistObjekt());
        }
        if (iPlanetensucheObjekt.getWirdUmkreistVonNamen().isEmpty() && !iPlanetensucheObjekt2.getWirdUmkreistVonNamen().isEmpty()) {
            iPlanetensucheObjekt.setWirdUmkreistVon(iPlanetensucheObjekt2.getWirdUmkreistVonNamen());
            iPlanetensucheObjekt.setWirdUmkreistVonIDs(iPlanetensucheObjekt2.getWirdUmkreistVonIDs());
        }
        if (iPlanetensucheObjekt.isSternbildUnbekannt() && !iPlanetensucheObjekt2.isSternbildUnbekannt()) {
            iPlanetensucheObjekt.setSternbildCode(iPlanetensucheObjekt2.getSternbildCode());
            iPlanetensucheObjekt.setSternbildDTBezeichnung(iPlanetensucheObjekt2.getSternbildDTBezeichnung());
            iPlanetensucheObjekt.setSternbildENGBezeichnung(iPlanetensucheObjekt2.getSternbildENGBezeichnung());
            iPlanetensucheObjekt.setSternbildLATBezeichnung(iPlanetensucheObjekt2.getSternbildLATBezeichnung());
        }
    }
}

