/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.threads;

import com.google.common.io.Files;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;

public abstract class AbstractBasisImport
extends Thread {
    protected final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private int gesamteZeilenanzahl;
    private int aktuelleZeile;
    private long bisherGebrauchteZeit = 0L;
    private File datei;
    private final File zwischenstandDatei = new File("temp" + File.separator + "resumepoint.dat");
    private static final String KEY_DATEI = "file:=";
    private static final String KEY_GESAMT = "ges:=";
    private static final String KEY_AKTUELL = "akt:=";
    private static final String KEY_VERGANGENEZEIT = "zeit:=";

    @Override
    public void run() {
    }

    public final boolean ladeZwischenstand() {
        if (!this.zwischenstandDatei.exists()) {
            return false;
        }
        try {
            List<String> list = Files.readLines(this.zwischenstandDatei, Charset.forName("UTF-8"));
            for (String string : list) {
                if (string.startsWith(KEY_DATEI)) {
                    File file = new File(string.substring(6, string.length()));
                    if (file.getAbsolutePath().equals(this.datei.getAbsolutePath())) continue;
                    return false;
                }
                if (string.startsWith(KEY_GESAMT)) {
                    if (!string.equals(KEY_GESAMT + this.gesamteZeilenanzahl)) {
                        return false;
                    }
                    this.gesamteZeilenanzahl = Integer.parseInt(string.substring(5, string.length()));
                    continue;
                }
                if (string.startsWith(KEY_AKTUELL)) {
                    this.aktuelleZeile = Integer.parseInt(string.substring(5, string.length()));
                    continue;
                }
                if (!string.startsWith(KEY_VERGANGENEZEIT)) continue;
                this.bisherGebrauchteZeit = Long.parseLong(string.substring(6, string.length()));
            }
            return true;
        }
        catch (Exception exception) {
            this.logger.error(exception);
            this.aktuelleZeile = 0;
            this.gesamteZeilenanzahl = 0;
            return false;
        }
    }

    public final boolean speichereZwischenstand() {
        boolean bl;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.zwischenstandDatei, false), Charset.forName("UTF-8")));
        try {
            bufferedWriter.write(KEY_DATEI + this.datei.getAbsolutePath());
            bufferedWriter.newLine();
            bufferedWriter.write(KEY_GESAMT + this.gesamteZeilenanzahl);
            bufferedWriter.newLine();
            bufferedWriter.write(KEY_AKTUELL + this.aktuelleZeile);
            bufferedWriter.newLine();
            bufferedWriter.write(KEY_VERGANGENEZEIT + this.bisherGebrauchteZeit);
            bufferedWriter.newLine();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                this.logger.error(iOException);
                return false;
            }
        }
        bufferedWriter.close();
        return bl;
    }

    public final synchronized void incrementAktuelleZeile() {
        ++this.aktuelleZeile;
    }

    public final void incrementGesamteZeile() {
        ++this.gesamteZeilenanzahl;
    }

    public final int getAktuelleZeile() {
        return this.aktuelleZeile;
    }

    public final int getGesamteZeilenanzahl() {
        return this.gesamteZeilenanzahl;
    }

    public final File getDatei() {
        return this.datei;
    }

    public final void setDatei(File file) {
        this.datei = file;
    }

    public final void setGesamteZeilenanzahl(int n) {
        this.gesamteZeilenanzahl = n;
    }

    public final long getBisherGebrauchteZeit() {
        return this.bisherGebrauchteZeit;
    }

    public final void setBisherGebrauchteZeit(long l) {
        this.bisherGebrauchteZeit = l;
    }

    public final void setAktuelleZeile(int n) {
        this.aktuelleZeile = n;
    }
}

