/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport;

import com.google.common.io.Files;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.exportierer.guis.ExportDialog;
import de.planetensuche.datenbank.exportierer.threads.ExportthreadXML;
import de.planetensuche.datenbank.importierer.api.FileImporter;
import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbank.importierer.api.InvalidImportFileException;
import de.planetensuche.datenbank.importierer.api.TSVSpaltenTyp;
import de.planetensuche.datenbank.importierer.api.UnsupportedCSVSchemaVersionException;
import de.planetensuche.datenbank.importierer.helfer.KorrigiereNamen;
import de.planetensuche.datenbank.importierer.helfer.KorrigiereSpektraltyp;
import de.planetensuche.datenbank.importierer.merge.CheckAndMerge;
import de.planetensuche.datenbank.importierer.threads.AbstractBasisImport;
import de.planetensuche.datenbank.importierer.tsvimport.DoppelteObjektnamenFinder;
import de.planetensuche.datenbank.importierer.tsvimport.ObjektnamenMitKomponentenBauer;
import de.planetensuche.datenbank.importierer.tsvimport.TsvServiceLocator;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvCommand;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOption;
import de.planetensuche.datenbank.importierer.validator.CatalogNamesValidator;
import de.planetensuche.datenbank.kataloge.CatalogBuilderService;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public final class ImportthreadTSV
extends AbstractBasisImport
implements FileImporter {
    private final ParameterDto parameter;
    private final IImportDialog importDialog;
    private final ISprachcontainer i18n;
    private final KorrigiereNamen fixNames;
    private final KorrigiereSpektraltyp korrigiereSpektraltyp;
    private int spaltenanzahl;
    private String trennzeichen;
    private String ignorierenzeichen;
    private String kategorie;
    private String autor;
    private String[] spaltenBezeichnung;
    private final List<String> erfolgreichGespeicherteObjekte;
    private final List<String> nichtEingefuegteObjekte;
    private final List<String> uebersprungeneObjekte;
    private final List<IPlanetensucheObjekt> psobjekteFuerXML;
    private static final int LAENGE_KATALOG_NR = TSVSpaltenTyp.KATALOG_NR.name().length();
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final ObjektnamenMitKomponentenBauer objektnamenMitKomponentenBauer;
    private final PlanetensucheObjektPrueferDAO daoHigh;
    private final InjectionDto injectionDto;
    private final CatalogNamesValidator catalogNamesValidator;
    private final CatalogBuilderService catalogBuilderService;
    private final CheckAndMerge merger;
    private final File xmlOutput;
    private final KonfigurationDTO globaleKonfig;
    private boolean importStopped = false;

    public ImportthreadTSV(File file, File file2, IImportDialog iImportDialog, ParameterDto parameterDto, InjectionDto injectionDto, Katalogerkenner katalogerkenner, KonfigurationDTO konfigurationDTO) throws IOException {
        this.setDatei(file);
        this.xmlOutput = file2;
        this.parameter = parameterDto;
        this.importDialog = iImportDialog;
        this.i18n = parameterDto.getSprache();
        this.planetensucheObjektRepository = injectionDto.getPlanetensucheObjektRepository();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.daoHigh = injectionDto.getDao();
        this.injectionDto = injectionDto;
        this.globaleKonfig = konfigurationDTO;
        this.erfolgreichGespeicherteObjekte = new ArrayList<String>();
        this.nichtEingefuegteObjekte = new ArrayList<String>();
        this.uebersprungeneObjekte = new ArrayList<String>();
        this.psobjekteFuerXML = new ArrayList<IPlanetensucheObjekt>();
        this.fixNames = new KorrigiereNamen(this.daoHigh, katalogerkenner);
        this.korrigiereSpektraltyp = new KorrigiereSpektraltyp(this.importDialog, this.daoHigh);
        this.objektnamenMitKomponentenBauer = new ObjektnamenMitKomponentenBauer();
        this.catalogNamesValidator = new CatalogNamesValidator(this.fixNames.getKatalogerkenner());
        this.catalogBuilderService = new CatalogBuilderService();
        this.merger = new CheckAndMerge(this.planetensucheObjektRepository, this.daoHigh, this.catalogNamesValidator, injectionDto.getKatalogerkenner());
        this.trennzeichen = ";";
        this.ignorierenzeichen = "#";
        this.kategorie = "nein";
        this.autor = "nein";
    }

    @Override
    public void run() {
        block5: {
            if (this.getDatei() != null && this.importDialog != null) {
                try {
                    this.importDialog.appendOutput(this.i18n.getString("db_m165_1") + " '" + this.getDatei().getName() + "' " + this.i18n.getString("db_m165_2"));
                    this.importDialog.setStatus(0);
                    if (this.importBeliebigeCSV()) {
                        System.out.println(this.i18n.getString("db_m170"));
                        this.importDialog.appendOutput(this.i18n.getString("db_m170"));
                        this.importDialog.setStatus(100);
                        JOptionPane.showMessageDialog(this.importDialog.getDialog(), this.i18n.getString("db_m170"), this.i18n.getString("db_m171_titel"), 1);
                        break block5;
                    }
                    System.out.println(this.i18n.getString("db_m172"));
                    this.importDialog.appendOutput(this.i18n.getString("db_m172"));
                    this.importDialog.setStatus(0);
                    JOptionPane.showMessageDialog(this.importDialog.getDialog(), this.i18n.getString("db_f36"), this.i18n.getString("db_f34_titel"), 0);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    this.importDialog.appendOutput(this.i18n.getString("db_f34_titel") + "...");
                    this.logger.error("Fehler in importthread.run(): " + exception.toString(), exception);
                }
            } else {
                throw new IllegalArgumentException("Fehler wegen leeren Aufrufparametern!");
            }
        }
    }

    @Override
    public boolean importiereCsvDatei() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void interrupt() {
        this.importStopped = true;
        super.interrupt();
    }

    private boolean importBeliebigeCSV() {
        try {
            this.importDialog.setStartButtonEnabled(false);
            this.importDialog.setCursurWait(true);
            this.logger.debug("lese CSV-Schema ein...");
            this.erkenneTSVDateiaufbau();
            List<String> list = Files.readLines(this.getDatei(), Charset.forName("UTF-8"));
            this.logger.debug("ermittle Anzahl der Zeilen...");
            this.setGesamteZeilenanzahl(list.size());
            this.logger.debug(this.i18n.getString("db_m185") + " " + this.getGesamteZeilenanzahl() + " " + this.i18n.getString("db_m186"));
            this.importDialog.appendOutput(this.i18n.getString("db_m185") + " " + this.getGesamteZeilenanzahl() + " " + this.i18n.getString("db_m186"));
            DoppelteObjektnamenFinder doppelteObjektnamenFinder = new DoppelteObjektnamenFinder();
            Map<String, Map<List<String>, Double>> map = doppelteObjektnamenFinder.getDoppelteObjektnamen(list, this.ignorierenzeichen, this.trennzeichen, this.spaltenBezeichnung);
            if (this.ladeZwischenstand()) {
                int n = JOptionPane.showConfirmDialog(this.importDialog.getDialog(), this.i18n.getString("db_m429"), this.i18n.getString("db_m429_titel"), 0, 3);
                if (n == 0) {
                    this.logger.info(this.i18n.getString("db_m428"));
                    this.importDialog.appendOutput(this.i18n.getString("db_m428"));
                } else {
                    this.setBisherGebrauchteZeit(0L);
                    this.setAktuelleZeile(0);
                }
            }
            ImportOption importOption = this.resolveImportOption();
            this.logger.info("Import-Option " + importOption.toString() + " erkannt");
            TsvServiceLocator tsvServiceLocator = TsvServiceLocator.getInstance(importOption, this.korrigiereSpektraltyp, this.importDialog);
            int n = 0;
            long l = System.currentTimeMillis() - this.getBisherGebrauchteZeit();
            for (String string : list) {
                if (this.importStopped) break;
                if (n >= this.getAktuelleZeile()) {
                    this.importSingleLine(string, tsvServiceLocator, map);
                    this.incrementAktuelleZeile();
                }
                ++n;
                this.setBisherGebrauchteZeit(System.currentTimeMillis() - l);
                int n2 = (int)Math.round((double)this.getAktuelleZeile() * 100.0 / (double)this.getGesamteZeilenanzahl());
                this.importDialog.setStatus(n2);
                long l2 = Math.round((double)this.getBisherGebrauchteZeit() * 1.0 / (double)this.getAktuelleZeile() * (double)(this.getGesamteZeilenanzahl() - this.getAktuelleZeile()) / 1000.0);
                this.importDialog.setRestzeit(l2);
            }
            if (this.importDialog.umleitungInXML()) {
                if (!this.psobjekteFuerXML.isEmpty()) {
                    IPlanetensucheObjekt[] iPlanetensucheObjektArray = new PlanetensucheObjekt[this.psobjekteFuerXML.size()];
                    for (int i = 0; i < this.psobjekteFuerXML.size(); ++i) {
                        iPlanetensucheObjektArray[i] = this.psobjekteFuerXML.get(i);
                        iPlanetensucheObjektArray[i].setStamp(new Timestamp(System.currentTimeMillis()));
                    }
                    ExportDialog exportDialog = new ExportDialog(this.parameter, this.injectionDto, this.globaleKonfig);
                    exportDialog.setVisible(false);
                    exportDialog.setUmgeleitetVonImport(iPlanetensucheObjektArray);
                    ExportthreadXML exportthreadXML = new ExportthreadXML(this.xmlOutput, exportDialog, this.parameter, this.injectionDto, this.globaleKonfig);
                    exportDialog.setVisible(true);
                    exportthreadXML.start();
                } else {
                    this.importDialog.appendOutput(this.i18n.getString("db_f44"));
                    this.importDialog.appendOutput(this.i18n.getString("db_f45"));
                }
            }
            this.loggeUndZeigeText("erfolgreich eingefuegte/aktualisierte Objekte: " + this.erfolgreichGespeicherteObjekte.size());
            this.loggeUndZeigeText("uebersprungene Objekte: " + this.uebersprungeneObjekte.size());
            this.loggeUndZeigeText("nicht eingefuegte Objekte: " + this.nichtEingefuegteObjekte.size());
            this.loggeUndZeigeText(this.nichtEingefuegteObjekte.toString());
            this.importDialog.setStartButtonEnabled(true);
            this.importDialog.setCursurWait(false);
            return true;
        }
        catch (UnsupportedCSVSchemaVersionException unsupportedCSVSchemaVersionException) {
            this.importDialog.appendOutput(this.i18n.getString("db_f47"));
            this.importDialog.appendOutput(this.i18n.getString("db_f4_titel") + ": " + unsupportedCSVSchemaVersionException.toString());
            this.importDialog.setStartButtonEnabled(true);
            this.importDialog.setCursurWait(false);
            return false;
        }
        catch (InvalidImportFileException invalidImportFileException) {
            this.importDialog.appendOutput(invalidImportFileException.toString());
            this.importDialog.setStartButtonEnabled(true);
            this.importDialog.setCursurWait(false);
            return false;
        }
        catch (Exception exception) {
            this.logger.error(exception);
            this.importDialog.appendOutput(this.i18n.getString("db_f47"));
            this.importDialog.appendOutput(this.i18n.getString("db_f4_titel") + ": " + exception.toString());
            this.importDialog.setStartButtonEnabled(true);
            this.importDialog.setCursurWait(false);
            return false;
        }
    }

    private void importSingleLine(String string, TsvServiceLocator tsvServiceLocator, Map<String, Map<List<String>, Double>> map) {
        PlanetensucheObjekt planetensucheObjekt = null;
        try {
            String string2 = string.trim();
            if (Check.isEmpty(string2) || string2.startsWith(this.ignorierenzeichen)) {
                return;
            }
            String[] stringArray = string2.split(this.trennzeichen, -1);
            if (this.isLineInvalid(string2, stringArray)) {
                return;
            }
            ObjektKategorie objektKategorie = this.extractCategory();
            Set<String> set = this.parseIdentifiersFromLine(stringArray, map, objektKategorie);
            if (Check.isEmpty(set)) {
                this.logger.warn("CSV/TSV Import: Kein Objektname angegeben! Zeile " + string);
                return;
            }
            Set<String> set2 = this.catalogNamesValidator.validate(set, objektKategorie);
            Set<Integer> set3 = this.findePlanetensucheObjektIds(set2);
            if (set3.size() == 1) {
                var11_12 = this.planetensucheObjektRepository.read(set3.iterator().next());
                planetensucheObjekt = new PlanetensucheObjektPruefer(this.daoHigh, (IPlanetensucheObjekt)var11_12);
                var12_14 = new HashSet<String>();
                var12_14.addAll(var11_12.getObjektNamen());
                var12_14.addAll(set2);
                var13_15 = this.catalogNamesValidator.validate((Collection<String>)var12_14, ObjektKategorie.STERNE);
                if (var12_14.size() != var13_15.size()) {
                    this.logger.warn("Liste von Objektnamen " + var12_14.toString() + " reduziert auf die validen Namen " + var13_15.toString());
                }
                ((PlanetensucheObjektPruefer)planetensucheObjekt).setObjektNamen(var13_15);
            } else if (set3.isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("neues objekt erstellen f\u00fcr " + Arrays.toString(set2.toArray()));
                }
                if (!this.importDialog.objekteHinzufuegen()) {
                    this.uebersprungeneObjekte.add(set2.iterator().next());
                    this.logger.debug("CSV/TSV Import: '" + set2.iterator().next() + "' uebersprungen (hinzuf\u00fcgen deaktiviert)...");
                    return;
                }
                planetensucheObjekt = new PlanetensucheObjektPruefer(this.daoHigh);
                ((PlanetensucheObjektPruefer)planetensucheObjekt).setObjektNamen(set2);
            } else {
                if (this.logger.isDebugEnabled()) {
                    var11_12 = "es gibt " + set3.size() + " datenIds f\u00fcr " + Arrays.toString(set2.toArray());
                    this.logger.debug(var11_12);
                }
                this.logger.warn("CSV/TSV Import: '" + set2.toString() + "' verweist auf verschiedene Objekte!");
                this.logger.debug(set3.toString());
                var11_12 = new StringBuilder();
                set3.forEach(arg_0 -> this.lambda$importSingleLine$0((StringBuilder)var11_12, arg_0));
                this.logger.warn("Objekte in DB: " + ((StringBuilder)var11_12).toString());
                var12_14 = this.merger.checkAndMerge(set3);
                planetensucheObjekt = new PlanetensucheObjektPruefer(this.daoHigh, (IPlanetensucheObjekt)var12_14);
                var13_15 = new HashSet<String>();
                var13_15.addAll(planetensucheObjekt.getObjektNamen());
                var13_15.addAll(set2);
                ((PlanetensucheObjektPruefer)planetensucheObjekt).setObjektNamen(var13_15);
            }
            if (planetensucheObjekt.getDatenid() == null || this.importDialog.objekteErsetzen() || this.importDialog.objekteUpdaten()) {
                planetensucheObjekt.setCategory(objektKategorie);
                if (objektKategorie.equals((Object)ObjektKategorie.STERNE)) {
                    ((PlanetensucheObjektPruefer)planetensucheObjekt).setObjekttyp(StarObjectType.SINGLE_STAR.getTypeName());
                }
                if (!"nein".equals(this.autor)) {
                    planetensucheObjekt.setAutor(this.autor);
                }
            }
            double d = -100.0;
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (TSVSpaltenTyp.SPALTE_IGNORIEREN.name().equals(this.spaltenBezeichnung[i]) || TSVSpaltenTyp.BEZEICHNUNG_EIGENNAME.name().equals(this.spaltenBezeichnung[i]) || this.spaltenBezeichnung[i].startsWith(TSVSpaltenTyp.KATALOG_NR.name()) || TSVSpaltenTyp.KOMPONENTE.name().equals(this.spaltenBezeichnung[i]) || !Check.isFilled(stringArray[i])) continue;
                if (TSVSpaltenTyp.B_MAG.name().equals(this.spaltenBezeichnung[i])) {
                    d = Double.parseDouble(stringArray[i]);
                    continue;
                }
                if (TSVSpaltenTyp.NOTIZ.name().equals(this.spaltenBezeichnung[i])) {
                    this.logger.warn("Notiz '" + stringArray[i] + "' wird ignoriert!");
                    continue;
                }
                try {
                    ITsvCommand iTsvCommand = tsvServiceLocator.getService(this.spaltenBezeichnung[i]);
                    iTsvCommand.execute(planetensucheObjekt, stringArray[i]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.logger.warn(illegalArgumentException);
                }
            }
            this.calculateBV((PlanetensucheObjektPruefer)planetensucheObjekt, d);
            this.speicherePlanetensucheObjekt((PlanetensucheObjektPruefer)planetensucheObjekt);
        }
        catch (Exception exception) {
            this.logger.error("Fehler in Zeile " + string, exception);
            if (planetensucheObjekt != null) {
                this.nichtEingefuegteObjekte.add(planetensucheObjekt.getObjektNamen().get(0));
            }
            this.importDialog.appendOutput(this.i18n.getString("db_f49") + " " + this.getAktuelleZeile());
        }
    }

    private void calculateBV(PlanetensucheObjektPruefer planetensucheObjektPruefer, double d) {
        try {
            if (!planetensucheObjektPruefer.isScheinbareHelligkeitUnbekannt() && d != -100.0 && (this.importDialog.objekteErsetzen() || this.importDialog.objekteHinzufuegen() || this.importDialog.objekteUpdaten())) {
                double d2 = d - planetensucheObjektPruefer.getScheinbareHelligkeit();
                planetensucheObjektPruefer.setBV((double)Math.round(d2 * 1000.0) / 1000.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.error("Berechnung der B-V (" + d + " mag," + planetensucheObjektPruefer.getScheinbareHelligkeit() + " mag) fehlerhaft:", numberFormatException);
        }
    }

    private Set<String> parseIdentifiersFromLine(String[] stringArray, Map<String, Map<List<String>, Double>> map, ObjektKategorie objektKategorie) throws SQLException, IOException {
        String string;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (TSVSpaltenTyp.SPALTE_IGNORIEREN.name().equals(this.spaltenBezeichnung[i]) || !Check.isFilled(stringArray[i])) continue;
            if (TSVSpaltenTyp.BEZEICHNUNG_EIGENNAME.name().equals(this.spaltenBezeichnung[i])) {
                arrayList.add(stringArray[i].replace('\"', ' ').trim());
                continue;
            }
            if (this.spaltenBezeichnung[i].startsWith(TSVSpaltenTyp.KATALOG_NR.name())) {
                String string3 = ImportthreadTSV.getKatalogAbkuertzung(this.spaltenBezeichnung[i]);
                arrayList2.add(this.catalogBuilderService.buildCatalogEntry(string3, stringArray[i].trim()));
                continue;
            }
            if (!TSVSpaltenTyp.KOMPONENTE.name().equals(this.spaltenBezeichnung[i])) continue;
            string2 = stringArray[i];
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string4 : arrayList) {
            object = string4;
            if (Check.isFilled(string2)) {
                object = (String)object + " " + string2;
            }
            string = this.getObjektnameMitKomponente(map, (String)object, arrayList2);
            String string5 = this.fixNames.korrigiereNamen(string);
            hashSet.add(string5);
        }
        for (String string4 : arrayList2) {
            object = string4;
            if (Check.isFilled(string2)) {
                object = (String)object + string2;
            }
            string = this.korrigiereObjektnamen((String)object, objektKategorie, map, arrayList2);
            hashSet.add(string);
        }
        return hashSet;
    }

    private String getObjektnameMitKomponente(Map<String, Map<List<String>, Double>> map, String string, List<String> list) throws SQLException {
        String string22;
        if (Check.isEmpty(list)) {
            return string;
        }
        Map<List<String>, Double> map2 = map.get(string);
        if (map2 == null || map2.size() == 1) {
            return string;
        }
        List<String> list2 = Arrays.asList("A", "B", "C", "D", "E", "F");
        for (String string22 : list) {
            if (!string22.startsWith("BD+") && !string22.startsWith("BD-") && !string22.startsWith("CD-")) continue;
            String string3 = string22.substring(string22.length() - 1);
            if (!list2.contains(string3)) break;
            this.logger.debug("detect " + string22 + " and use " + string3 + " as star component");
            return this.objektnamenMitKomponentenBauer.setzteObjektnamenZusammen(string, string3);
        }
        ArrayList<Map.Entry<List<String>, Double>> arrayList = new ArrayList<Map.Entry<List<String>, Double>>(map2.entrySet());
        arrayList.sort(Map.Entry.comparingByValue());
        string22 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Map.Entry entry = (Map.Entry)arrayList.get(i);
            if (!((List)entry.getKey()).contains(list.get(0))) continue;
            string22 = list2.get(i);
            break;
        }
        return this.objektnamenMitKomponentenBauer.setzteObjektnamenZusammen(string, string22);
    }

    private void speicherePlanetensucheObjekt(PlanetensucheObjektPruefer planetensucheObjektPruefer) throws SQLException, InterruptedException, IOException {
        if (Check.isEmpty(planetensucheObjektPruefer.getObjektNamen())) {
            throw new IllegalArgumentException("bezeichnungen fehlen");
        }
        if (this.importDialog.umleitungInXML()) {
            this.psobjekteFuerXML.add(planetensucheObjektPruefer);
        } else if (!this.importDialog.test() && planetensucheObjektPruefer.isGeaendert()) {
            if (planetensucheObjektPruefer.getDatenid() != null) {
                planetensucheObjektPruefer.setStamp(new Timestamp(System.currentTimeMillis()));
                this.planetensucheObjektRepository.update(planetensucheObjektPruefer, true, this.injectionDto.getKatalogerkenner());
                this.erfolgreichGespeicherteObjekte.add(planetensucheObjektPruefer.getObjektNamen().get(0));
            } else {
                this.planetensucheObjektRepository.create(planetensucheObjektPruefer, true, this.injectionDto.getKatalogerkenner());
                this.erfolgreichGespeicherteObjekte.add(planetensucheObjektPruefer.getObjektNamen().get(0));
            }
        } else {
            this.uebersprungeneObjekte.add(planetensucheObjektPruefer.getObjektNamen().get(0));
            this.logger.trace("CSV/TSV Import: '" + planetensucheObjektPruefer.getObjektNamen().get(0) + "' \u00fcbersprungen; objekt nicht ge\u00e4ndert...");
        }
    }

    private Set<Integer> findePlanetensucheObjektIds(Set<String> set) throws SQLException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(this.objektnamenRepository.getIdsFuerNamen(set));
        for (String string : set) {
            if (!string.startsWith("FK4 ") && !string.startsWith("FK5 ") && !string.startsWith("FK6 ")) continue;
            String string2 = string.substring(3).trim();
            hashSet.addAll(this.objektnamenRepository.getIdsFuerNamen(Arrays.asList("FK4 " + string2, "FK5 " + string2, "FK6 " + string2)));
        }
        return hashSet;
    }

    private void loggeUndZeigeText(String string) {
        this.importDialog.appendOutput(string);
        this.logger.info(string);
    }

    private void erkenneTSVDateiaufbau() throws IOException {
        List<String> list = Files.readLines(new File(new File("").getAbsolutePath() + "/temp" + File.separator + "csv_schema.txt"), Charset.forName("UTF-8"));
        boolean bl = false;
        for (String string : list) {
            if ("version=:=2".equals(string)) {
                bl = true;
                continue;
            }
            if (string.startsWith("anzahl=:=")) {
                this.spaltenanzahl = Integer.parseInt(string.substring(9, string.length()));
                this.spaltenBezeichnung = new String[this.spaltenanzahl];
                continue;
            }
            if (string.startsWith("trenner=:=")) {
                this.trennzeichen = string.substring(10, string.length());
                continue;
            }
            if (string.startsWith("ignorieren=:=")) {
                this.ignorierenzeichen = string.substring(13, string.length());
                continue;
            }
            if (string.startsWith("kategorie=:=")) {
                this.kategorie = string.substring(12, string.length());
                continue;
            }
            if (string.startsWith("autor=:=")) {
                this.autor = string.substring(8, string.length());
                continue;
            }
            if (string.indexOf("=:=") <= -1) continue;
            String[] stringArray = string.split("=:=");
            this.spaltenBezeichnung[Integer.parseInt((String)stringArray[0]) - 1] = stringArray[1];
        }
        if (!bl) {
            throw new UnsupportedCSVSchemaVersionException("Version ist veraltet: bitte neues CSV-Schema erzeugen");
        }
    }

    protected static String getKatalogAbkuertzung(String string) {
        String string2 = string.substring(LAENGE_KATALOG_NR, string.length());
        if ("bayer".equalsIgnoreCase(string2) || "flamsteed".equalsIgnoreCase(string2)) {
            return "";
        }
        return string2;
    }

    private String korrigiereObjektnamen(String string, ObjektKategorie objektKategorie, Map<String, Map<List<String>, Double>> map, List<String> list) throws IOException, SQLException {
        if (Check.isEmpty(list)) {
            return string;
        }
        Object object = string;
        if (((String)object).startsWith("CP-")) {
            object = ((String)object).replace("CP-", "CPD-");
        }
        if (((String)(object = this.getObjektnameMitKomponente(map, string, list))).startsWith("KOI") && objektKategorie.equals((Object)ObjektKategorie.STERNE)) {
            int n = ((String)object).indexOf(".");
            if (n > 3) {
                object = "KOI-" + ((String)object).substring(n);
            }
        } else {
            object = this.fixNames.korrigiereNamen((String)object);
        }
        return object;
    }

    private ImportOption resolveImportOption() {
        if (this.importDialog.objekteErsetzen()) {
            return ImportOption.ERSETZEN;
        }
        if (this.importDialog.objekteErgaenzen()) {
            return ImportOption.ERGAENZEN;
        }
        return ImportOption.UPDATEN;
    }

    private ObjektKategorie extractCategory() {
        if (!"nein".equals(this.kategorie)) {
            if (this.i18n.isAktuelleSpracheDeutsch()) {
                return ObjektKategorie.parse(this.kategorie);
            }
            return ObjektKategorie.parse(this.i18n.getUebersetzungEnglischInDeutsch(this.kategorie));
        }
        return ObjektKategorie.parse(this.kategorie);
    }

    private boolean isLineInvalid(String string, String[] stringArray) {
        int n = string.indexOf(this.trennzeichen);
        if (n == -1) {
            String string2 = this.i18n.getString("db_m187") + " " + this.getAktuelleZeile() + " " + this.i18n.getString("db_m188");
            this.logger.warn(string2);
            this.importDialog.appendOutput(string2);
            return true;
        }
        if (stringArray.length != this.spaltenanzahl) {
            String string3 = this.i18n.getString("db_m189_1") + " " + this.getAktuelleZeile() + " " + this.i18n.getString("db_m189_2") + stringArray.length + this.i18n.getString("db_m189_3") + this.spaltenanzahl + this.i18n.getString("db_m189_4");
            this.logger.warn(string3);
            this.importDialog.appendOutput(string3);
            return true;
        }
        return false;
    }

    private /* synthetic */ void lambda$importSingleLine$0(StringBuilder stringBuilder, Integer n) {
        stringBuilder.append(this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.ALPHABETISCH).toString()).append(" & ");
    }
}

