/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport;

import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbank.importierer.helfer.KorrigiereSpektraltyp;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvCommand;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvServiceFactory;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOption;
import de.planetensuche.datenbank.importierer.tsvimport.commands.deepsky.TsvServiceFactoryDeepSky;
import de.planetensuche.datenbank.importierer.tsvimport.commands.entfernungen.TsvServiceFactoryEntfernungen;
import de.planetensuche.datenbank.importierer.tsvimport.commands.helligkeiten.TsvServiceFactoryHelligkeiten;
import de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten.TsvServiceFactoryKoordinaten;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.TsvServiceFactoryRest;
import de.planetensuche.datenbank.importierer.tsvimport.commands.sptyplk.TsvServiceFactorySptypLk;
import java.util.ArrayList;
import java.util.List;

public final class TsvServiceLocator {
    private static TsvServiceLocator serviceLocator;
    private final TsvServiceFactoryDeepSky factoryDeepSky;
    private final TsvServiceFactoryEntfernungen factoryEntfernungen;
    private final TsvServiceFactoryHelligkeiten factoryHelligkeiten;
    private final TsvServiceFactoryKoordinaten factoryKoordinaten;
    private final TsvServiceFactorySptypLk factorySptypLk;
    private final TsvServiceFactoryRest factoryRest;
    private final List<ITsvServiceFactory> factories;
    private final ImportOption importOption;

    private TsvServiceLocator(ImportOption importOption, KorrigiereSpektraltyp korrigiereSpektraltyp, IImportDialog iImportDialog) {
        this.importOption = importOption;
        this.factoryDeepSky = new TsvServiceFactoryDeepSky(importOption);
        this.factoryEntfernungen = new TsvServiceFactoryEntfernungen(importOption);
        this.factoryHelligkeiten = new TsvServiceFactoryHelligkeiten(importOption);
        this.factoryKoordinaten = new TsvServiceFactoryKoordinaten(importOption, iImportDialog);
        this.factorySptypLk = new TsvServiceFactorySptypLk(importOption, korrigiereSpektraltyp);
        this.factoryRest = new TsvServiceFactoryRest(importOption);
        this.factories = new ArrayList<ITsvServiceFactory>(6);
        this.factories.add(this.factoryRest);
        this.factories.add(this.factoryEntfernungen);
        this.factories.add(this.factoryHelligkeiten);
        this.factories.add(this.factoryKoordinaten);
        this.factories.add(this.factorySptypLk);
        this.factories.add(this.factoryDeepSky);
    }

    public static synchronized TsvServiceLocator getInstance(ImportOption importOption, KorrigiereSpektraltyp korrigiereSpektraltyp, IImportDialog iImportDialog) {
        if (serviceLocator == null || importOption != serviceLocator.getImportOption()) {
            serviceLocator = new TsvServiceLocator(importOption, korrigiereSpektraltyp, iImportDialog);
        }
        return serviceLocator;
    }

    public ITsvCommand getService(String string) {
        for (ITsvServiceFactory iTsvServiceFactory : this.factories) {
            ITsvCommand iTsvCommand = iTsvServiceFactory.getService(string);
            if (iTsvCommand == null) continue;
            return iTsvCommand;
        }
        throw new IllegalArgumentException("'" + string + "' ist ein unbekannter Typ");
    }

    public ImportOption getImportOption() {
        return this.importOption;
    }
}

