/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport.commands.deepsky;

import de.planetensuche.datenbank.importierer.api.TSVSpaltenTyp;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvCommand;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvServiceFactory;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOption;
import de.planetensuche.datenbank.importierer.tsvimport.commands.deepsky.GalaxienartCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.deepsky.GalaxienformCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.deepsky.NebelformCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.deepsky.RotverschiebungCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.deepsky.SternentstehungCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.deepsky.WahrerDurchmesserCommand;

public class TsvServiceFactoryDeepSky
implements ITsvServiceFactory {
    private final GalaxienartCommand galaxienartCommand;
    private final GalaxienformCommand galaxienformCommand;
    private final NebelformCommand nebelformCommand;
    private final RotverschiebungCommand rotverschiebungCommand;
    private final SternentstehungCommand sternentstehungCommand;
    private final WahrerDurchmesserCommand wahrerDurchmesserCommand;

    public TsvServiceFactoryDeepSky(ImportOption importOption) {
        this.wahrerDurchmesserCommand = new WahrerDurchmesserCommand(importOption);
        this.galaxienartCommand = new GalaxienartCommand(importOption);
        this.galaxienformCommand = new GalaxienformCommand(importOption);
        this.nebelformCommand = new NebelformCommand(importOption);
        this.rotverschiebungCommand = new RotverschiebungCommand(importOption);
        this.sternentstehungCommand = new SternentstehungCommand(importOption);
    }

    @Override
    public ITsvCommand getService(String string) {
        ITsvCommand iTsvCommand = null;
        if (TSVSpaltenTyp.WAHRER_DURCHMESSER_LY.toString().equals(string)) {
            iTsvCommand = this.wahrerDurchmesserCommand;
        } else if (TSVSpaltenTyp.GALAXIENART.toString().equals(string)) {
            iTsvCommand = this.galaxienartCommand;
        } else if (TSVSpaltenTyp.GALAXIENFORM.toString().equals(string)) {
            iTsvCommand = this.galaxienformCommand;
        } else if (TSVSpaltenTyp.NEBELFORM.toString().equals(string)) {
            iTsvCommand = this.nebelformCommand;
        } else if (TSVSpaltenTyp.ROTVERSCHIEBUNG.toString().equals(string)) {
            iTsvCommand = this.rotverschiebungCommand;
        } else if (TSVSpaltenTyp.STERNENTSTEHUNG_JAHR.toString().equals(string)) {
            iTsvCommand = this.sternentstehungCommand;
        }
        return iTsvCommand;
    }
}

