/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport.commands.entfernungen;

import de.planetensuche.datenbank.importierer.api.TSVSpaltenTyp;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvCommand;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvServiceFactory;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOption;
import de.planetensuche.datenbank.importierer.tsvimport.commands.entfernungen.EntfernungKPcCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.entfernungen.EntfernungLyCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.entfernungen.EntfernungPcCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.entfernungen.ParallaxeBogensekundenCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.entfernungen.ParallaxeCommand;

public class TsvServiceFactoryEntfernungen
implements ITsvServiceFactory {
    private final EntfernungLyCommand entfernungLyC;
    private final EntfernungPcCommand entfernungPcC;
    private final EntfernungKPcCommand entfernungKPcC;
    private final ParallaxeCommand parallaxeCommand;
    private final ParallaxeBogensekundenCommand parallaxeBogensekundenCommand;

    public TsvServiceFactoryEntfernungen(ImportOption importOption) {
        this.entfernungLyC = new EntfernungLyCommand(importOption);
        this.entfernungPcC = new EntfernungPcCommand(importOption);
        this.entfernungKPcC = new EntfernungKPcCommand(importOption);
        this.parallaxeCommand = new ParallaxeCommand(importOption);
        this.parallaxeBogensekundenCommand = new ParallaxeBogensekundenCommand(importOption);
    }

    @Override
    public ITsvCommand getService(String string) {
        ITsvCommand iTsvCommand = null;
        if (TSVSpaltenTyp.ENTFERNUNG_LY.toString().equals(string)) {
            iTsvCommand = this.entfernungLyC;
        } else if (TSVSpaltenTyp.ENTFERNUNG_PC.toString().equals(string)) {
            iTsvCommand = this.entfernungPcC;
        } else if (TSVSpaltenTyp.ENTFERNUNG_KPC.toString().equals(string)) {
            iTsvCommand = this.entfernungKPcC;
        } else if (TSVSpaltenTyp.PARALLAXE.toString().equals(string)) {
            iTsvCommand = this.parallaxeCommand;
        } else if (TSVSpaltenTyp.PARALLAXE_BOGENSEKUNDEN.toString().equals(string)) {
            iTsvCommand = this.parallaxeBogensekundenCommand;
        }
        return iTsvCommand;
    }
}

