/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvCommand;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOption;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOptionHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import java.sql.SQLException;

public class DECLStundenMinutenSekundenCommand
implements ITsvCommand {
    private final IImportDialog ijf;
    private final ILogging logging;
    private final ImportOption importOption;

    protected DECLStundenMinutenSekundenCommand(ImportOption importOption, IImportDialog iImportDialog) {
        this.ijf = iImportDialog;
        this.logging = LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
        this.importOption = importOption;
    }

    @Override
    public boolean execute(IPlanetensucheObjekt iPlanetensucheObjekt, String string) throws SQLException {
        if (ImportOptionHelper.useNewData(this.importOption, iPlanetensucheObjekt.isDeclUnbekannt(), Check.isFilled(string))) {
            try {
                String[] stringArray = string.split(" ");
                double d = Double.parseDouble(stringArray[0]);
                double d2 = Double.parseDouble(stringArray[1]);
                double d3 = 0.0;
                if (stringArray.length == 3) {
                    d3 = Double.parseDouble(stringArray[2]) / 3600.0;
                }
                double d4 = d < 0.0 ? ((d *= -1.0) + d2 / 60.0 + d3) * -1.0 : d + d2 / 60.0 + d3;
                return iPlanetensucheObjekt.setDECL(d4);
            }
            catch (NumberFormatException numberFormatException) {
                this.ijf.appendOutput("DECL: " + string + " " + numberFormatException.toString());
                this.logging.warn(numberFormatException);
            }
        }
        return false;
    }
}

