/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvCommand;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOption;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOptionHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import java.sql.SQLException;

public class RA24StundenCommand
implements ITsvCommand {
    private final IImportDialog ijf;
    private final ILogging logging;
    private final ImportOption importOption;

    protected RA24StundenCommand(ImportOption importOption, IImportDialog iImportDialog) {
        this.ijf = iImportDialog;
        this.logging = LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
        this.importOption = importOption;
    }

    @Override
    public boolean execute(IPlanetensucheObjekt iPlanetensucheObjekt, String string) throws SQLException {
        if (ImportOptionHelper.useNewData(this.importOption, iPlanetensucheObjekt.isRaUnbekannt(), Check.isFilled(string))) {
            try {
                return iPlanetensucheObjekt.setRA(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.ijf.appendOutput("RA : " + string + " " + numberFormatException.toString());
                this.logging.warn(numberFormatException);
            }
        }
        return false;
    }
}

