/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvCommand;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOption;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOptionHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import java.sql.SQLException;

public class RA360StundenCommand
implements ITsvCommand {
    private final IImportDialog ijf;
    private final ILogging logging;
    private final ImportOption importOption;

    protected RA360StundenCommand(ImportOption importOption, IImportDialog iImportDialog) {
        this.ijf = iImportDialog;
        this.logging = LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
        this.importOption = importOption;
    }

    @Override
    public boolean execute(IPlanetensucheObjekt iPlanetensucheObjekt, String string) throws SQLException {
        if (ImportOptionHelper.useNewData(this.importOption, iPlanetensucheObjekt.isRaUnbekannt(), Check.isFilled(string))) {
            try {
                return iPlanetensucheObjekt.setRA(Double.parseDouble(string) / 360.0 * 24.0);
            }
            catch (Exception exception) {
                this.ijf.appendOutput("RA : " + string + " " + exception.toString());
                this.logging.warn(exception);
            }
        }
        return false;
    }
}

