/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten;

import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbank.importierer.api.TSVSpaltenTyp;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvCommand;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvServiceFactory;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOption;
import de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten.DECLGradStundenCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten.DECLStundenMinutenSekundenCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten.RA24StundenCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten.RA360StundenCommand;
import de.planetensuche.datenbank.importierer.tsvimport.commands.koordinaten.RAStundenMinutenSekundenCommand;

public class TsvServiceFactoryKoordinaten
implements ITsvServiceFactory {
    private final RAStundenMinutenSekundenCommand raHHMMSSCommand;
    private final RA24StundenCommand ra24StundenCommand;
    private final RA360StundenCommand ra360StundenCommand;
    private final DECLStundenMinutenSekundenCommand declHHMMSSCommand;
    private final DECLGradStundenCommand declGradStundenCommand;

    public TsvServiceFactoryKoordinaten(ImportOption importOption, IImportDialog iImportDialog) {
        this.raHHMMSSCommand = new RAStundenMinutenSekundenCommand(importOption, iImportDialog);
        this.ra24StundenCommand = new RA24StundenCommand(importOption, iImportDialog);
        this.ra360StundenCommand = new RA360StundenCommand(importOption, iImportDialog);
        this.declHHMMSSCommand = new DECLStundenMinutenSekundenCommand(importOption, iImportDialog);
        this.declGradStundenCommand = new DECLGradStundenCommand(importOption, iImportDialog);
    }

    @Override
    public ITsvCommand getService(String string) {
        ITsvCommand iTsvCommand = null;
        if (TSVSpaltenTyp.RA_HH_MM_SS.toString().equals(string)) {
            iTsvCommand = this.raHHMMSSCommand;
        } else if (TSVSpaltenTyp.RA_24STUNDEN.toString().equals(string)) {
            iTsvCommand = this.ra24StundenCommand;
        } else if (TSVSpaltenTyp.RA_360STUNDEN.toString().equals(string)) {
            iTsvCommand = this.ra360StundenCommand;
        } else if (TSVSpaltenTyp.DECL_HH_MM_SS.toString().equals(string)) {
            iTsvCommand = this.declHHMMSSCommand;
        } else if (TSVSpaltenTyp.DECL_GRADSTUNDEN.toString().equals(string)) {
            iTsvCommand = this.declGradStundenCommand;
        }
        return iTsvCommand;
    }
}

