/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport.commands.rest;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.importierer.tsvimport.api.ITsvCommand;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOption;
import de.planetensuche.datenbank.importierer.tsvimport.api.ImportOptionHelper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.BedeckungsveraenderlicherKandidatMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.BedeckungsveraenderlicherMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.BraunerZwergMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.DoppelOderMehrfachsternMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.NeutronensternMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.NovaMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.PulsarMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.SimbadObjektTypMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.SternUnmapbarMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.VeraenderlicherHalbregelmaessigMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.VeraenderlicherKurzperiodischMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.VeraenderlicherLangperiodischMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.VeraenderlicherUnbekannterTypMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.VeraenderlicherUnregelmaessigMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.WeisserZwergMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.WolfRayetSternMapper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class ObjekttypSimbadCommand
implements ITsvCommand {
    private static final List<SimbadObjektTypMapper> MAPPER = Arrays.asList(new BraunerZwergMapper(), new DoppelOderMehrfachsternMapper(), new WolfRayetSternMapper(), new SternUnmapbarMapper(), new NovaMapper(), new PulsarMapper(), new VeraenderlicherUnbekannterTypMapper(), new VeraenderlicherUnregelmaessigMapper(), new VeraenderlicherKurzperiodischMapper(), new VeraenderlicherLangperiodischMapper(), new VeraenderlicherHalbregelmaessigMapper(), new WeisserZwergMapper(), new NeutronensternMapper(), new BedeckungsveraenderlicherMapper(), new BedeckungsveraenderlicherKandidatMapper());
    private final ImportOption importOption;
    private final ILogging logger;

    protected ObjekttypSimbadCommand(ImportOption importOption) {
        this.importOption = importOption;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
    }

    @Override
    public boolean execute(IPlanetensucheObjekt iPlanetensucheObjekt, String string) throws SQLException {
        if (ImportOptionHelper.useNewData(this.importOption, iPlanetensucheObjekt.getObjekttyp().isEmpty(), Check.isFilled(string))) {
            String string2 = string.replace('\"', ' ').trim();
            for (SimbadObjektTypMapper simbadObjektTypMapper : MAPPER) {
                if (!simbadObjektTypMapper.istZustaendig(string2)) continue;
                simbadObjektTypMapper.mapTo(iPlanetensucheObjekt, string2);
                return true;
            }
            this.logger.warn("Simbad Objekttyp nicht erkannt: '" + string2 + "'");
        }
        return false;
    }
}

