/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.SimbadObjektTypMapper;
import java.sql.SQLException;

public class DoppelOderMehrfachsternMapper
implements SimbadObjektTypMapper {
    @Override
    public boolean istZustaendig(String string) {
        return this.istDoppelstern(string) || this.istMehrfachstern(string);
    }

    private boolean istDoppelstern(String string) {
        switch (string) {
            case "SB*": 
            case "SB?": 
            case "Spectroscopic binary": 
            case "Spectroscopic Binary": 
            case "BY*": 
            case "BY?": 
            case "BY Dra Variable": 
            case "RS*": 
            case "RS?": 
            case "RS CVn Variable": 
            case "Sy*": 
            case "Sy?": 
            case "Symbiotic Star": 
            case "XB*": 
            case "XB?": 
            case "X-ray Binary": 
            case "LXB": 
            case "LX?": 
            case "Low Mass X-ray Binary": 
            case "HXB": 
            case "HX?": 
            case "High Mass X-ray Binary": 
            case "*i*": 
            case "Star in double system": 
            case "CV*": 
            case "CV?": 
            case "Cataclysmic Binary": 
            case "No*": 
            case "No?": 
            case "Classical Nova": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void mapTo(IPlanetensucheObjekt iPlanetensucheObjekt, String string) throws SQLException {
        iPlanetensucheObjekt.setKategorie(ObjektKategorie.STERNE.getKategorienName());
        if (this.istDoppelstern(string)) {
            iPlanetensucheObjekt.setObjekttyp(StarObjectType.DOUBLE_STAR_REAL.getTypeName());
        } else if (this.istMehrfachstern(string)) {
            iPlanetensucheObjekt.setObjekttyp(StarObjectType.MULTI_STAR_SYSTEM.getTypeName());
        }
    }

    private boolean istMehrfachstern(String string) {
        switch (string) {
            case "**": 
            case "**?": 
            case "Double or multiple star": 
            case "Double or Multiple Star": {
                return true;
            }
        }
        return false;
    }
}

