/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.validator;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.importierer.validator.DoubleStarConstants;
import de.planetensuche.datenbank.importierer.validator.InvalidCatalogException;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class CatalogNamesValidator {
    private static final String FILENAME_SKIPED_OBJECTNAMES = "logs/exoplanet_import_skiped_objectnames.log";
    final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final Katalogerkenner katalogerkenner;

    public CatalogNamesValidator(Katalogerkenner katalogerkenner) {
        new File(FILENAME_SKIPED_OBJECTNAMES).delete();
        this.katalogerkenner = katalogerkenner;
    }

    public Set<String> validate(Collection<String> collection, ObjektKategorie objektKategorie) throws InvalidCatalogException {
        Set<String> set = new HashSet<String>();
        for (String string : collection) {
            set.add(string.replaceAll("  ", " "));
        }
        set = this.checkDoubleStarNamingClash(set);
        Set<String> set2 = this.getValidObjectNames(set, objektKategorie);
        this.checkForMultipleCatalogEntries(set2);
        return set2;
    }

    private void checkForMultipleCatalogEntries(Set<String> set) throws InvalidCatalogException {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            String string2 = this.katalogerkenner.getKatalogNameFromObjectName(string);
            if (string2 != null) {
                if (this.isDuplicated(hashSet, string2, set)) {
                    throw new InvalidCatalogException("catalog name " + string2 + " for object name " + string + " was used two times (all names are " + String.valueOf(set) + ")");
                }
                hashSet.add(string2);
                continue;
            }
            if (this.katalogerkenner.isCommonName(string)) {
                this.logging.debug("detect common name '" + string + "'");
                continue;
            }
            if (this.katalogerkenner.isKnownCatalog(string)) {
                this.logging.warn("catalog format not detected for object name " + string);
                continue;
            }
            this.logging.warn("no catalog found for object name " + string + " (unknown catalog?)");
        }
    }

    private boolean isDuplicated(Set<String> set, String string, Set<String> set2) {
        boolean bl;
        block25: {
            block24: {
                block28: {
                    block27: {
                        block26: {
                            long l;
                            bl = set.contains(string);
                            if (!bl) {
                                return false;
                            }
                            if (!string.equals("TIC")) break block24;
                            bl = this.isDuplicatedPlanetNumberOrChar(set2, string);
                            if (!bl || (l = set2.stream().filter(string2 -> string2.startsWith(string)).count()) != 2L) break block25;
                            if (!set2.contains("TIC 290172418") || !set2.contains("TIC 632528291")) break block26;
                            bl = false;
                            break block25;
                        }
                        if (!set2.contains("TIC 16855") || !set2.contains("TIC 1056530200")) break block27;
                        bl = false;
                        break block25;
                    }
                    if (!set2.contains("TIC 1101862696") || !set2.contains("TIC 471011913")) break block28;
                    bl = false;
                    break block25;
                }
                if (!set2.contains("TIC 1259690584") || !set2.contains("TIC 9676357")) break block25;
                bl = false;
                break block25;
            }
            if (string.equals("KOI") || string.equals("EPIC") || string.equals("TOI")) {
                bl = this.isDuplicatedPlanetNumberOrChar(set2, string);
            } else if (string.equals("GJ")) {
                bl = this.isDuplicatedGjCatalog(set2);
            } else if (string.equals("HD") && this.istHdSpektroskopischerDoppelstern(set2)) {
                bl = false;
            } else if (string.equals("CD") && this.istCdKatalogFehler(set2)) {
                bl = false;
            } else if (string.equals("BD") && this.istBdKatalogFehler(set2)) {
                bl = false;
            } else if (string.equals("CPD") && this.istCpdKatalogFehler(set2)) {
                bl = false;
            } else if (string.equals("SAO") && this.istSaoKatalogFehler(set2)) {
                bl = false;
            } else if (string.equals("USNO")) {
                bl = this.isDuplicatedUsnoCatalog(set2, string);
            } else if (CatalogNamesValidator.katalogInAusnahmenliste(string)) {
                bl = false;
            } else {
                List<String> list = set2.stream().filter(string2 -> string2.startsWith(string) && !this.katalogerkenner.isBayerFlamsteedGcvs2((String)string2)).collect(Collectors.toList());
                String string3 = this.findBaseCatalogEntry(list);
                for (String object : DoubleStarConstants.LETTERS_OF_STAR_COMPONENTS) {
                    int n = 0;
                    for (String string4 : list) {
                        if (!string4.equals(string3) && !string4.equals(string3 + object) && !string4.equals(string3 + " " + object)) continue;
                        ++n;
                    }
                    if (n != list.size()) continue;
                    bl = false;
                    return bl;
                }
                List<String> list2 = Arrays.asList("b", "c", "d", "e", "f", "g", "h");
                for (String string5 : DoubleStarConstants.LETTERS_OF_STAR_COMPONENTS) {
                    int n = 0;
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        String string6 = (String)iterator.next();
                        for (String string7 : list) {
                            if (!string7.equals(string3 + " " + string6) && !string7.equals(string3 + string5 + " " + string6) && !string7.equals(string3 + " " + string5 + " " + string6)) continue;
                            ++n;
                        }
                        if (n != list.size()) continue;
                        bl = false;
                        return bl;
                    }
                }
            }
        }
        return bl;
    }

    private static boolean katalogInAusnahmenliste(String string) {
        boolean bl = string.equals("Mel") || string.equals("NGC");
        boolean bl2 = string.equals("G") || string.equals("LTT") || string.equals("LP") || string.equals("YPAC") || string.equals("DO") || string.equals("JP11") || string.equals("MacC");
        boolean bl3 = string.equalsIgnoreCase("corot") || string.equals("EWS") || string.equals("GSC2") || string.equals("GCRV") || string.equals("GSC") || string.equals("SDSS");
        List<String> list = Arrays.asList("CGCS", "PSR", "CMC", "MLLA", "CSS", "RE", "2RE", "IDS", "LEE", "GAT", "NOVA", "WD", "PM", "PLX");
        return bl2 || bl3 || list.contains(string) || bl;
    }

    private String findBaseCatalogEntry(List<String> list) {
        String string = null;
        block0: for (String string2 : list) {
            if (string == null) {
                for (int i = string2.length() - 1; i >= 0; --i) {
                    char c = string2.charAt(i);
                    if (!Character.isDigit(c)) continue;
                    string = string2.substring(0, i + 1);
                    continue block0;
                }
                continue;
            }
            if (string.length() <= string2.length()) continue;
            string = string2;
        }
        return string;
    }

    private boolean isDuplicatedGjCatalog(Set<String> set) {
        List list = set.stream().filter(string -> string.startsWith("GJ ")).map(string -> {
            try {
                String string2 = string.substring(3);
                return Float.valueOf(Float.parseFloat(string2.substring(0, string2.indexOf(" ") > 0 ? string2.indexOf(" ") : string2.length()).trim()) / 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
                this.logging.error("Fehler beim parsen des GJ Katalogs: '" + string + "'", numberFormatException);
                return null;
            }
        }).collect(Collectors.toList());
        if (list.size() <= 1) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (Float f : list) {
            if (f == null) continue;
            if (f.floatValue() < 1.0f) {
                ++n2;
                continue;
            }
            ++n;
        }
        return !(n == 2 && n2 == 0 || n == 1 && n2 == 1);
    }

    private Set<String> getValidObjectNames(Set<String> set, ObjektKategorie objektKategorie) throws InvalidCatalogException {
        Set<String> set2;
        Set<String> set3 = set2 = set.size() > 5 ? set.parallelStream().filter(string -> this.checkIfObjectIsInKnownCatalog((String)string, objektKategorie, (Collection<String>)set)).collect(Collectors.toSet()) : set.stream().filter(string -> this.checkIfObjectIsInKnownCatalog((String)string, objektKategorie, (Collection<String>)set)).collect(Collectors.toSet());
        if (Check.isEmpty(set2)) {
            throw new InvalidCatalogException("all object names are invalid: " + String.valueOf(set));
        }
        return set2;
    }

    private boolean checkIfObjectIsInKnownCatalog(String string, ObjektKategorie objektKategorie, Collection<String> collection) {
        boolean bl;
        boolean bl2 = bl = this.katalogerkenner.matchCatalogPattern("Eigenname", string) && !this.katalogerkenner.isBayerName(string);
        if (bl) {
            this.logging.debug("detect common name '" + string + "'; skip catalog matching");
            return true;
        }
        boolean bl3 = this.katalogerkenner.isKnownCatalog(string);
        if (bl3) {
            return true;
        }
        this.logging.warn(String.valueOf((Object)objektKategorie) + " name '" + string + "' is invalid or regex not found and will be ignored, other names are " + String.valueOf(collection));
        try {
            String string2 = Instant.now().toString() + ": " + string + " (" + String.valueOf((Object)objektKategorie) + ")\n";
            FileUtils.write(new File(FILENAME_SKIPED_OBJECTNAMES), (CharSequence)string2, "utf8", true);
        }
        catch (IOException iOException) {
            this.logging.error(iOException);
        }
        return false;
    }

    private boolean istHdSpektroskopischerDoppelstern(Set<String> set) {
        boolean bl = this.containsStarPair(set, "HD 218641", "HD 218640");
        boolean bl2 = this.containsStarPair(set, "HD 217675", "HD 217676");
        boolean bl3 = this.containsStarPair(set, "HD 213311", "HD 213310");
        boolean bl4 = this.containsStarPair(set, "HD 206240", "HD 206241");
        boolean bl5 = this.containsStarPair(set, "HD 202448", "HD 202447");
        boolean bl6 = this.containsStarPair(set, "HD 196093", "HD 196094");
        boolean bl7 = this.containsStarPair(set, "HD 195069", "HD 195068");
        boolean bl8 = bl6 || bl7;
        boolean bl9 = this.containsStarPair(set, "HD 193496", "HD 193495");
        boolean bl10 = this.containsStarPair(set, "HD 181615", "HD 181616");
        boolean bl11 = this.containsStarPair(set, "HD 169421", "HD 169420");
        boolean bl12 = bl10 || bl11;
        boolean bl13 = this.containsStarPair(set, "HD 127972", "HD 127973");
        boolean bl14 = this.containsStarPair(set, "HD 29094", "HD 29095");
        boolean bl15 = this.containsStarPair(set, "HD 26673", "HD 26674");
        boolean bl16 = this.containsStarPair(set, "HD 17879", "HD 17878");
        boolean bl17 = bl14 || bl15 || bl16;
        boolean bl18 = this.containsStarPair(set, "HD 195693", "HD 195692");
        boolean bl19 = this.containsStarPair(set, "HD 188042", "HD 188041");
        boolean bl20 = this.containsStarPair(set, "HD 186519", "HD 186518");
        boolean bl21 = this.containsStarPair(set, "HD 169690", "HD 169689");
        boolean bl22 = this.containsStarPair(set, "HD 158394", "HD 158395");
        boolean bl23 = this.containsStarPair(set, "HD 76073", "HD 76072");
        boolean bl24 = this.containsStarPair(set, "HD 39118", "HD 39119");
        boolean bl25 = this.containsStarPair(set, "HD 32068", "HD 32069");
        boolean bl26 = this.containsStarPair(set, "HD 23089", "HD 23090");
        boolean bl27 = this.containsStarPair(set, "HD 16083", "HD 16082");
        boolean bl28 = this.containsStarPair(set, "HD 9352", "HD 9353");
        boolean bl29 = bl18 || bl24 || bl26 || bl27 || bl28;
        boolean bl30 = bl2 || bl8 || bl5 || bl17 || bl29 || bl20 || bl25;
        boolean bl31 = bl21 || bl9 || bl12 || bl19 || bl22;
        boolean bl32 = bl || bl3 || bl4 || bl13 || bl23;
        return bl32 || bl30 || bl31;
    }

    private boolean containsStarPair(Set<String> set, String string, String string2) {
        return set.contains(string) && set.contains(string2);
    }

    private boolean istCdKatalogFehler(Set<String> set) {
        return this.containsStarPair(set, "CD-26 1339", "CD-26 1340") || this.containsStarPair(set, "CD-22 1238", "CD-22 628") || this.containsStarPair(set, "CD-22 1458", "CD-22 3235") || this.containsStarPair(set, "CD-22 3401", "CD-22 9505") || this.containsStarPair(set, "CD-22 15862", "CD-22 5897");
    }

    private boolean istBdKatalogFehler(Set<String> set) {
        return this.containsStarPair(set, "BD-01 3220", "BD-02 4211");
    }

    private boolean istSaoKatalogFehler(Set<String> set) {
        return this.containsStarPair(set, "SAO 67451", "SAO 67452") || this.containsStarPair(set, "SAO 31219", "SAO 31218");
    }

    private boolean istCpdKatalogFehler(Set<String> set) {
        return this.containsStarPair(set, "CPD-26 5583", "CPD-26 5582");
    }

    private boolean isDuplicatedPlanetNumberOrChar(Set<String> set, String string) {
        int n = 0;
        int n2 = 0;
        for (String string2 : set) {
            if (!string2.startsWith(string)) continue;
            if (string2.matches(".*\\.?(01|02|03|04|05|06|07|08|09|10)$")) {
                ++n;
                continue;
            }
            ++n2;
        }
        return n != 1 || n2 != 1;
    }

    private boolean isDuplicatedUsnoCatalog(Set<String> set, String string) {
        int n = 0;
        int n2 = 0;
        for (String string2 : set) {
            if (!string2.startsWith(string)) continue;
            if (string2.matches("^USNO-A.*")) {
                ++n;
                continue;
            }
            if (string2.matches("^USNO-B.*")) {
                ++n2;
                continue;
            }
            throw new UnsupportedOperationException("unknown USNO catalog format " + string2);
        }
        return n != 1 || n2 != 1;
    }

    private Set<String> checkDoubleStarNamingClash(Set<String> set) {
        String string = null;
        for (String object : set) {
            if (!object.endsWith(" A")) continue;
            string = object;
            break;
        }
        if (string == null) {
            return set;
        }
        HashSet hashSet = new HashSet();
        for (String string2 : set) {
            if (string.startsWith(string2)) continue;
            hashSet.add(string2);
        }
        hashSet.add(string);
        return hashSet;
    }
}

